/*

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1beta1 "github.com/kudobuilder/kudo/pkg/apis/kudo/v1beta1"
	scheme "github.com/kudobuilder/kudo/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// OperatorVersionsGetter has a method to return a OperatorVersionInterface.
// A group's client should implement this interface.
type OperatorVersionsGetter interface {
	OperatorVersions(namespace string) OperatorVersionInterface
}

// OperatorVersionInterface has methods to work with OperatorVersion resources.
type OperatorVersionInterface interface {
	Create(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.CreateOptions) (*v1beta1.OperatorVersion, error)
	Update(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.UpdateOptions) (*v1beta1.OperatorVersion, error)
	UpdateStatus(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.UpdateOptions) (*v1beta1.OperatorVersion, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.OperatorVersion, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.OperatorVersionList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OperatorVersion, err error)
	OperatorVersionExpansion
}

// operatorVersions implements OperatorVersionInterface
type operatorVersions struct {
	client rest.Interface
	ns     string
}

// newOperatorVersions returns a OperatorVersions
func newOperatorVersions(c *KudoV1beta1Client, namespace string) *operatorVersions {
	return &operatorVersions{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the operatorVersion, and returns the corresponding operatorVersion object, and an error if there is any.
func (c *operatorVersions) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.OperatorVersion, err error) {
	result = &v1beta1.OperatorVersion{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("operatorversions").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of OperatorVersions that match those selectors.
func (c *operatorVersions) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.OperatorVersionList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.OperatorVersionList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("operatorversions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested operatorVersions.
func (c *operatorVersions) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("operatorversions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a operatorVersion and creates it.  Returns the server's representation of the operatorVersion, and an error, if there is any.
func (c *operatorVersions) Create(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.CreateOptions) (result *v1beta1.OperatorVersion, err error) {
	result = &v1beta1.OperatorVersion{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("operatorversions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(operatorVersion).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a operatorVersion and updates it. Returns the server's representation of the operatorVersion, and an error, if there is any.
func (c *operatorVersions) Update(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.UpdateOptions) (result *v1beta1.OperatorVersion, err error) {
	result = &v1beta1.OperatorVersion{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("operatorversions").
		Name(operatorVersion.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(operatorVersion).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *operatorVersions) UpdateStatus(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.UpdateOptions) (result *v1beta1.OperatorVersion, err error) {
	result = &v1beta1.OperatorVersion{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("operatorversions").
		Name(operatorVersion.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(operatorVersion).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the operatorVersion and deletes it. Returns an error if one occurs.
func (c *operatorVersions) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("operatorversions").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *operatorVersions) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("operatorversions").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched operatorVersion.
func (c *operatorVersions) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OperatorVersion, err error) {
	result = &v1beta1.OperatorVersion{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("operatorversions").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
