/*

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1beta1 "github.com/kudobuilder/kudo/pkg/apis/kudo/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeOperatorVersions implements OperatorVersionInterface
type FakeOperatorVersions struct {
	Fake *FakeKudoV1beta1
	ns   string
}

var operatorversionsResource = schema.GroupVersionResource{Group: "kudo.dev", Version: "v1beta1", Resource: "operatorversions"}

var operatorversionsKind = schema.GroupVersionKind{Group: "kudo.dev", Version: "v1beta1", Kind: "OperatorVersion"}

// Get takes name of the operatorVersion, and returns the corresponding operatorVersion object, and an error if there is any.
func (c *FakeOperatorVersions) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.OperatorVersion, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(operatorversionsResource, c.ns, name), &v1beta1.OperatorVersion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OperatorVersion), err
}

// List takes label and field selectors, and returns the list of OperatorVersions that match those selectors.
func (c *FakeOperatorVersions) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.OperatorVersionList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(operatorversionsResource, operatorversionsKind, c.ns, opts), &v1beta1.OperatorVersionList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.OperatorVersionList{ListMeta: obj.(*v1beta1.OperatorVersionList).ListMeta}
	for _, item := range obj.(*v1beta1.OperatorVersionList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested operatorVersions.
func (c *FakeOperatorVersions) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(operatorversionsResource, c.ns, opts))

}

// Create takes the representation of a operatorVersion and creates it.  Returns the server's representation of the operatorVersion, and an error, if there is any.
func (c *FakeOperatorVersions) Create(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.CreateOptions) (result *v1beta1.OperatorVersion, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(operatorversionsResource, c.ns, operatorVersion), &v1beta1.OperatorVersion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OperatorVersion), err
}

// Update takes the representation of a operatorVersion and updates it. Returns the server's representation of the operatorVersion, and an error, if there is any.
func (c *FakeOperatorVersions) Update(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.UpdateOptions) (result *v1beta1.OperatorVersion, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(operatorversionsResource, c.ns, operatorVersion), &v1beta1.OperatorVersion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OperatorVersion), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeOperatorVersions) UpdateStatus(ctx context.Context, operatorVersion *v1beta1.OperatorVersion, opts v1.UpdateOptions) (*v1beta1.OperatorVersion, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(operatorversionsResource, "status", c.ns, operatorVersion), &v1beta1.OperatorVersion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OperatorVersion), err
}

// Delete takes name of the operatorVersion and deletes it. Returns an error if one occurs.
func (c *FakeOperatorVersions) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(operatorversionsResource, c.ns, name), &v1beta1.OperatorVersion{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeOperatorVersions) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(operatorversionsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.OperatorVersionList{})
	return err
}

// Patch applies the patch and returns the patched operatorVersion.
func (c *FakeOperatorVersions) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.OperatorVersion, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(operatorversionsResource, c.ns, name, pt, data, subresources...), &v1beta1.OperatorVersion{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.OperatorVersion), err
}
