<p align="center">
    <a href="http://kucc.ku.edu.np">
        <img src="./images/kucc.png" align="center" alt="kucc-icon" height="200px"/>
    </a>
</p>
<h1 align="center" style="border: 0;">Kathmandu University Students' Projects</h1>

This repository contains the curated list of open-source projects done by Kathmandu University students. Check [Contribution](#contribution) to know how to contribute to this repository.

This repository is started to celebrate [Hacktoberfest 2020](https://hacktoberfest.digitalocean.com/) movement.

## Table of Contents

- [Major Projects](#major-projects)

  - [First Year](#first-year)
  - [Second Year](#second-year)
  - [Third Year](#third-year)
  - [Fourth Year](#third-year)

- [Mini Projects](#mini-projects)
  - [Database Management Systems](#database-management-systems)
  - [Artificial Intelligence](#artificial-intelligence)
  - [Computer Graphics](#computer-graphics)

- [Open Source Projects](#open-source-projects)
  - [Angular Dart Extension](#angular-dart-extension)
  
- [Contribution](#contribution)
- [License](#license)

## Major Projects

### First Year

- #### [Scientific Calculator](https://github.com/saileshbro/scientific-calculator-qt)

  This is a scientific calculator built with `C++` using [Qt framework](https://www.qt.io/product/framework).

  [![Star this repo](https://img.shields.io/github/stars/saileshbro/scientific-calculator-qt.svg)](https://github.com/saileshbro/scientific-calculator-qt)

- #### [652ash](https://github.com/razzat008/652ahs)

  A project written in C++ and made using Dear ImGui for UI and sqlite3 for database, that calculates hashes for both files and text using 
  SHA256 and MD5 hashing algorithms.

  [![Star this repo](https://img.shields.io/github/stars/razzat008/652ahs.svg)](https://github.com/razzat008/652ahs)

- #### [Classroom Management System (CMS)](https://github.com/suveshgurung/CMS)
  
  A project thoughtfully made using C++ and Qt that helps streamline the process of proxy class allocation in Block 6 of Kathmandu University.

  [![Star this repo](https://img.shields.io/github/stars/suveshgurung/CMS.svg)](https://github.com/suveshgurung/CMS)
  
- #### [BloodBound](https://github.com/sarbeshkc/blood)
  
  A project made using C++ and Qt that helps to solve the blood donation process and ensure a hassle-free experience to the end user.

  [![Star this repo](https://img.shields.io/github/stars/sarbeshkc/blood.svg)](https://github.com/sarbeshkc/blood)

- #### [Project-ISGC](https://github.com/SafalNarsingh/Project-ISGC)

  Scientific and Graphing Calculator made and integrated using C++ and SFML. Project - ISGC (Integrating Scientific and Graphing Calculator)

  [![Star this repo](https://img.shields.io/github/stars/SafalNarsingh/Project-ISGC) ](https://github.com/SafalNarsingh/Project-ISGC)


### Second Year

- #### [Kam Nepal](https://github.com/saileshbro/kamnepal)

  Kam Nepal is a job portal website which was created using `PHP`.

  [![Star this repo](https://img.shields.io/github/stars/saileshbro/kamnepal.svg)](https://github.com/saileshbro/kamnepal)

- #### [Hami Nirogi](https://github.com/saileshbro/nirogi)

  Hami Nirogi is a mobile application that provides health-related statistics, such as illness details, signs and medication statistics. It offers search options for multiple medications and gives information about the dose, the generic name, and other health-related information.

  The app is built with [Flutter](https://flutter.dev) and [Node.js](https://nodejs.org/en/). You can try the application by installing apk file from [releases](https://github.com/saileshbro/nirogi/releases/tag/v0.1-beta).

  [![Star this repo](https://img.shields.io/github/stars/saileshbro/nirogi.svg)](https://github.com/saileshbro/nirogi) [![Star this repo](https://img.shields.io/github/stars/saileshbro/nirogi-api.svg)](https://github.com/saileshbro/nirogi-api)
  
- #### [My Medilog](https://github.com/awanshrestha/medilog)

  My Medilog is a health portal system that helps users with digitalized record of their health reports and information. It allows doctors to update the patient health information and patients can access their past medical records, medications and upcoming appointments with doctors.

  The app is built with [Node.js](https://nodejs.org/en/).

  [![Star this repo](https://img.shields.io/github/stars/awanshrestha/medilog.svg)](https://github.com/awanshrestha/medilog)

### Third Year

- #### [Cognifeed](https://github.com/saileshbro/cognifeed)

  Cognifeed is an information aggregator program that attempts to make you smarter in this stressful environment.

  The app is built with [Flutter](https://flutter.dev) and [Node.js](https://nodejs.org/en/). You can try the application by installing apk file from [releases](https://github.com/saileshbro/cognifeed/releases/tag/v1.0).

  [![Star this repo](https://img.shields.io/github/stars/saileshbro/cognifeed.svg)](https://github.com/saileshbro/cognifeed)

- #### [nutri.gram](https://github.com/saileshbro/nutri.gram)

  nutri.gram is a mobile application that scans the food label present in the packaged food items and draws a significant conclusion from that data regarding its edibleness for a person, the nutritional worth it adds to our diet, how much calorific value it provides per serving and much more. This application is targeted to anyone who wants to get insight into what they are feeding into their body and how understanding the nutritional value will be of tremendous aid to their overall health.

  The app is built with [Flutter](https://flutter.dev) and [Node.js](https://nodejs.org/en/).

  [![Star this repo](https://img.shields.io/github/stars/saileshbro/nutri.gram.svg)](https://github.com/saileshbro/nutri.gram)
  
- #### [Visit Nepal 2020](https://github.com/TimilsinaBimal/Visit-Nepal-2020)

     Visit Nepal 2020 is a web application targeted for the campaign Visit Nepal 2020 (later postponed to 2022 due to COVID 19). This project helps tourists to find the places based on District, popularity and so on. It also has features like Activities to do in that place, Currency Converter, News about Tourism and places, Social Networking site to connect with other people and so on. Users can rate the places. There are a list of Hotels to stay in, with the prices so that they can easily decide where to stay. 
        *Note: We have Used dummy data for testing purpose.*

  The app is built with [Django](https://www.djangoproject.com/).

  [![Star this repo](https://img.shields.io/github/stars/TimilsinaBimal/Visit-Nepal-2020.svg)](https://github.com/TimilsinaBimal/Visit-Nepal-2020)
  

### Fourth Year
- #### [KUSIMS](https://github.com/sigdelsanjog/KUSIMS)

    Kathmandu University Student Information Management System is actually a semeter proejct we gradaute student Batch 2018 did as a part of the course Sorftware Engineering. This project is developed in Laravel Framework with various features like Department, Program and Batch Management, Student Grades and Attendance, Hostel Management, Employee and Job type Management, Bus management, Course Assignment & Addition of Notice, Using permissions via roles etc.
    
    The app is built with [Laravel](https://laravel.com/).
    
    [![Star this repo](https://img.shields.io/github/stars/sigdelsanjog/KUSIMS.svg)](https://github.com/sigdelsanjog/KUSIMS)
    

## Mini Projects

### Database Management Systems

- #### [Restaurant DBMS](https://github.com/saileshbro/restaurant-dbms)

  Database project for 4th semester using `Node.js` and `MySQL`

  The app is built with [MySQL](https://www.mysql.com) and [Node.js](https://nodejs.org/en/).

  [![Star this repo](https://img.shields.io/github/stars/saileshbro/restaurant-dbms.svg)](https://github.com/saileshbro/restaurant-dbms)
  
  
### Artificial Intelligence

- #### [SMS Spam or Ham Detector](https://github.com/maladeep/sms-spam-ham-detector)

  A simple web app to detect SMS as spam or ham(not spam) using `Python Flask` and `Naïve Bayes classifiers` for IV/I year/semester Artificial Intelligence course (COMP 472).
  
  The app is built with [Python Flask](https://flask.palletsprojects.com/en/1.1.x/) and [Bootstrap](https://getbootstrap.com/).
  
    **Blog at:** [Towards Data Science](https://towardsdatascience.com/the-ultimate-guide-to-sms-spam-or-ham-detector-aec467aecd85)
 
     **Live at:** [Spam or Ham SMS Detector](https://sms-spam-ham-detector.herokuapp.com)

    [![Star this repo](https://img.shields.io/github/stars/maladeep/sms-spam-ham-detector)](https://github.com/maladeep/sms-spam-ham-detector)
    
### Computer Graphics

- #### [Double Pendulum Simulation](https://github.com/saileshbro/double-pendulum-simulation)

  This is a double pendullum simulation application with [p5.js](https://p5js.org/), built as a Mini Project for Computer Graphics (COMP 342).

  You can view the live demo [here](https://saileshbro.github.io/double-pendulum-simulation/).

  [![Star this repo](https://img.shields.io/github/stars/saileshbro/double-pendulum-simulation)](https://github.com/saileshbro/double-pendulum-simulation)

## Open Source Projects

### [Angular Dart Extension](https://github.com/aadarshadhakalg/ADSnippets)

  This is the first VS Code extension for the Google's frontend framework [Angular Dart](https://github.com/dart-lang/angular). This extension generates boilerplate codes, template codes, and components of Angular Dart. 

  [![Version](https://vsmarketplacebadge.apphb.com/version/aadarshadhakalg.adsnippets.svg)](https://marketplace.visualstudio.com/items?itemName=aadarshadhakalg.adsnippets)
  [![Installs](https://vsmarketplacebadge.apphb.com/installs/aadarshadhakalg.adsnippets.svg)](https://marketplace.visualstudio.com/items?itemName=aadarshadhakalg.adsnippets)
  [![Ratings](https://vsmarketplacebadge.apphb.com/rating/aadarshadhakalg.adsnippets.svg)](https://marketplace.visualstudio.com/items?itemName=aadarshadhakalg.adsnippets)
  [![Star this repo](https://img.shields.io/github/stars/saileshbro/scientific-calculator-qt.svg)](https://github.com/aadarshadhakalg/ADSnippets)

## Contribution

If you want to add your projects or want to contribute in any way. Please feel free to send a PR.

- Fork this repository
- make a `your-username-project` branch and add your project details
- Send a pull request to `main` branch and wait for it to be merged.
- Please make sure all the links you add are correct.

Contributions, issues and feature requests are welcome. If you want make some changes / improvement in this project, please consider opening an issues first.

## License

[![License: MIT](https://img.shields.io/badge/License-MIT-red.svg)](https://opensource.org/licenses/MIT)
