<?php

declare(strict_types=1);

namespace MySQLReplication\Tests\Integration;

use MySQLReplication\Definitions\ConstEventType;
use MySQLReplication\Event\DTO\QueryDTO;
use MySQLReplication\Event\DTO\RowsQueryDTO;

final class RowsQueryTest extends BaseCase
{
    public function testThatTheEditingQueryIsReadFromBinLog(): void
    {
        $this->connection->executeStatement(
            'CREATE TABLE test (id INT NOT NULL AUTO_INCREMENT, data VARCHAR (50) NOT NULL, PRIMARY KEY (id))'
        );

        $insertQuery = 'INSERT INTO test (data) VALUES(\'Hello\') /* Foo:Bar; */';
        $this->connection->executeStatement($insertQuery);

        // The Create Table Query ... irrelevant content for this test
        self::assertInstanceOf(QueryDTO::class, $this->getEvent());
        // The BEGIN Query ... irrelevant content for this test
        self::assertInstanceOf(QueryDTO::class, $this->getEvent());

        $rowsQueryEvent = $this->getEvent();
        self::assertInstanceOf(RowsQueryDTO::class, $rowsQueryEvent);
        self::assertSame($insertQuery, $rowsQueryEvent->query);
    }
    
    protected function getIgnoredEvents(): array
    {
        return [ConstEventType::GTID_LOG_EVENT->value];
    }
}
