<?php

declare(strict_types=1);

namespace MySQLReplication\Event;

use MySQLReplication\Event\DTO\QueryDTO;

/**
 * @see https://dev.mysql.com/doc/dev/mysql-server/latest/page_protocol_replication_binlog_event.html#sect_protocol_replication_event_query
 */
class QueryEvent extends EventCommon
{
    public function makeQueryDTO(): QueryDTO
    {
        $threadId = $this->binaryDataReader->readUInt32();
        $executionTime = $this->binaryDataReader->readUInt32();
        $schemaLength = $this->binaryDataReader->readUInt8();
        $this->binaryDataReader->advance(2);
        $statusVarsLength = $this->binaryDataReader->readUInt16();
        $this->binaryDataReader->advance($statusVarsLength);
        $schema = $this->binaryDataReader->read($schemaLength);
        $this->binaryDataReader->advance(1);
        $query = $this->binaryDataReader->read(
            $this->eventInfo->getSizeNoHeader() - 13 - $statusVarsLength - $schemaLength - 1
        );

        return new QueryDTO($this->eventInfo, $schema, $executionTime, $query, $threadId);
    }
}
