# Release Notes

## v8.0.1 (2024-01-31)

- Added: auto authorisation packet switching

## v8.0.0 (2024-01-29)

- Change: drop support for < 8.2
- Change: moved to enums, promoted properties
- Added: logger for more socket info
- Added: slave_uuid support (#99)
- Change: EventInfo->id is now EventInfo->serverId (#83)
- Change: config no longer static (#94)
- Chore: typos in README/code
- Chore: replace/remove old dead doc urls from code
- Chore: changed variables to underscore 
- Added: support caching_sha2_password (#102)
- Change: BinLogServerInfo static calls removed also added method getServerInfo to MySQLReplicationFactory 
- Change: type of bin log position is now string as it can be bigger then php can hande 2^64-1 (#84) 

## v7.0.1 (2021-03-09)

 - Fixed negative number handling (#80)

## v7.0.0 (2021-01-24)

- Change: added support doctrine/dbal to ^3.0 (#75)(#73)
- Change: dropped support for <= 7.2 (#75)
- Added: test cases for PHP 7.3 and 7.4 (#75)
- Fixed: scale length in decimals values (#76)
- Added: added tests for php 8.0 

## v6.2.4 (2020-09-12)

- Change: type from int to float for heartbeat period (#70)
- Fixed: event dispatcher interface in Event.php #(69)

## v6.2.3 (2020-09-03)

- Fixed: use provided event dispatcher (#67)

## v6.2.2 (2020-04-15)

- Fixed: varchars table length should be read as unsigned int (#63)

## v6.2.1 (2020-03-24)
- Fixed: maraidb bad binlog when parsing event (#62)
- Added: BinLogServerInfo::getRevision()

## v6.2.0 (2020-02-18)
- Added symfony 5 support #61
- Removed support for symfony 2.3

## v6.1.0 (2020-02-12)
- Added: more support for json data like JSON_REPLACE, JSON_SET, JSON_REMOVE

## v6.0.2 (2019-08-14)
- Added: travis mariadb 10 and 10.1 tests  

## v6.0.1 (2019-07-30)
- Fixed: getDatetime2 not reads fsp when date is wrong (#54)
 
## v6.0.0 (2019-07-08)
- Removed: support for lesser then php7
- Added: strong and string types 
- Changed: ConfigFactory removed and method make form array moved to Config
- Changed: MariaDbGtidLogDTO replaced getSequenceNumber with getMariaDbGtid
- Fixed: Insert NULL in a boolean column returns no rows
- Fixed: float problem about time field type
- Fixed: column order
- Changed: getFields and getMasterStatus returns no VO
- Changed: Column to ColumnDTO and added ColumnDTOCollection 
- Changed: replaced getFields with getColumnDTOCollection in TableMap
- Added: more compatibility for mysql 5.5, 5.6, 5.7, maria 10 and 8.0 
- Removed: makeConfigFromArray

## v5.0.6 (2019-02-05)
- Fixed json with slash (#48)
- Fixed disabling events that are needed (#46)
- Changed to @inherit phpdoc in jsonSerialize methods
- Removed unused exceptions from phpdoc
- Changed moved wiki do readme
- Changed added missing php extensions to composer.json

## v5.0.5 (2018-11-11)
- Fixed support to receive more than 16MB + tests 

## v5.0.4 (2018-08-10)
- Added support to receive more than 16MB

## v5.0.3 (2018-08-07)
- Added symfony 4.0 compatibility in composer

## v5.0.3
- Added symfony 4.0 compatibility in composer

## v5.0.2 (2018-06-22)
- Added checking for eof (#42)
- Added support for column type 11 - TIME (mysql 5.5 only) (#41) 

## v5.0.1 (2018-05-29)
- Added tests now include php 7.2 and MariaDb 10.3
- Added truncate table test (#37)
- Added MariaDb events ids to const
- Added filtering dummy events generated by MariaDB
- Added missing throws in BasicTest

## v5.0.0 (2018-04-27)
- Removed unused classes from code and merged some classes to one class
- Added ability in MySQLReplicationFactory to provide implementations interfaces in constructor. This will give ability to replace default classes to your own
- Added Config to MySQLReplicationFactory constructor (#35)
- Changed register subscriber to accept interface of EventSubscriberInterface over EventSubscribers class (#36)
- Changed moved exception messages to main exception class 
- Changed psr-2 "elseif " replaced to "else if"
- Fixed 5.7 json column deserialization for null value + tests
- Changed minor refactoring in classes 
                                                         
## v4.0.0 (2018-03-10)
- Removed unused (probably?) classes ConfigService, BinaryDataReaderService
- Changed Event class broke into smaller methods to be cleaner
- Added some unit test
- Added BinLogCurrent to keep current binlogFile, binlog position and gtid also added example how to resume script based on this data
- Moved to php 5.6 sorry.. the future is now ;)

## v3.0.1 (2017-08-16)
- Fixed in config filter_var validation if 0 given
- Changed if bin log and bin log file not given then use master otherwise given data will be send to master
- Fixed isCheckSum mysql returns string NONE not an empty array and mariaDbGtid fix  (tx to @kobi97)
- Added travis mysql 5.6 and 5.7 env 
- Removed mariaDB support for query event 
- Fixed clear table map cache after rotate event

## v3.0.0 (2017-07-14)
- Added Cache interfaces for table info
- Changed examples to use ConfigBuilder
- Changed BinLogSocketConnect to separate sockets handling to another class + added interface for socket class
- Changed tests namespace to MySQLReplication
- Changed all exception messages moved to MySQLReplicationException
- Added CHANGELOG.md
- Simplify many classes and removed some of them 
- Added decorators for server version recognition
- Changed if datetime not recognised will return null (0000-00-00 00:00:00 is invalid date) 
- Added 'custom' param to config if some custom params must be set in extended/implemented own classes
- Added new tests
- Changed Repository $schema to $database
- Changed - YEAR = 0 will return null not 1900
- Removed Exception from Columns class
- Added format description event
- Changed inserts to not existing tables/columns will be returned as WriteEvent with empty Fields (see BasicTest::shouldGetWriteEventDropTable) 
- Changed TABLE_MAP_EVENT will no longer appear after adding events to only/ignore configuration 
- Fixed events with dropped columns will return a proper columns amount
- Changed configuration to static calls
- Removed absolute method getConnection from repository
- Added Heartbeat period and event support 

## v2.2.0 (2017-03-10)
- Removed foreign keys from events 

## v2.1.3 (2016-11-26)
- Documentation update
- BinLogSocketConnect exception set as const
- 'Dbname' removed from configuration as is deprecated
- MySQLRepository and BinLogSocketConnect extracted to interfaces
- Register slave use now hostname and port to be correct display in "SHOW SLAVE HOSTS"
- Added foreign keys info to events

## v2.1.2 (2016-11-26)
- Added json decoder 16/32 int support
    
## v2.1.1 (2016-11-19)
- Fix for json decode
- Table cache option moved to config
- Strict variables 

## v2.1.0 (2016-11-05)
- Basic implementation of json binary encoder for mysql 5.7
- Config now support ip and host setting
- Connection_id correctly decoded
- Events dispatcher now can work with 2.8 lib
- Some code cleanup
- Added new tests

## v2.0.2 (2016-08-29)
- Added MariaDB compatibility 
- Code cleanup

## v2.0.1 (2016-08-28)
- Added new field support TIMESTAMP=7
- Query event fix
- Added db charset to db connection

## v2.0.0 (2016-08-26)
- Added MariaDb support
- Added symphony event dispatcher 
- Added db charset to db connection
- Removed support for php 5.4
- Added slave register

## v1.0.3 (2016-07-16)
- Added MariaDb gitid support (backport from 2.0.0-pre)

## v1.0.2 (2016-05-05)
- Fixed handling not existing value in enum definitions

## v1.0.1
- Fixed missing Config attr

## v1.0.0
- Added php5.4 compatibility 
- Added new results set 
- Added benchmark results to readme
- Added travis for tests
