import { JsType } from "../models/js.model";

export enum PostgresBaseType {
  aclitem = "aclitem", 
  bit = "bit", 
  boolean = "boolean", 
  box = "box", 
  character = "character", 
  bytea = "bytea", 
  char = "char", 
  cid = "cid", 
  cidr = "cidr", 
  circle = "circle", 
  date = "date", 
  real = "real", 
  double_precision = "double precision", 
  gtsvector = "gtsvector", 
  inet = "inet", 
  smallint = "smallint", 
  int2vector = "int2vector", 
  integer = "integer", 
  bigint = "bigint", 
  interval = "interval", 
  json = "json", 
  jsonb = "jsonb", 
  jsonpath = "jsonpath", 
  line = "line", 
  lseg = "lseg", 
  macaddr = "macaddr", 
  macaddr8 = "macaddr8", 
  money = "money", 
  name = "name", 
  numeric = "numeric", 
  oid = "oid", 
  oidvector = "oidvector", 
  path = "path", 
  point = "point", 
  polygon = "polygon", 
  refcursor = "refcursor", 
  regclass = "regclass", 
  regcollation = "regcollation", 
  regconfig = "regconfig", 
  regdictionary = "regdictionary", 
  regnamespace = "regnamespace", 
  regoper = "regoper", 
  regoperator = "regoperator", 
  regproc = "regproc", 
  regprocedure = "regprocedure", 
  regrole = "regrole", 
  regtype = "regtype", 
  text = "text", 
  tid = "tid", 
  time_without_time_zone = "time without time zone", 
  timestamp_without_time_zone = "timestamp without time zone", 
  timestamp_with_time_zone = "timestamp with time zone", 
  time_with_time_zone = "time with time zone", 
  tsquery = "tsquery", 
  tsvector = "tsvector", 
  txid_snapshot = "txid_snapshot", 
  uuid = "uuid", 
  bit_varying = "bit varying", 
  character_varying = "character varying", 
  xid = "xid", 
  xid8 = "xid8", 
  xml = "xml"
};

export const postgresBaseTypeToJsType: Record<keyof typeof PostgresBaseType, keyof typeof JsType> = {
  aclitem: 'string',
  bit: 'string',
  boolean: 'boolean',
  box: 'string',
  character: 'string',
  bytea: 'buffer',
  char: 'string',
  cid: 'string',
  cidr: 'string',
  circle: 'object',
  date: 'date',
  real: 'number',
  double_precision: 'number',
  gtsvector: 'object',
  inet: 'string',
  smallint: 'number',
  integer: 'number',
  bigint: 'string',
  interval: 'object',
  json: 'object',
  jsonb: 'object',
  jsonpath: 'string',
  line: 'string',
  lseg: 'string',
  macaddr: 'string',
  macaddr8: 'string',
  money: 'string',
  name: 'string',
  numeric: 'string',
  oid: 'number',
  path: 'string',
  point: 'object',
  polygon: 'string',
  refcursor: 'string',
  regclass: 'string',
  regcollation: 'string',
  regconfig: 'string',
  regdictionary: 'string',
  regnamespace: 'string',
  regoper: 'string',
  regoperator: 'string',
  regproc: 'string',
  regprocedure: 'string',
  regrole: 'string',
  regtype: 'string',
  text: 'string',
  tid: 'string',
  tsquery: 'string',
  tsvector: 'string',
  txid_snapshot: 'string',
  uuid: 'string',
  bit_varying: 'string',
  xid: 'string',
  xid8: 'string',
  xml: 'string',
  character_varying: 'string',
  time_with_time_zone: 'string',
  time_without_time_zone: 'string',
  timestamp_with_time_zone: 'date',
  timestamp_without_time_zone: 'date',
  int2vector: 'string',
  oidvector: 'string'
};

export const postgresBaseTypeToArrayReturn: Record<keyof typeof PostgresBaseType, boolean> = {
  aclitem: false,
  bit: false,
  boolean: true,
  box: false,
  character: true,
  bytea: true,
  char: true,
  cid: false,
  cidr: true,
  circle: false,
  date: true,
  real: true,
  double_precision: true,
  gtsvector: false,
  inet: true,
  smallint: true,
  int2vector: false,
  integer: true,
  bigint: true,
  interval: true,
  json: true,
  jsonb: true,
  jsonpath: false,
  line: false,
  lseg: false,
  macaddr: true,
  macaddr8: false,
  money: true,
  name: false,
  numeric: true,
  oid: true,
  oidvector: false,
  path: false,
  point: true,
  polygon: false,
  refcursor: false,
  regclass: false,
  regcollation: false,
  regconfig: false,
  regdictionary: false,
  regnamespace: false,
  regoper: false,
  regoperator: false,
  regproc: true,
  regprocedure: false,
  regrole: false,
  regtype: false,
  text: true,
  tid: false,
  time_without_time_zone: true,
  timestamp_without_time_zone: true,
  timestamp_with_time_zone: true,
  time_with_time_zone: true,
  tsquery: false,
  tsvector: false,
  txid_snapshot: false,
  uuid: true,
  bit_varying: false,
  character_varying: true,
  xid: false,
  xid8: false,
  xml: false
};