<?php
/**
 * @copyright Copyright (c) 2021 深圳市酷瓜软件有限公司
 * @license https://opensource.org/licenses/GPL-2.0
 * @link https://www.koogua.com
 */

namespace App\Services\Logic\Notice\Internal;

use App\Models\Comment as CommentModel;
use App\Models\Notification as NotificationModel;
use App\Models\User as UserModel;
use App\Services\Logic\Service as LogicService;

class CommentLiked extends LogicService
{

    public function handle(CommentModel $comment, UserModel $sender)
    {
        $commentContent = kg_substr($comment->content, 0, 36);

        $notification = new NotificationModel();

        $notification->sender_id = $sender->id;
        $notification->receiver_id = $comment->owner_id;
        $notification->event_id = $comment->id;
        $notification->event_type = NotificationModel::TYPE_COMMENT_LIKED;
        $notification->event_info = [
            'comment' => ['id' => $comment->id, 'content' => $commentContent],
        ];

        $notification->create();
    }

}
