import React from 'react';

export default function World({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-world'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <circle cx='12' cy='12' r='9' />
      <line x1='3.6' y1='9' x2='20.4' y2='9' />
      <line x1='3.6' y1='15' x2='20.4' y2='15' />
      <path d='M11.5 3a17 17 0 0 0 0 18' />
      <path d='M12.5 3a17 17 0 0 1 0 18' />
    </svg>
  );
}
