import React from 'react';

export default function Trekking({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-trekking'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <circle cx='12' cy='4' r='1' />
      <path d='M7 21l2 -4' />
      <path d='M13 21v-4l-3 -3l1 -6l3 4l3 2' />
      <path d='M10 14l-1.827 -1.218a2 2 0 0 1 -.831 -2.15l.28 -1.117a2 2 0 0 1 1.939 -1.515h1.439l4 1l3 -2' />
      <path d='M17 12v9' />
      <path d='M16 20h2' />
    </svg>
  );
}
