import React from 'react';

export default function TransitionTop({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-transition-top'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M21 6a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -3 3' />
      <path d='M6 21h12a3 3 0 0 0 0 -6h-12a3 3 0 0 0 0 6z' />
      <path d='M12 15v-8' />
      <path d='M9 10l3 -3l3 3' />
    </svg>
  );
}
