import React from 'react';

export default function Tournament({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-tournament'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <circle cx='4' cy='4' r='2' />
      <circle cx='20' cy='10' r='2' />
      <circle cx='4' cy='12' r='2' />
      <circle cx='4' cy='20' r='2' />
      <path d='M6 12h3a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-3' />
      <path d='M6 4h7a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-2' />
      <path d='M14 10h4' />
    </svg>
  );
}
