import React from 'react';

export default function TargetArrow({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-target-arrow'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <circle cx='12' cy='12' r='1' />
      <path d='M12 7a5 5 0 1 0 5 5' />
      <path d='M13.004 3.055a9 9 0 1 0 7.941 7.945' />
      <path d='M15 6v3h3l3 -3h-3v-3z' />
      <path d='M15 9l-3 3' />
    </svg>
  );
}
