import React from 'react';

export default function Spider({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-spider'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M5 4v2l5 5' />
      <path d='M2.5 9.5l1.5 1.5h6' />
      <path d='M4 19v-2l6 -6' />
      <path d='M19 4v2l-5 5' />
      <path d='M21.5 9.5l-1.5 1.5h-6' />
      <path d='M20 19v-2l-6 -6' />
      <circle cx='12' cy='15' r='4' />
      <circle cx='12' cy='9' r='2' />
    </svg>
  );
}
