import React from 'react';

export default function SortZA({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-sort-z-a'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M4 8h4l-4 8h4' />
      <path d='M16 16v-6a2 2 0 1 1 4 0v6' />
      <path d='M16 13h4' />
      <path d='M11 12h2' />
    </svg>
  );
}
