import React from 'react';

export default function Nfc({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-nfc'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M11 20a3 3 0 0 1 -3 -3v-11l5 5' />
      <path d='M13 4a3 3 0 0 1 3 3v11l-5 -5' />
      <rect x='4' y='4' width='16' height='16' rx='3' />
    </svg>
  );
}
