import React from 'react';

export default function Menorah({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-menorah'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M12 4v16' />
      <path d='M8 4v2a4 4 0 1 0 8 0v-2' />
      <path d='M4 4v2a8 8 0 1 0 16 0v-2' />
      <path d='M10 20h4' />
    </svg>
  );
}
