import React from 'react';

export default function Icons({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-icons'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <circle cx='6.5' cy='6.5' r='3.5' />
      <path d='M2.5 21h8l-4 -7z' />
      <path d='M14 3l7 7' />
      <path d='M14 10l7 -7' />
      <path d='M14 14h7v7h-7z' />
    </svg>
  );
}
