import React from 'react';

export default function HistoryToggle({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-history-toggle'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M12 8v4l3 3' />
      <path d='M8.56 3.69a9 9 0 0 0 -2.92 1.95' />
      <path d='M3.69 8.56a9 9 0 0 0 -.69 3.44' />
      <path d='M3.69 15.44a9 9 0 0 0 1.95 2.92' />
      <path d='M8.56 20.31a9 9 0 0 0 3.44 .69' />
      <path d='M15.44 20.31a9 9 0 0 0 2.92 -1.95' />
      <path d='M20.31 15.44a9 9 0 0 0 .69 -3.44' />
      <path d='M20.31 8.56a9 9 0 0 0 -1.95 -2.92' />
      <path d='M15.44 3.69a9 9 0 0 0 -3.44 -.69' />
    </svg>
  );
}
