import React from 'react';

export default function CurrencyTaka({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-currency-taka'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <circle cx='16.5' cy='15.5' r='1' />
      <path d='M7 7a2 2 0 1 1 4 0v9a3 3 0 0 0 6 0v-.5' />
      <path d='M8 11h6' />
    </svg>
  );
}
