import React from 'react';

export default function CurrencyOff({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-currency-off'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M18.531 14.524a7 7 0 0 0 -9.06 -9.053m-2.422 1.582a7 7 0 0 0 9.903 9.896' />
      <path d='M4 4l3 3' />
      <path d='M20 4l-3 3' />
      <path d='M4 20l3 -3' />
      <path d='M20 20l-3 -3' />
      <path d='M3 3l18 18' />
    </svg>
  );
}
