import React from 'react';

export default function Cpu({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-cpu'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <rect x='5' y='5' width='14' height='14' rx='1' />
      <path d='M9 9h6v6h-6z' />
      <path d='M3 10h2' />
      <path d='M3 14h2' />
      <path d='M10 3v2' />
      <path d='M14 3v2' />
      <path d='M21 10h-2' />
      <path d='M21 14h-2' />
      <path d='M14 21v-2' />
      <path d='M10 21v-2' />
    </svg>
  );
}
