import React from 'react';

export default function ClearFormatting({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-clear-formatting'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M17 15l4 4m0 -4l-4 4' />
      <path d='M7 6v-1h11v1' />
      <line x1='7' y1='19' x2='11' y2='19' />
      <line x1='13' y1='5' x2='9' y2='19' />
    </svg>
  );
}
