import React from 'react';

export default function BuildingEstate({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-building-estate'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M3 21h18' />
      <path d='M19 21v-4' />
      <path d='M19 17a2 2 0 0 0 2 -2v-2a2 2 0 1 0 -4 0v2a2 2 0 0 0 2 2z' />
      <path d='M14 21v-14a3 3 0 0 0 -3 -3h-4a3 3 0 0 0 -3 3v14' />
      <path d='M9 17v4' />
      <path d='M8 13h2' />
      <path d='M8 9h2' />
    </svg>
  );
}
