import React from 'react';

export default function BrandWalmart({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-brand-walmart'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M12 8.04v-5.04' />
      <path d='M15.5 10l4.5 -2.5' />
      <path d='M15.5 14l4.5 2.5' />
      <path d='M12 15.96v5.04' />
      <path d='M8.5 14l-4.5 2.5' />
      <path d='M8.5 10l-4.5 -2.505' />
    </svg>
  );
}
