import React from 'react';

export default function BrandShopee({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-brand-shopee'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M4 7l.867 12.143a2 2 0 0 0 1.995 1.857h10.276a2 2 0 0 0 1.995 -1.857l.867 -12.143h-16z' />
      <path d='M8.5 7c0 -1.653 1.5 -4 3.5 -4s3.5 2.347 3.5 4' />
      <path d='M9.5 17c.413 .462 1 1 2.5 1s2.5 -.897 2.5 -2s-1 -1.5 -2.5 -2s-2 -1.47 -2 -2c0 -1.104 1 -2 2 -2s1.5 0 2.5 1' />
    </svg>
  );
}
