import React from 'react';

export default function BrandMantine({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-brand-mantine'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <circle cx='12' cy='12' r='9' />
      <path d='M11 16c1.22 -.912 2 -2.36 2 -4a5.01 5.01 0 0 0 -2 -4' />
      <path d='M14 9h-2' />
      <path d='M14 15h-2' />
      <path d='M10 12h.01' />
    </svg>
  );
}
