import React from 'react';

export default function BrandLinktree({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-brand-linktree'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M9 3l-7 12h3v5h5v-5h-2l4 -7z' />
      <path d='M15 3l7 12h-3v5h-5v-5h2l-4 -7z' />
    </svg>
  );
}
