import React from 'react';

export default function BadgeAr({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-badge-ar'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <rect x='3' y='5' width='18' height='14' rx='2' />
      <path d='M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5' />
      <path d='M7 13h3' />
      <path d='M14 12h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6m3 0l-2 -3' />
    </svg>
  );
}
