import React from 'react';

export default function ArrowsShuffle({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-arrows-shuffle'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M18 4l3 3l-3 3' />
      <path d='M18 20l3 -3l-3 -3' />
      <path d='M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5' />
      <path d='M21 7h-5a4.978 4.978 0 0 0 -2.998 .998m-4.002 8.003a4.984 4.984 0 0 1 -3 .999h-3' />
    </svg>
  );
}
