import React from 'react';

export default function ArrowGuide({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-arrow-guide'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <circle cx='5' cy='19' r='2' />
      <path d='M7 19h3a2 2 0 0 0 2 -2v-8a2 2 0 0 1 2 -2h7' />
      <path d='M18 4l3 3l-3 3' />
    </svg>
  );
}
