import React from 'react';

export default function ArrowAutofitWidth({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-arrow-autofit-width'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6' />
      <path d='M10 18h-7' />
      <path d='M21 18h-7' />
      <path d='M6 15l-3 3l3 3' />
      <path d='M18 15l3 3l-3 3' />
    </svg>
  );
}
