import React from 'react';

export default function Analyze({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-analyze'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M20 11a8.1 8.1 0 0 0 -6.986 -6.918a8.095 8.095 0 0 0 -8.019 3.918' />
      <path d='M4 13a8.1 8.1 0 0 0 15.001 2.998' />
      <circle cx='19' cy='16' r='1' />
      <circle cx='5' cy='8' r='1' />
      <circle cx='12' cy='12' r='3' />
    </svg>
  );
}
