import React from 'react';

export default function AirConditioning({
  size = 24,
  color = 'currentColor',
  ...restProps
}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      className='icon icon-tabler icon-tabler-air-conditioning'
      width={size}
      height={size}
      viewBox='0 0 24 24'
      stroke={color}
      strokeWidth='2'
      fill='none'
      strokeLinecap='round'
      strokeLinejoin='round'
      {...restProps}
    >
      <path stroke='none' d='M0 0h24v24H0z' fill='none' />
      <path d='M8 16a3 3 0 0 1 -3 3' />
      <path d='M16 16a3 3 0 0 0 3 3' />
      <path d='M12 16v4' />
      <rect x='3' y='5' width='18' height='8' rx='2' />
      <path d='M7 13v-3a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v3' />
    </svg>
  );
}
