# vue-elm-admin

前端项目[vue-elm-seller](https://github.com/konglingwen94/vue-elm-seller)的配套管理后台系统

本项目主要使用`Vue`+`ElementUI`搭建而成。可以用作 web 端管理后台的通用模板参考使用

## 在线预览

<http://123.57.204.48:5000/admin>

## 配套项目

客户端项目：<https://github.com/konglingwen94/vue-elm-seller>

服务端项目：<https://github.com/konglingwen94/elm-seller-server>

## Project setup

```
npm install
```

### Compiles and hot-reloads for development

```
npm run serve
```

### Compiles and minifies for production

```
npm run build
```

## 技术栈

本项目主要使用`element-ui`作为应用 UI 的组件库，使用了按需引入的配置方式，缩小了项目最终打包的体积。

其次第三方模块有`axios`,`vue-router` `v-charts`(基于 echart 封装的 vue 组件库)

## 功能

- [x] 店铺数据统计
- [x] 店铺配置
- [x] 管理员登录和退出
- [x] 商品的增删改查
- [x] 商品分类的增删改查
- [x] 商品上架/下架
- [x] 评价管理
- [x] 管理员账户的密码修改
- [x] 管理员账户信息修改
- [x] 记录浏览过的页面到应用顶部标签（tab-tag）
- [x] 分等级的多管理员
- [x] 抽屉菜单
- [ ] 项目整体优化和浏览标签优化

## 项目截图

首页
![首页](./screenshots/dashboard.png)

配置页面
![配置页面](./screenshots/configuration.png)

商品管理
![商品管理](./screenshots/food-list.png)

添加商品
![添加商品](./screenshots/food-add.png)

分类管理
![分类管理](./screenshots/category.png)

评价管理
![评价管理](./screenshots/rating.png)

管理员
![管理员](./screenshots/administrator.png)

设置
![设置](./screenshots/setting.png)

## 项目总结

- [Vue+ElementUI搭建商家店铺管理后台项目总结](https://juejin.cn/post/6906796790390095879)
- [Koa+Mongodb 搭建商家店铺服务端项目总结](https://juejin.cn/post/6907803934031609863)
- [Vue全新技术栈重构黄老师饿了么商家应用](https://juejin.cn/post/6844904202624303118)

## 支持

喜欢本项目的话请您动手点一下`star`,谢谢！
欢迎关注和提[issues](https://github.com/konglingwen94/vue-seller-admin/issues)
