﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;

namespace GadgetStoreMVC.Repository.Interfaces
{
    internal interface IRepository<T> where T : class
    {
        void Add(T entity);
        void Update(T entity);
        void Delete(T entity);
        void Delete(Expression<Func<T, bool>> where);
        void Delete(IEnumerable<T> objects);
        T GetById(int id);
        T Get(Expression<Func<T, bool>> where);
        IEnumerable<T> GetAll();
        IEnumerable<T> GetMany(Expression<Func<T, bool>> where);
        void Save();
    }
}
