---
sidebar_position: 1
---

# Xplorer

![Demo](/img/docs/themed-xplorer.webp)

## Summary

Welcome to Xplorer, A Free and Open Source (FOSS) File Explorer.

Xplorer is a modern file explorer built from ground-up to be fully customizable to fit 2023's need. Besides, Xplorer is a cross-platform application powered by the web that is being wrapped using [Tauri](https://tauri.studio) framework in which you can run Xplorer on Windows, MacOS, or Linux without having much trouble. Some Xplorer's features in summary are:

-   It looks modern
-   Easy to use
-   [Cross-platform](https://xplorer.space/)
-   [File Preview](https://xplorer.space/docs/guides/operation/#preview-file), even for videos!
-   [Customizable](https://xplorer.space/docs/Extensions/theme/)
-   Supports multiple tabs
-   Most importantly, It's an Open Source Software (OSS)!

Xplorer is currently under heavy development. You can give your suggestions and feedback on our [Discussions](https://github.com/kimlimjustin/xplorer/discussions/) page. If you feel comfortable in writing code using Typescript and Rust, we highly encourage you to [contribute to this project](https://xplorer.space/community/Contributing/).

## Project Roadmap

-   [x] File browsing and preview.
-   [x] Multiple tabs.
-   [x] Ability to continue the previous session on startup.
-   [ ] Extension.
    -   [x] Theme extension.
    -   [ ] Functions extension.
    -   [ ] Extension Marketplace.
-   [ ] Custom file categorization.
-   [ ] Multiple workspaces.
-   [ ] Web application.
-   [ ] Remote file (OneDrive, Google Drive, etc.)
-   [ ] File protection.
-   [ ] Custom file sorting and filtering.

Recommend us a feature by [opening an Discussion](https://github.com/kimlimjustin/xplorer/discussions) if you'd like to.
