// pages/api/auth/signin.js
import bcrypt from 'bcryptjs'
import jwt from 'jsonwebtoken'
import clientPromise from '../../../lib/mongodb'

export default async function handler(req, res) {
  if (req.method === 'POST') {
    const { email, password } = req.body

    try {
      const client = await clientPromise
      const db = client.db()

      const user = await db.collection('users').findOne({ email })
      if (!user) {
        return res.status(400).json({ message: 'User Not Found' })
      }

      const isMatch = await bcrypt.compare(password, user.password)
      if (!isMatch) {
        return res.status(400).json({ message: 'Invalid credentials' })
      }

      const token = jwt.sign({ userId: user._id }, process.env.JWT_SECRET, {
        expiresIn: '1h',
      })

      res.status(200).json({message: 'Successful Login', token })
    } catch (error) {
      res.status(500).json({ message: 'Error signing in' })
    }
  } else {
    res.setHeader('Allow', ['POST'])
    res.status(405).end(`Method ${req.method} Not Allowed`)
  }
}