/****************************************************************************************************************************
  base64.cpp - cpp source to a base64 encoding algorithm implementation

  For RTL8720DN, RTL8722DM and RTL8722CSM WiFi shields

  WiFiWebServer_RTL8720 is a library for the RTL8720DN, RTL8722DM and RTL8722CSM WiFi shields to run WebServer

  Built by Khoi Hoang https://github.com/khoih-prog/WiFiWebServer_RTL8720
  Licensed under MIT license

  Version: 1.1.2

  Version Modified By   Date      Comments
  ------- -----------  ---------- -----------
  1.0.0   K Hoang      14/07/2021 Initial coding for Realtek RTL8720DN, RTL8722DM and RTL8722CSM
  1.0.1   K Hoang      07/08/2021 Fix version typo
  1.1.0   K Hoang      26/12/2021 Fix bug related to usage of Arduino String. Optimize code
  1.1.1   K Hoang      26/12/2021 Fix authenticate issue caused by libb64
  1.1.2   K Hoang      27/04/2022 Change from `arduino.cc` to `arduino.tips` in examples
 *****************************************************************************************************************************/

#include "base64.h"

/* Simple test program
  #include <stdio.h>
  void main()
  {
    char* in = "amcewen";
    char out[22];

    b64_encode(in, 15, out, 22);
    out[21] = '\0';

    printf(out);
  }
*/

int base64_encode(const unsigned char* aInput, int aInputLen, unsigned char* aOutput, int aOutputLen)
{
  // Work out if we've got enough space to encode the input
  // Every 6 bits of input becomes a byte of output
  if (aOutputLen < (aInputLen * 8) / 6)
  {
    // FIXME Should we return an error here, or just the length
    return (aInputLen * 8) / 6;
  }

  // If we get here we've got enough space to do the encoding

  const char* b64_dictionary = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

  if (aInputLen == 3)
  {
    aOutput[0] = b64_dictionary[aInput[0] >> 2];
    aOutput[1] = b64_dictionary[(aInput[0] & 0x3) << 4 | (aInput[1] >> 4)];
    aOutput[2] = b64_dictionary[(aInput[1] & 0x0F) << 2 | (aInput[2] >> 6)];
    aOutput[3] = b64_dictionary[aInput[2] & 0x3F];
  }
  else if (aInputLen == 2)
  {
    aOutput[0] = b64_dictionary[aInput[0] >> 2];
    aOutput[1] = b64_dictionary[(aInput[0] & 0x3) << 4 | (aInput[1] >> 4)];
    aOutput[2] = b64_dictionary[(aInput[1] & 0x0F) << 2];
    aOutput[3] = '=';
  }
  else if (aInputLen == 1)
  {
    aOutput[0] = b64_dictionary[aInput[0] >> 2];
    aOutput[1] = b64_dictionary[(aInput[0] & 0x3) << 4];
    aOutput[2] = '=';
    aOutput[3] = '=';
  }
  else
  {
    // Break the input into 3-byte chunks and process each of them
    int i;

    for (i = 0; i < aInputLen / 3; i++)
    {
      base64_encode(&aInput[i * 3], 3, &aOutput[i * 4], 4);
    }

    if (aInputLen % 3 > 0)
    {
      // It doesn't fit neatly into a 3-byte chunk, so process what's left
      base64_encode(&aInput[i * 3], aInputLen % 3, &aOutput[i * 4], aOutputLen - (i * 4));
    }
  }

  return ((aInputLen + 2) / 3) * 4;
}

