import { z } from 'zod'

export const integrationTypeEnum = z.enum([
  'DISCORD',
  'SLACK',
  'GITHUB',
  'GITLAB'
])

export const expiresAfterEnum = z.enum(['never', '24', '168', '720', '8760'])

export const rotateAfterEnum = z.enum(['never', '24', '168', '720', '8760'])

export const eventSourceEnum = z.enum([
  'SECRET',
  'VARIABLE',
  'ENVIRONMENT',
  'PROJECT',
  'WORKSPACE',
  'WORKSPACE_ROLE',
  'INTEGRATION'
])

export const eventTriggererEnum = z.enum(['USER', 'SYSTEM'])

export const eventSeverityEnum = z.enum(['INFO', 'WARN', 'ERROR'])

export const eventTypeEnum = z.enum([
  'INVITED_TO_WORKSPACE',
  'REMOVED_FROM_WORKSPACE',
  'ACCEPTED_INVITATION',
  'DECLINED_INVITATION',
  'CANCELLED_INVITATION',
  'LEFT_WORKSPACE',
  'WORKSPACE_MEMBERSHIP_UPDATED',
  'WORKSPACE_UPDATED',
  'WORKSPACE_CREATED',
  'WORKSPACE_ROLE_CREATED',
  'WORKSPACE_ROLE_UPDATED',
  'WORKSPACE_ROLE_DELETED',
  'PROJECT_CREATED',
  'PROJECT_UPDATED',
  'PROJECT_DELETED',
  'SECRET_UPDATED',
  'SECRET_DELETED',
  'SECRET_ADDED',
  'VARIABLE_UPDATED',
  'VARIABLE_DELETED',
  'VARIABLE_ADDED',
  'ENVIRONMENT_UPDATED',
  'ENVIRONMENT_DELETED',
  'ENVIRONMENT_ADDED',
  'INTEGRATION_ADDED',
  'INTEGRATION_UPDATED',
  'INTEGRATION_DELETED'
])

export const authorityEnum = z.enum([
  'CREATE_PROJECT',
  'READ_USERS',
  'ADD_USER',
  'REMOVE_USER',
  'UPDATE_USER_ROLE',
  'READ_WORKSPACE',
  'UPDATE_WORKSPACE',
  'DELETE_WORKSPACE',
  'CREATE_WORKSPACE_ROLE',
  'READ_WORKSPACE_ROLE',
  'UPDATE_WORKSPACE_ROLE',
  'DELETE_WORKSPACE_ROLE',
  'WORKSPACE_ADMIN',
  'READ_PROJECT',
  'UPDATE_PROJECT',
  'DELETE_PROJECT',
  'CREATE_SECRET',
  'READ_SECRET',
  'UPDATE_SECRET',
  'DELETE_SECRET',
  'CREATE_ENVIRONMENT',
  'READ_ENVIRONMENT',
  'UPDATE_ENVIRONMENT',
  'DELETE_ENVIRONMENT',
  'CREATE_VARIABLE',
  'READ_VARIABLE',
  'UPDATE_VARIABLE',
  'DELETE_VARIABLE',
  'CREATE_INTEGRATION',
  'READ_INTEGRATION',
  'UPDATE_INTEGRATION',
  'DELETE_INTEGRATION',
  'CREATE_WORKSPACE',
  'CREATE_API_KEY',
  'READ_API_KEY',
  'UPDATE_API_KEY',
  'DELETE_API_KEY',
  'UPDATE_PROFILE',
  'READ_SELF',
  'UPDATE_SELF',
  'READ_EVENT'
])

export const projectAccessLevelEnum = z.enum(['GLOBAL', 'INTERNAL', 'PRIVATE'])
