# Contribution Guidelines

Thank you for your interest in contributing to our project. Whether it's a bug report, new feature, correction, or additional documentation, we greatly value feedback and contributions from our community.

Please read through this document before submitting any issues or pull requests to ensure we have all the necessary information to effectively respond to your bug report or contribution.

## Reporting Bugs/Issues

Before reporting a bug, please check our list of [open issues](https://github.com/keyshade-xyz/keyshade/issues) to see if someone has already reported the bug. If it's an open issue, please add any additional information that you think might be helpful. If it's not, please [create a new issue](https://github.com/keyshade-xyz/keyshade/issues/new/choose) and include as much information as you can. Information like a detailed description of the issue, steps to reproduce the issue, and any error messages are incredibly helpful.

## Suggesting Enhancements

If you have ideas for improvements or new features we would love to hear them. Please provide as much detail as possible so we can fully understand your ideas. You can [create a new issue](https://github.com/keyshade-xyz/keyshade/issues/new/choose) to share your suggestions.

## Self Assigning Issues

1. To express interest in working on an issue, simply type `/attempt` at the beginning of a comment.
2. If the issue is unassigned, it will be automatically assigned to you. ✨
3. If the issue is already assigned, you'll receive a message indicating the need to contact a maintainer to discuss reassignment.

**Example:**
`/attempt` I'd like to work on this issue.

## Code Contribution

Please ensure your pull request adheres to the following guidelines:

- Search the [open pull requests](https://github.com/keyshade-xyz/keyshade/pulls) to ensure someone else has not already submitted the change.
- Make sure your code follows the style guidelines of the project. For TypeScript, we use ESLint and [Prettier](.prettierrc) for formatting. For Rust, we use Cargo for building and testing.
- Make sure your code passes all the project's tests. You can run tests using `pnpm run test`.
- For setting up the project, do check the [Getting Started](https://docs.keyshade.xyz/contributing-to-keyshade/prerequisites) guide.
- Write good commit messages by following [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/).
- Include relevant issue number if applicable.
- Your PR should follow this pattern: `fix|feat|chore|docs|style|refactor|perf|test|ci|build|breaking-change|revert: <description>`. For example, `feat: add new feature` or `fix: fix a bug`. Note that description can contain only alphanumeric characters and `-`, `.` and `_` characters.
- Before you make a push to your branch, make sure you rebase your branch with the latest changes from the `develop` branch.

## Documentation

We love documentation contributions! Whether it's more complete descriptions, new examples, or better formatting, any help improving the documentation is appreciated.

## Community

You can chat with the core team on [our discord](https://discord.gg/xJFggHUPAf). Please be respectful to each other and follow our code of conduct.

Thank you again for your interest in our project, your contribution, and your support!

[Your Project Team](mailto:support@keyshade.xyz)
