// Code generated by tutone: DO NOT EDIT
package workloads

import (
	"encoding/json"
	"fmt"

	"github.com/newrelic/newrelic-client-go/v2/pkg/accounts"
	"github.com/newrelic/newrelic-client-go/v2/pkg/common"
	"github.com/newrelic/newrelic-client-go/v2/pkg/nrtime"
	"github.com/newrelic/newrelic-client-go/v2/pkg/users"
)

// EntityCollectionType - Indicates where this collection is used
type EntityCollectionType string

var EntityCollectionTypeTypes = struct {
	// Collections that define the entities that belong to a workload
	WORKLOAD EntityCollectionType
	// Collections that define the entity groups that are used to calculate the status of a workload
	WORKLOAD_STATUS_RULE_GROUP EntityCollectionType
}{
	// Collections that define the entities that belong to a workload
	WORKLOAD: "WORKLOAD",
	// Collections that define the entity groups that are used to calculate the status of a workload
	WORKLOAD_STATUS_RULE_GROUP: "WORKLOAD_STATUS_RULE_GROUP",
}

// WorkloadGroupRemainingEntitiesRuleBy - Indicates by which field the remaining entities rule should be grouped.
type WorkloadGroupRemainingEntitiesRuleBy string

var WorkloadGroupRemainingEntitiesRuleByTypes = struct {
	// Group the remaining entities rule by entity type.
	ENTITY_TYPE WorkloadGroupRemainingEntitiesRuleBy
	// Do not apply any grouping to the remaining entities rule.
	NONE WorkloadGroupRemainingEntitiesRuleBy
}{
	// Group the remaining entities rule by entity type.
	ENTITY_TYPE: "ENTITY_TYPE",
	// Do not apply any grouping to the remaining entities rule.
	NONE: "NONE",
}

// WorkloadResultingGroupType - Represents the type of the rule that the resulting group of entities belongs to.
type WorkloadResultingGroupType string

var WorkloadResultingGroupTypeTypes = struct {
	// The rule considers the entities within a specific group in the workload.
	REGULAR_GROUP WorkloadResultingGroupType
	// The rule considers all the entities within the workload that aren’t evaluated in any other rule.
	REMAINING_ENTITIES WorkloadResultingGroupType
}{
	// The rule considers the entities within a specific group in the workload.
	REGULAR_GROUP: "REGULAR_GROUP",
	// The rule considers all the entities within the workload that aren’t evaluated in any other rule.
	REMAINING_ENTITIES: "REMAINING_ENTITIES",
}

// WorkloadRollupStrategy - Represents the rollup strategy that is applied to a group of entities.
type WorkloadRollupStrategy string

var WorkloadRollupStrategyTypes = struct {
	// The group status matches the less critical status of all belonging entities.
	BEST_STATUS_WINS WorkloadRollupStrategy
	// The group status matches the most critical status of all belonging entities.
	WORST_STATUS_WINS WorkloadRollupStrategy
}{
	// The group status matches the less critical status of all belonging entities.
	BEST_STATUS_WINS: "BEST_STATUS_WINS",
	// The group status matches the most critical status of all belonging entities.
	WORST_STATUS_WINS: "WORST_STATUS_WINS",
}

// WorkloadRuleThresholdType - Represents the type of the threshold defined for a rule.
type WorkloadRuleThresholdType string

var WorkloadRuleThresholdTypeTypes = struct {
	// The worst status is rolled up only after a certain number of entities within the workload are not operational.
	FIXED WorkloadRuleThresholdType
	// The worst status is rolled up only after a certain percentage of entities within the workload are not operational.
	PERCENTAGE WorkloadRuleThresholdType
}{
	// The worst status is rolled up only after a certain number of entities within the workload are not operational.
	FIXED: "FIXED",
	// The worst status is rolled up only after a certain percentage of entities within the workload are not operational.
	PERCENTAGE: "PERCENTAGE",
}

// WorkloadStatusSource - Indicates where the status value derives from.
type WorkloadStatusSource string

var WorkloadStatusSourceTypes = struct {
	// Refers to the result of an automatic rule defined for a workload.
	ROLLUP_RULE WorkloadStatusSource
	// Refers to a static status defined for a workload.
	STATIC WorkloadStatusSource
	// Refers to an undetermined status source.
	UNKNOWN WorkloadStatusSource
	// Refers to the override policy that is applied to a set of partial results within a workload. Any static status always overrides any other status values calculated automatically. Otherwise, the worst status of the partial results is rolled up.
	WORKLOAD WorkloadStatusSource
}{
	// Refers to the result of an automatic rule defined for a workload.
	ROLLUP_RULE: "ROLLUP_RULE",
	// Refers to a static status defined for a workload.
	STATIC: "STATIC",
	// Refers to an undetermined status source.
	UNKNOWN: "UNKNOWN",
	// Refers to the override policy that is applied to a set of partial results within a workload. Any static status always overrides any other status values calculated automatically. Otherwise, the worst status of the partial results is rolled up.
	WORKLOAD: "WORKLOAD",
}

// WorkloadStatusValue - The status of the workload, which is derived from the static and the automatic statuses configured. Any static status always overrides any other status values calculated automatically.
type WorkloadStatusValue string

var WorkloadStatusValueTypes = struct {
	// The status of the workload is degraded.
	DEGRADED WorkloadStatusValue
	// The status of the workload is disrupted.
	DISRUPTED WorkloadStatusValue
	// The status of the workload is operational.
	OPERATIONAL WorkloadStatusValue
	// The status of the workload is unknown.
	UNKNOWN WorkloadStatusValue
}{
	// The status of the workload is degraded.
	DEGRADED: "DEGRADED",
	// The status of the workload is disrupted.
	DISRUPTED: "DISRUPTED",
	// The status of the workload is operational.
	OPERATIONAL: "OPERATIONAL",
	// The status of the workload is unknown.
	UNKNOWN: "UNKNOWN",
}

// WorkloadStatusValueInput - The status value. Any static status always overrides any other status values calculated automatically.
type WorkloadStatusValueInput string

var WorkloadStatusValueInputTypes = struct {
	// The status of the workload is degraded.
	DEGRADED WorkloadStatusValueInput
	// The status of the workload is disrupted.
	DISRUPTED WorkloadStatusValueInput
	// The status of the workload is operational.
	OPERATIONAL WorkloadStatusValueInput
}{
	// The status of the workload is degraded.
	DEGRADED: "DEGRADED",
	// The status of the workload is disrupted.
	DISRUPTED: "DISRUPTED",
	// The status of the workload is operational.
	OPERATIONAL: "OPERATIONAL",
}

// Account - The `Account` object provides general data about the account, as well as
// being the entry point into more detailed data about a single account.
//
// Account configuration data is queried through this object, as well as
// telemetry data that is specific to a single account.
type Account struct {
	//
	ID int `json:"id,omitempty"`
	//
	LicenseKey string `json:"licenseKey,omitempty"`
	//
	Name string `json:"name,omitempty"`
	// This field provides access to Workload data.
	Workload WorkloadAccountStitchedFields `json:"workload,omitempty"`
}

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// The `account` field is the entry point into data that is scoped to a single account.
	Account Account `json:"account,omitempty"`
}

// WorkloadAccountStitchedFields -
type WorkloadAccountStitchedFields struct {
	// [DEPRECATED] Retrieves a workload.
	Collection WorkloadCollection `json:"collection,omitempty"`
	// [DEPRECATED] Status and breakdown preview.
	StatusBreakdownPreview WorkloadWorkloadStatus `json:"statusBreakdownPreview"`
}

// WorkloadAutomaticStatus - The automatic status configuration.
type WorkloadAutomaticStatus struct {
	// Whether the automatic status configuration is enabled or not.
	Enabled bool `json:"enabled"`
	// An additional meta-rule that can consider all entities that haven't been evaluated by any other rule.
	RemainingEntitiesRule WorkloadRemainingEntitiesRule `json:"remainingEntitiesRule,omitempty"`
	// A list of rules.
	Rules []WorkloadRegularRule `json:"rules"`
}

// WorkloadAutomaticStatusInput - An input object used to represent an automatic status configuration. If not provided, a status configuration will be created by default.
type WorkloadAutomaticStatusInput struct {
	// Whether the automatic status configuration is enabled or not.
	Enabled bool `json:"enabled"`
	// An additional meta-rule that can consider all entities that haven't been evaluated by any other rule.
	RemainingEntitiesRule *WorkloadRemainingEntitiesRuleInput `json:"remainingEntitiesRule,omitempty"`
	// A list of rules.
	Rules []WorkloadRegularRuleInput `json:"rules,omitempty"`
}

// WorkloadCollection - A user defined group of entities.
type WorkloadCollection struct {
	// The account the workload belongs to.
	Account accounts.AccountReference `json:"account"`
	// The moment when the object was created, represented in milliseconds since the Unix epoch.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt"`
	// The user who created the workload.
	CreatedBy users.UserReference `json:"createdBy,omitempty"`
	// Relevant information about the workload.
	Description string `json:"description,omitempty"`
	// A list of entity GUIDs. These entities will belong to the collection as long as their accounts are included in the scope accounts of the collection.
	Entities []WorkloadEntityRef `json:"entities"`
	// A list of entity search queries. The resulting entities will be limited to the scope accounts of the collection.
	EntitySearchQueries []WorkloadEntitySearchQuery `json:"entitySearchQueries"`
	// The entity search query that returns the full collection of entities.
	EntitySearchQuery string `json:"entitySearchQuery,omitempty"`
	// The unique entity identifier of the workload in New Relic.
	GUID common.EntityGUID `json:"guid"`
	// The unique identifier of the workload.
	ID int `json:"id"`
	// The workload's name.
	Name string `json:"name"`
	// The URL of the workload.
	Permalink string `json:"permalink"`
	// Accounts that will be used to get entities from.
	ScopeAccounts WorkloadScopeAccounts `json:"scopeAccounts"`
	// Status of the workload.
	Status WorkloadWorkloadStatus `json:"status"`
	// The configuration that defines how the status of the workload is calculated.
	StatusConfig WorkloadStatusConfig `json:"statusConfig,omitempty"`
	// The moment when the object was last updated, represented in milliseconds since the Unix epoch.
	UpdatedAt *nrtime.EpochMilliseconds `json:"updatedAt,omitempty"`
	// The user who last updated the workload.
	UpdatedBy users.UserReference `json:"updatedBy,omitempty"`
}

// WorkloadCreateInput - The input object used to represent the workload to be created.
type WorkloadCreateInput struct {
	// Relevant information about the workload.
	Description string `json:"description,omitempty"`
	// A list of entity GUIDs composing the workload.
	EntityGUIDs []common.EntityGUID `json:"entityGuids"`
	// A list of entity search queries used to retrieve the entities that compose the workload.
	EntitySearchQueries []WorkloadEntitySearchQueryInput `json:"entitySearchQueries,omitempty"`
	// The name of the workload.
	Name string `json:"name"`
	// Accounts that will be used to get entities from.
	ScopeAccounts *WorkloadScopeAccountsInput `json:"scopeAccounts,omitempty"`
	// The configuration that defines how the status of the workload is calculated.
	StatusConfig *WorkloadStatusConfigInput `json:"statusConfig,omitempty"`
}

// WorkloadDuplicateInput - The input object used to represent the workload duplicate.
type WorkloadDuplicateInput struct {
	// The name of the workload duplicate. If the name isn't specified, the name + ' copy' of the source workload is used to compose the new name.
	Name string `json:"name,omitempty"`
}

// WorkloadEntityRef - A reference to a New Relic entity.
type WorkloadEntityRef struct {
	// The unique entity identifier in New Relic.
	GUID common.EntityGUID `json:"guid,omitempty"`
}

// WorkloadEntitySearchQuery - An entity search query used to dynamically retrieve a group of entities.
type WorkloadEntitySearchQuery struct {
	// The moment when the object was created, represented in milliseconds since the Unix epoch.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt"`
	// The user who created the entity search query.
	CreatedBy users.UserReference `json:"createdBy,omitempty"`
	// The unique identifier of the entity search query.
	ID int `json:"id"`
	// The entity search query that is used to perform the search of a group of entities.
	Query string `json:"query"`
	// The moment when the object was last updated, represented in milliseconds since the Unix epoch.
	UpdatedAt *nrtime.EpochMilliseconds `json:"updatedAt,omitempty"`
}

// WorkloadEntitySearchQueryInput - The input object used to represent the entity search query to be created.
type WorkloadEntitySearchQueryInput struct {
	// The entity search query that is used to perform the search of a group of entities.
	Query string `json:"query"`
}

// WorkloadRegularRule - The definition of a rule, which consists of a group of entities and a rollup strategy.
type WorkloadRegularRule struct {
	// A list of entity GUIDs. These entities will belong to the collection as long as their accounts are included in the scope accounts of the collection.
	Entities []WorkloadEntityRef `json:"entities"`
	// A list of entity search queries. These queries are constrained to the workload contents.
	EntitySearchQueries []WorkloadEntitySearchQuery `json:"entitySearchQueries"`
	// The unique identifier of the rule.
	ID int `json:"id,omitempty"`
	// The rollup strategy.
	Rollup WorkloadRollup `json:"rollup"`
}

// WorkloadRegularRuleInput - The input object used to represent a rule.
type WorkloadRegularRuleInput struct {
	// A list of entity GUIDs composing the rule.
	EntityGUIDs []common.EntityGUID `json:"entityGuids"`
	// A list of entity search queries used to retrieve the entities that compose the rule.
	EntitySearchQueries []WorkloadEntitySearchQueryInput `json:"entitySearchQueries,omitempty"`
	// The input object used to represent a rollup strategy.
	Rollup *WorkloadRollupInput `json:"rollup,omitempty"`
}

// WorkloadRemainingEntitiesRule - The definition of a remaining entities rule.
type WorkloadRemainingEntitiesRule struct {
	// The rollup strategy.
	Rollup WorkloadRemainingEntitiesRuleRollup `json:"rollup"`
}

// WorkloadRemainingEntitiesRuleInput - The input object used to represent a remaining entities rule.
type WorkloadRemainingEntitiesRuleInput struct {
	// The input object used to represent a rollup strategy.
	Rollup *WorkloadRemainingEntitiesRuleRollupInput `json:"rollup,omitempty"`
}

// WorkloadRemainingEntitiesRuleRollup - The rollup strategy.
type WorkloadRemainingEntitiesRuleRollup struct {
	// The grouping to be applied to the remaining entities.
	GroupBy WorkloadGroupRemainingEntitiesRuleBy `json:"groupBy"`
	// The rollup strategy that is applied to a group of entities.
	Strategy WorkloadRollupStrategy `json:"strategy"`
	// Type of threshold defined for the rule. This is an optional field that only applies when strategy is WORST_STATUS_WINS. Use a threshold to roll up the worst status only after a certain amount of entities are not operational.
	ThresholdType WorkloadRuleThresholdType `json:"thresholdType,omitempty"`
	// Threshold value defined for the rule. This optional field is used in combination with thresholdType. If the threshold type is null, the threshold value will be ignored.
	ThresholdValue int `json:"thresholdValue,omitempty"`
}

// WorkloadRemainingEntitiesRuleRollupInput - The input object used to represent a rollup strategy.
type WorkloadRemainingEntitiesRuleRollupInput struct {
	// The grouping to be applied to the remaining entities.
	GroupBy WorkloadGroupRemainingEntitiesRuleBy `json:"groupBy"`
	// The rollup strategy that is applied to a group of entities.
	Strategy WorkloadRollupStrategy `json:"strategy"`
	// Type of threshold defined for the rule. This is an optional field that only applies when strategy is WORST_STATUS_WINS. Use a threshold to roll up the worst status only after a certain amount of entities are not operational.
	ThresholdType WorkloadRuleThresholdType `json:"thresholdType,omitempty"`
	// Threshold value defined for the rule. This optional field is used in combination with thresholdType. If the threshold type is null, the threshold value will be ignored.
	ThresholdValue int `json:"thresholdValue,omitempty"`
}

// WorkloadRollup - The rollup strategy.
type WorkloadRollup struct {
	// The rollup strategy that is applied to the group of entities.
	Strategy WorkloadRollupStrategy `json:"strategy"`
	// Type of threshold defined for the rule. This is an optional field that only applies when strategy is WORST_STATUS_WINS. Use a threshold to roll up the worst status only after a certain amount of entities are not operational.
	ThresholdType WorkloadRuleThresholdType `json:"thresholdType,omitempty"`
	// Threshold value defined for the rule. This optional field is used in combination with thresholdType. If the threshold type is null, the threshold value will be ignored.
	ThresholdValue int `json:"thresholdValue,omitempty"`
}

// WorkloadRollupInput - The input object used to represent a rollup strategy.
type WorkloadRollupInput struct {
	// The rollup strategy that is applied to a group of entities.
	Strategy WorkloadRollupStrategy `json:"strategy"`
	// Type of threshold defined for the rule. This is an optional field that only applies when strategy is WORST_STATUS_WINS. Use a threshold to roll up the worst status only after a certain amount of entities are not operational.
	ThresholdType WorkloadRuleThresholdType `json:"thresholdType,omitempty"`
	// Threshold value defined for the rule. This optional field is used in combination with thresholdType. If the threshold type is null, the threshold value will be ignored.
	ThresholdValue int `json:"thresholdValue,omitempty"`
}

// WorkloadRollupRuleDetails - Represents the details of a rollup rule.
type WorkloadRollupRuleDetails struct {
	// A list of entity search queries defined in the rule.
	EntitySearchQueries []string `json:"entitySearchQueries"`
	// Indicates if the rule has individual entities.
	HasIndividualEntities bool `json:"hasIndividualEntities"`
	// The amount of not operational entities after evaluating the rule.
	NotOperationalEntities int `json:"notOperationalEntities"`
	// The amount of operational entities after evaluating the rule.
	OperationalEntities int `json:"operationalEntities"`
	// The resulting type of the rollup rule.
	ResultingGroupType WorkloadResultingGroupType `json:"resultingGroupType"`
	// Type of threshold defined for the rule.
	ThresholdType WorkloadRuleThresholdType `json:"thresholdType,omitempty"`
	// The amount of entities the status of which is unknown.
	UnknownStatusEntities int `json:"unknownStatusEntities"`
}

// WorkloadRollupRuleStatusResult - A rollup rule that was involved in the calculation of the workload status.
type WorkloadRollupRuleStatusResult struct {
	// Represents the details of a rollup rule.
	RollupRuleDetails WorkloadRollupRuleDetails `json:"rollupRuleDetails,omitempty"`
	// Indicates where the status value derives from.
	Source WorkloadStatusSource `json:"source"`
	// The status of a rollup rule.
	Value WorkloadStatusValue `json:"value"`
}

func (x *WorkloadRollupRuleStatusResult) ImplementsWorkloadStatusResult() {}

// WorkloadScopeAccounts - Accounts that will be used to get entities from.
type WorkloadScopeAccounts struct {
	// A list of accounts that will be used to get entities from.
	AccountIDs []int `json:"accountIds"`
}

// WorkloadScopeAccountsInput - The input object containing accounts that will be used to get entities from.
type WorkloadScopeAccountsInput struct {
	// A list of accounts that will be used to get entities from.
	AccountIDs []int `json:"accountIds"`
}

// WorkloadStaticStatus - The static status configuration.
type WorkloadStaticStatus struct {
	// A description that provides additional details about the status of the workload.
	Description string `json:"description,omitempty"`
	// Whether the static status configuration is enabled or not. Note that only one static status can be enabled at a given time.
	Enabled bool `json:"enabled"`
	// The unique identifier of the static status.
	ID int `json:"id"`
	// The status of the workload.
	Status WorkloadStatusValue `json:"status"`
	// A short description of the status of the workload.
	Summary string `json:"summary,omitempty"`
}

// WorkloadStaticStatusInput - The input object used to represent the configuration of a static status.
type WorkloadStaticStatusInput struct {
	// A description that provides additional details about the status of the workload.
	Description string `json:"description,omitempty"`
	// Whether the static status configuration is enabled or not.
	Enabled bool `json:"enabled"`
	// The status of the workload.
	Status WorkloadStatusValueInput `json:"status"`
	// A short description of the status of the workload.
	Summary string `json:"summary,omitempty"`
}

// WorkloadStaticStatusResult - A static status that was involved in the calculation of the workload status.
type WorkloadStaticStatusResult struct {
	// A description that provides additional details about the status of the workload.
	Description string `json:"description,omitempty"`
	// Indicates where the status value derives from.
	Source WorkloadStatusSource `json:"source"`
	// A short description of the status of the workload.
	Summary string `json:"summary,omitempty"`
	// The value of a static status.
	Value WorkloadStatusValue `json:"value"`
}

func (x *WorkloadStaticStatusResult) ImplementsWorkloadStatusResult() {}

// WorkloadStatus - Detailed information about the status of a workload.
type WorkloadStatus struct {
	// A description that provides additional details about the status of the workload.
	Description string `json:"description,omitempty"`
	// Indicates where the status value derives from.
	StatusSource WorkloadStatusSource `json:"statusSource,omitempty"`
	// The status of the workload.
	StatusValue WorkloadStatusValue `json:"statusValue,omitempty"`
	// A short description of the status of the workload.
	Summary string `json:"summary,omitempty"`
}

// WorkloadStatusConfig - The configuration that defines how the status of the workload is calculated.
type WorkloadStatusConfig struct {
	// An automatic status configuration.
	Automatic WorkloadAutomaticStatus `json:"automatic,omitempty"`
	// A list of static status configurations.
	Static []WorkloadStaticStatus `json:"static"`
}

// WorkloadStatusConfigInput - The input object used to provide the configuration that defines how the status of the workload is calculated.
type WorkloadStatusConfigInput struct {
	// An input object used to represent an automatic status configuration.
	Automatic *WorkloadAutomaticStatusInput `json:"automatic,omitempty"`
	// A list of static status configurations. You can only configure one static status for a workload.
	Static []WorkloadStaticStatusInput `json:"static,omitempty"`
}

// WorkloadStatusResult - The details of a status that was involved in the calculation of the workload status.
type WorkloadStatusResult struct {
	// Indicates where the status value derives from.
	Source WorkloadStatusSource `json:"source"`
	// The value of a status.
	Value WorkloadStatusValue `json:"value"`
}

func (x *WorkloadStatusResult) ImplementsWorkloadStatusResult() {}

// WorkloadUpdateAutomaticStatusInput - An input object used to represent an automatic status configuration.
type WorkloadUpdateAutomaticStatusInput struct {
	// Whether the automatic status configuration is enabled or not.
	Enabled bool `json:"enabled"`
	// An additional meta-rule that can consider all entities that haven't been evaluated by any other rule.
	RemainingEntitiesRule *WorkloadRemainingEntitiesRuleInput `json:"remainingEntitiesRule,omitempty"`
	// A list of rules.
	Rules []WorkloadUpdateRegularRuleInput `json:"rules,omitempty"`
}

// WorkloadUpdateCollectionEntitySearchQueryInput - The input object used to represent the entity search query to be updated.
type WorkloadUpdateCollectionEntitySearchQueryInput struct {
	// The unique identifier of the entity search query to be updated. If not provided, a new entity search query is created.
	ID int `json:"id,omitempty"`
	// The entity search query that is used to perform the search of a group of entities.
	Query string `json:"query"`
}

// WorkloadUpdateInput - The input object used to identify the workload to be updated and the new values.
type WorkloadUpdateInput struct {
	// Relevant information about the workload.
	Description string `json:"description,omitempty"`
	// A list of entity GUIDs composing the workload.
	EntityGUIDs []common.EntityGUID `json:"entityGuids"`
	// A list of entity search queries used to retrieve the groups of entities that compose the workload.
	EntitySearchQueries []WorkloadUpdateCollectionEntitySearchQueryInput `json:"entitySearchQueries,omitempty"`
	// The name of the workload.
	Name string `json:"name,omitempty"`
	// Accounts that will be used to get entities from.
	ScopeAccounts *WorkloadScopeAccountsInput `json:"scopeAccounts,omitempty"`
	// The configuration that defines how the status of the workload is calculated.
	StatusConfig *WorkloadUpdateStatusConfigInput `json:"statusConfig,omitempty"`
}

// WorkloadUpdateRegularRuleInput - The input object used to represent a rule.
type WorkloadUpdateRegularRuleInput struct {
	// A list of entity GUIDs composing the rule.
	EntityGUIDs []common.EntityGUID `json:"entityGuids"`
	// A list of entity search queries used to retrieve the groups of entities that compose the rule.
	EntitySearchQueries []WorkloadUpdateCollectionEntitySearchQueryInput `json:"entitySearchQueries,omitempty"`
	// The unique identifier of the rule to be updated. If not provided, a new rule is created.
	ID int `json:"id,omitempty"`
	// The input object used to represent a roll-up strategy.
	Rollup *WorkloadRollupInput `json:"rollup,omitempty"`
}

// WorkloadUpdateStaticStatusInput - The input object used to represent the configuration of a static status.
type WorkloadUpdateStaticStatusInput struct {
	// A description that provides additional details about the status of the workload.
	Description string `json:"description,omitempty"`
	// Whether the static status configuration is enabled or not.
	Enabled bool `json:"enabled"`
	// The unique identifier of the static status to be updated. If not provided, a new static status is created.
	ID int `json:"id,omitempty"`
	// The status of the workload.
	Status WorkloadStatusValueInput `json:"status"`
	// A short description of the static status.
	Summary string `json:"summary,omitempty"`
}

// WorkloadUpdateStatusConfigInput - The input object used to provide the configuration that defines how the status of the workload is calculated.
type WorkloadUpdateStatusConfigInput struct {
	// An input object used to represent an automatic status configuration.
	Automatic *WorkloadUpdateAutomaticStatusInput `json:"automatic,omitempty"`
	// A list of static status configurations. You can only configure one static status for a workload.
	Static []WorkloadUpdateStaticStatusInput `json:"static,omitempty"`
}

// WorkloadWorkloadStatus - Status of the workload.
type WorkloadWorkloadStatus struct {
	// A description that provides additional details about the status of the workload.
	Description string `json:"description,omitempty"`
	// Indicates where the status value derives from.
	Source WorkloadStatusSource `json:"source"`
	// The details of the statuses that were involved in the calculation of the workload status.
	StatusDetails []WorkloadStatusResultInterface `json:"statusDetails"`
	// A short description of the status of the workload.
	Summary string `json:"summary,omitempty"`
	// The status of the workload.
	Value WorkloadStatusValue `json:"value"`
}

// special
func (x *WorkloadWorkloadStatus) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "description":
			err = json.Unmarshal(*v, &x.Description)
			if err != nil {
				return err
			}
		case "source":
			err = json.Unmarshal(*v, &x.Source)
			if err != nil {
				return err
			}
		case "statusDetails":
			if v == nil {
				continue
			}
			var rawMessageStatusDetails []*json.RawMessage
			err = json.Unmarshal(*v, &rawMessageStatusDetails)
			if err != nil {
				return err
			}

			for _, m := range rawMessageStatusDetails {
				xxx, err := UnmarshalWorkloadStatusResultInterface(*m)
				if err != nil {
					return err
				}

				if xxx != nil {
					x.StatusDetails = append(x.StatusDetails, *xxx)
				}
			}
		case "summary":
			err = json.Unmarshal(*v, &x.Summary)
			if err != nil {
				return err
			}
		case "value":
			err = json.Unmarshal(*v, &x.Value)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

type collectionResponse struct {
	Actor Actor `json:"actor"`
}

// AttributeMap - This scalar represents a map of attributes in the form of key-value pairs.
type AttributeMap string

// DateTime - The `DateTime` scalar represents a date and time. The `DateTime` appears as an ISO8601 formatted string.
type DateTime string

// Float - The `Float` scalar type represents signed double-precision fractional
// values as specified by
// [IEEE 754](http://en.wikipedia.org/wiki/IEEE_floating_point).
type Float string

// ID - The `ID` scalar type represents a unique identifier, often used to
// refetch an object or as key for a cache. The ID type appears in a JSON
// response as a String; however, it is not intended to be human-readable.
// When expected as an input type, any string (such as `"4"`) or integer
// (such as `4`) input value will be accepted as an ID.
type ID string

// Minutes - The `Minutes` scalar represents a duration in minutes
type Minutes string

// NRQL - This scalar represents a NRQL query string.
//
// See the [NRQL Docs](https://docs.newrelic.com/docs/insights/nrql-new-relic-query-language/nrql-resources/nrql-syntax-components-functions) for more information about NRQL syntax.
type NRQL string

// NerdStorageDocument - This scalar represents a NerdStorage document.
type NerdStorageDocument string

// Seconds - The `Seconds` scalar represents a duration in seconds
type Seconds string

// WorkloadStatusResult - The details of a status that was involved in the calculation of the workload status.
type WorkloadStatusResultInterface interface {
	ImplementsWorkloadStatusResult()
}

// UnmarshalWorkloadStatusResultInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalWorkloadStatusResultInterface(b []byte) (*WorkloadStatusResultInterface, error) {
	var err error

	var rawMessageWorkloadStatusResult map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageWorkloadStatusResult)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageWorkloadStatusResult) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageWorkloadStatusResult["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "WorkloadRollupRuleStatusResult":
			var interfaceType WorkloadRollupRuleStatusResult
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx WorkloadStatusResultInterface = &interfaceType

			return &xxx, nil
		case "WorkloadStaticStatusResult":
			var interfaceType WorkloadStaticStatusResult
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx WorkloadStatusResultInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageWorkloadStatusResult {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface WorkloadStatusResult did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface WorkloadStatusResult was not matched against all PossibleTypes: %s", typeName)
}
