// Code generated by tutone: DO NOT EDIT
package usermanagement

import (
	"github.com/newrelic/newrelic-client-go/v2/pkg/nrtime"
)

// OrganizationAuthenticationTypeEnum - Provides the available values for authentication type
type OrganizationAuthenticationTypeEnum string

var OrganizationAuthenticationTypeEnumTypes = struct {
	// Authentication not configured
	DISABLED OrganizationAuthenticationTypeEnum
	// Heroku Single Sign-On
	HEROKU_SSO OrganizationAuthenticationTypeEnum
	// Oidc Single Sign-On
	OIDC_SSO OrganizationAuthenticationTypeEnum
	// Username and password authentication
	PASSWORD OrganizationAuthenticationTypeEnum
	// SAML Single Sign-On
	SAML_SSO OrganizationAuthenticationTypeEnum
}{
	// Authentication not configured
	DISABLED: "DISABLED",
	// Heroku Single Sign-On
	HEROKU_SSO: "HEROKU_SSO",
	// Oidc Single Sign-On
	OIDC_SSO: "OIDC_SSO",
	// Username and password authentication
	PASSWORD: "PASSWORD",
	// SAML Single Sign-On
	SAML_SSO: "SAML_SSO",
}

// OrganizationProvisioningTypeEnum - Provides the available values for provisioning type
type OrganizationProvisioningTypeEnum string

var OrganizationProvisioningTypeEnumTypes = struct {
	// Provisioning not configured
	DISABLED OrganizationProvisioningTypeEnum
	// Manual provisioning
	MANUAL OrganizationProvisioningTypeEnum
	// SCIM automated provisioning
	SCIM OrganizationProvisioningTypeEnum
}{
	// Provisioning not configured
	DISABLED: "DISABLED",
	// Manual provisioning
	MANUAL: "MANUAL",
	// SCIM automated provisioning
	SCIM: "SCIM",
}

// UserManagementGroupSortKey - Available keys for sorting groups
type UserManagementGroupSortKey string

var UserManagementGroupSortKeyTypes = struct {
	// Sort by display name
	DISPLAY_NAME UserManagementGroupSortKey
	// Sort by ID
	ID UserManagementGroupSortKey
}{
	// Sort by display name
	DISPLAY_NAME: "DISPLAY_NAME",
	// Sort by ID
	ID: "ID",
}

// UserManagementRequestedTierName - Valid request types for user change requests
type UserManagementRequestedTierName string

var UserManagementRequestedTierNameTypes = struct {
	// basic tier
	BASIC_USER_TIER UserManagementRequestedTierName
	// core tier
	CORE_USER_TIER UserManagementRequestedTierName
	// full tier
	FULL_USER_TIER UserManagementRequestedTierName
}{
	// basic tier
	BASIC_USER_TIER: "BASIC_USER_TIER",
	// core tier
	CORE_USER_TIER: "CORE_USER_TIER",
	// full tier
	FULL_USER_TIER: "FULL_USER_TIER",
}

// UserManagementSortDirection - Available directions for sorting
type UserManagementSortDirection string

var UserManagementSortDirectionTypes = struct {
	// Sort in ascending order
	ASCENDING UserManagementSortDirection
	// Sort in descending order
	DESCENDING UserManagementSortDirection
}{
	// Sort in ascending order
	ASCENDING: "ASCENDING",
	// Sort in descending order
	DESCENDING: "DESCENDING",
}

// UserManagementTypeEnum - Available values for Type
type UserManagementTypeEnum string

var UserManagementTypeEnumTypes = struct {
	// Basic type
	BASIC UserManagementTypeEnum
	// Core type
	CORE UserManagementTypeEnum
	// Full type
	FULL_PLATFORM UserManagementTypeEnum
}{
	// Basic type
	BASIC: "BASIC",
	// Core type
	CORE: "CORE",
	// Full type
	FULL_PLATFORM: "FULL_PLATFORM",
}

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// The `organization` field is the entry point into data that is scoped to the user's organization.
	Organization Organization `json:"organization,omitempty"`
}

// AuthorizationManagementAuthenticationDomain - An "authentication domain" is a grouping of New Relic users governed by the same user management settings, like how they're provisioned (added and updated), how they're authenticated (logged in), session settings, and how user upgrades are managed.
type AuthorizationManagementAuthenticationDomain struct {
	// container for groups enabling cursor based pagination
	Groups AuthorizationManagementGroupSearch `json:"groups"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// the name of the object
	Name string `json:"name"`
}

// AuthorizationManagementAuthenticationDomainSearch - container for authentication domains enabling cursor based pagination
type AuthorizationManagementAuthenticationDomainSearch struct {
	// containers of users and groups
	AuthenticationDomains []AuthorizationManagementAuthenticationDomain `json:"authenticationDomains"`
	// an opaque cursor to supply with subsequent   requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// AuthorizationManagementGrantedRole - A Granted Role represents the access given to a group.
type AuthorizationManagementGrantedRole struct {
	// the account that this role grants access to
	AccountID int `json:"accountId,omitempty"`
	// the name of the object
	DisplayName string `json:"displayName,omitempty"`
	// the group that this role grants access to
	GroupId string `json:"groupId,omitempty"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// the name of the object
	Name string `json:"name"`
	// the organization this role grants access to
	OrganizationId string `json:"organizationId,omitempty"`
	// the role that defines this access
	RoleId int `json:"roleId"`
	// the type of the role
	Type string `json:"type"`
}

// AuthorizationManagementGrantedRoleSearch - container for roles enabling cursor based pagination
type AuthorizationManagementGrantedRoleSearch struct {
	// an opaque cursor to supply with subsequent   requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the roles granted to this group
	Roles []AuthorizationManagementGrantedRole `json:"roles"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// AuthorizationManagementGroup - For users on our New Relic One user model, a "group" represents a group of users. Putting users in a group allows the managing of permissions for multiple users at the same time.
type AuthorizationManagementGroup struct {
	// the name of the object
	DisplayName string `json:"displayName"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// container for roles enabling cursor based pagination
	Roles AuthorizationManagementGrantedRoleSearch `json:"roles"`
}

// AuthorizationManagementGroupSearch - container for groups enabling cursor based pagination
type AuthorizationManagementGroupSearch struct {
	// contains roles granted to users's groups
	Groups []AuthorizationManagementGroup `json:"groups"`
	// an opaque cursor to supply with subsequent   requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// Organization - The `Organization` object provides basic data about an organization.
type Organization struct {
	// The customer id for the organization.
	CustomerId string `json:"customerId,omitempty"`
	// The name of the organization.
	Name string `json:"name,omitempty"`
	// The telemetry id for the organization
	TelemetryId string `json:"telemetryId,omitempty"`
	// This field provides access to UserManagement data.
	UserManagement UserManagementOrganizationStitchedFields `json:"userManagement,omitempty"`
}

// OrganizationAuthenticationDomain - A grouping of users governed by the same user management settings
type OrganizationAuthenticationDomain struct {
	// Method of authenticating users
	AuthenticationType OrganizationAuthenticationTypeEnum `json:"authenticationType"`
	// The authentication domain id
	ID string `json:"id"`
	// The authentication domain name
	Name string `json:"name"`
	// The organization the authentication domain belongs to
	OrganizationId string `json:"organizationId"`
	// Method of provisioning users
	ProvisioningType OrganizationProvisioningTypeEnum `json:"provisioningType"`
}

// OrganizationAuthenticationDomainCollection - Authentication domains
type OrganizationAuthenticationDomainCollection struct {
	// Authentication domains
	Items []OrganizationAuthenticationDomain `json:"items"`
	// an opaque cursor to supply with subsequent requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
}

// UserManagementAddUsersToGroupsPayload - Autogenerated return type of AddUsersToGroups.
type UserManagementAddUsersToGroupsPayload struct {
	// The group(s) updated.
	Groups []UserManagementGroup `json:"groups"`
}

// UserManagementAuthenticationDomain - An "authentication domain" is a grouping of New Relic users governed by the same user management settings, like how they're provisioned (added and updated), how they're authenticated (logged in), session settings, and how user upgrades are managed.
type UserManagementAuthenticationDomain struct {
	// container for groups enabling cursor based pagination
	Groups UserManagementGroups `json:"groups,omitempty"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// the name of the object
	Name string `json:"name"`
	// the method used to provision users in this authentication domain
	ProvisioningType string `json:"provisioningType"`
	// container for users enabling cursor based pagination
	Users UserManagementUsers `json:"users,omitempty"`
}

// UserManagementAuthenticationDomains - container for authentication domains enabling cursor based pagination
type UserManagementAuthenticationDomains struct {
	// container for authentication_domains enabling cursor based pagination
	AuthenticationDomains []UserManagementAuthenticationDomain `json:"authenticationDomains"`
	// an opaque cursor to supply with subsequent     requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// UserManagementCreateGroup - The input object representing the group being created
type UserManagementCreateGroup struct {
	// The id of the authentication domain the group will belong to
	AuthenticationDomainId string `json:"authenticationDomainId"`
	// The name of the group
	DisplayName string `json:"displayName"`
}

// UserManagementCreateGroupPayload - Autogenerated return type of CreateGroup.
type UserManagementCreateGroupPayload struct {
	// The group that was created
	Group UserManagementGroup `json:"group,omitempty"`
}

// UserManagementCreateUser - The input object representing the user being created
type UserManagementCreateUser struct {
	// The authentication domain id for the user to be created under.
	AuthenticationDomainId string `json:"authenticationDomainId"`
	// The email address of the user to be created.
	Email string `json:"email"`
	// The name of the user to be created.
	Name string `json:"name"`
	// The user type for the user to be created.
	UserType UserManagementRequestedTierName `json:"userType,omitempty"`
}

// UserManagementCreateUserPayload - Autogenerated return type of CreateUser.
type UserManagementCreateUserPayload struct {
	// The user that was created
	CreatedUser UserManagementCreatedUser `json:"createdUser,omitempty"`
}

// UserManagementCreatedUser - A newly created user of New Relic scoped to an authentication domain.
type UserManagementCreatedUser struct {
	// Authentication domain of the created user.
	AuthenticationDomainId string `json:"authenticationDomainId,omitempty"`
	// Email address of the created user.
	Email string `json:"email"`
	// The ID of the created user.
	ID string `json:"id"`
	// The full name of the created user.
	Name string `json:"name"`
	// A "user type" is what determines the set of New Relic capabilities a user can theoretically access.
	Type UserManagementUserType `json:"type"`
}

// UserManagementDeleteGroup - The input object representing the group to remove
type UserManagementDeleteGroup struct {
	// The ID of the group being removed.
	ID string `json:"id"`
}

// UserManagementDeleteGroupPayload - Autogenerated return type of DeleteGroup.
type UserManagementDeleteGroupPayload struct {
	// The group that was deleted
	Group UserManagementGroup `json:"group,omitempty"`
}

// UserManagementDeleteUser - The input object representing the user being deleted
type UserManagementDeleteUser struct {
	// The ID of the user to be deleted
	ID string `json:"id"`
}

// UserManagementDeleteUserPayload - Autogenerated return type of DeleteUser.
type UserManagementDeleteUserPayload struct {
	// The user that was deleted
	DeletedUser UserManagementDeletedUser `json:"deletedUser,omitempty"`
}

// UserManagementDeletedUser - A user of New Relic to be deleted.
type UserManagementDeletedUser struct {
	// The id of the deleted user
	ID string `json:"id"`
}

// UserManagementDisplayNameInput - Available filtering types for group display names
type UserManagementDisplayNameInput struct {
	// Part of a display name
	Contains string `json:"contains,omitempty"`
	// A display name
	Eq string `json:"eq,omitempty"`
}

// UserManagementEmailInput - Available filtering types for email addresses
type UserManagementEmailInput struct {
	// Part of a user email
	Contains string `json:"contains,omitempty"`
	// A user email
	Eq string `json:"eq,omitempty"`
}

// UserManagementEmailVerificationStateInput - Available filtering types for email verification states
type UserManagementEmailVerificationStateInput struct {
	// An email verification state
	Pending bool `json:"pending"`
}

// UserManagementGroup - For users on our New Relic One user model, a "group" represents a group of users. Putting users in a group allows the managing of permissions for multiple users at the same time.
type UserManagementGroup struct {
	// the name of the object
	DisplayName string `json:"displayName"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// container for users enabling cursor based pagination
	Users UserManagementGroupUsers `json:"users,omitempty"`
}

// UserManagementGroupFilterInput - The input object representing the filter parameters for groups
type UserManagementGroupFilterInput struct {
	// Filter groups by display name
	DisplayName UserManagementDisplayNameInput `json:"displayName,omitempty"`
	// Filter groups by group ID
	ID UserManagementGroupIdInput `json:"id,omitempty"`
}

// UserManagementGroupIdInput - Available filtering types for group IDs
type UserManagementGroupIdInput struct {
	// A group ID
	Eq string `json:"eq,omitempty"`
	// An array of group IDs
	In []string `json:"in"`
}

// UserManagementGroupSortInput - The input object representing the sort parameters for groups
type UserManagementGroupSortInput struct {
	// Sort groups in this direction
	Direction UserManagementSortDirection `json:"direction,omitempty"`
	// Sort groups by this key
	Key UserManagementGroupSortKey `json:"key,omitempty"`
}

// UserManagementGroupUser - User information returned within Groups
type UserManagementGroupUser struct {
	// The email of the user.
	Email string `json:"email"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// The full name of the user.
	Name string `json:"name"`
	// The configured time zone of the user.
	TimeZone string `json:"timeZone"`
}

// UserManagementGroupUsers - container for users enabling cursor based pagination
type UserManagementGroupUsers struct {
	// an opaque cursor to supply with subsequent     requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the total number of results
	TotalCount int `json:"totalCount"`
	// container for users enabling cursor based pagination
	Users []UserManagementGroupUser `json:"users"`
}

// UserManagementGroups - container for groups enabling cursor based pagination
type UserManagementGroups struct {
	// container for groups enabling cursor based pagination
	Groups []UserManagementGroup `json:"groups"`
	// an opaque cursor to supply with subsequent     requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// UserManagementNameInput - Available filtering types for names
type UserManagementNameInput struct {
	// Part of a user name
	Contains string `json:"contains,omitempty"`
	// A user name
	Eq string `json:"eq,omitempty"`
}

type UserManagementOrganizationStitchedFields struct {
	// An "authentication domain" is a grouping of New Relic users governed by the same user management settings, like how they're provisioned (added and updated), how they're authenticated (logged in), session settings, and how user upgrades are managed.
	AuthenticationDomains UserManagementAuthenticationDomains `json:"authenticationDomains,omitempty"`
}

// UserManagementPendingUpgradeRequest - Exists only if a user has a pending upgrade request.
type UserManagementPendingUpgradeRequest struct {
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// Requester message, why the user believes they require the upgrade.
	Message string `json:"message,omitempty"`
	// Requested user type for the user.
	RequestedUserType UserManagementUserType `json:"requestedUserType,omitempty"`
}

// UserManagementPendingUpgradeRequestInput - Available filtering types for pending upgrade requests
type UserManagementPendingUpgradeRequestInput struct {
	// Whether a request exists or not
	Exists bool `json:"exists"`
}

// UserManagementRemoveUsersFromGroupsPayload - Autogenerated return type of RemoveUsersFromGroups.
type UserManagementRemoveUsersFromGroupsPayload struct {
	// The group(s) updated.
	Groups []UserManagementGroup `json:"groups"`
}

// UserManagementTypeInput - Available filtering types for user type
type UserManagementTypeInput struct {
	// A user type
	Eq UserManagementTypeEnum `json:"eq"`
}

// UserManagementUpdateGroup - The input object representing the group being updated
type UserManagementUpdateGroup struct {
	// The name of the group
	DisplayName string `json:"displayName"`
	// The id of the group to update
	ID string `json:"id"`
}

// UserManagementUpdateGroupPayload - Autogenerated return type of UpdateGroup.
type UserManagementUpdateGroupPayload struct {
	// The group that was updated
	Group UserManagementGroup `json:"group,omitempty"`
}

// UserManagementUpdateUser - The input object representing the user being updated
type UserManagementUpdateUser struct {
	// The new email address to be updated on the user
	Email string `json:"email,omitempty"`
	// The ID of the user to be updated
	ID string `json:"id"`
	// The full name of the user to be updated
	Name string `json:"name,omitempty"`
	// The user time zone to be updated, in IANA zoneinfo format, e.g. 'America/Chicago'
	TimeZone string `json:"timeZone,omitempty"`
	// The new user type to be updated on the user
	UserType UserManagementRequestedTierName `json:"userType,omitempty"`
}

// UserManagementUpdateUserPayload - Autogenerated return type of UpdateUser.
type UserManagementUpdateUserPayload struct {
	// The user that was updated
	User UserManagementUser `json:"user,omitempty"`
}

// UserManagementUser - A user of New Relic scoped to an authentication domain.
type UserManagementUser struct {
	// Email address of the user.
	Email string `json:"email,omitempty"`
	// One of: "Not Verifiable", "Verified", and "Pending".
	//
	// Not Verifiable: the user's email does not require verification.
	//
	// Verified: the user's email requires verification and has been.
	//
	// Pending: the user's email requires verification and has not been.
	EmailVerificationState string `json:"emailVerificationState"`
	// container for groups enabling cursor based pagination
	Groups UserManagementUserGroups `json:"groups,omitempty"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
	// The last active date of the user.
	LastActive nrtime.DateTime `json:"lastActive,omitempty"`
	// The full name of the user.
	Name string `json:"name,omitempty"`
	// The pending upgrade request for the user (if any).
	PendingUpgradeRequest UserManagementPendingUpgradeRequest `json:"pendingUpgradeRequest,omitempty"`
	// Time zone of the user in IANA Time Zone database format, also known as the "Olson" time zone database format (for exmaple, "America/Los_Angeles").
	TimeZone string `json:"timeZone,omitempty"`
	// A "user type" is what determines the set of New Relic capabilities a user can theoretically access.
	Type UserManagementUserType `json:"type"`
}

// UserManagementUserFilterInput - The input object representing the filter parameters for users
type UserManagementUserFilterInput struct {
	// Filter users by email address
	Email UserManagementEmailInput `json:"email,omitempty"`
	// Filter users by email verification state
	EmailVerificationState UserManagementEmailVerificationStateInput `json:"emailVerificationState,omitempty"`
	// Filter users by user ID
	ID UserManagementUserIdInput `json:"id,omitempty"`
	// Filter users by name
	Name UserManagementNameInput `json:"name,omitempty"`
	// Filter users by pending upgrade request
	PendingUpgradeRequest UserManagementPendingUpgradeRequestInput `json:"pendingUpgradeRequest,omitempty"`
	// Filter users by type
	Type UserManagementTypeInput `json:"type,omitempty"`
}

// UserManagementUserGroup - For users on our New Relic One user model, a "group" represents a group of users. Putting users in a group allows the managing of permissions for multiple users at the same time.
type UserManagementUserGroup struct {
	// the name of the object
	DisplayName string `json:"displayName"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
}

// UserManagementUserGroups - container for groups enabling cursor based pagination
type UserManagementUserGroups struct {
	// container for groups enabling cursor based pagination
	Groups []UserManagementUserGroup `json:"groups"`
	// an opaque cursor to supply with subsequent     requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the total number of results
	TotalCount int `json:"totalCount"`
}

// UserManagementUserIdInput - Available filtering types for user IDs
type UserManagementUserIdInput struct {
	// A user ID
	Eq string `json:"eq,omitempty"`
	// An array of user IDs
	In []string `json:"in"`
}

// UserManagementUserType - A "user type" is what determines the set of New Relic capabilities a user can theoretically access.
type UserManagementUserType struct {
	// the name of the object
	DisplayName string `json:"displayName"`
	// a value that uniquely identifies this object
	ID string `json:"id"`
}

// UserManagementUsers - container for users enabling cursor based pagination
type UserManagementUsers struct {
	// an opaque cursor to supply with subsequent     requests to get the next page of results, null if there are no more pages
	NextCursor string `json:"nextCursor,omitempty"`
	// the total number of results
	TotalCount int `json:"totalCount"`
	// container for users enabling cursor based pagination
	Users []UserManagementUser `json:"users"`
}

// UserManagementUsersGroupsInput - The input object representing the group(s) and user(s) to update.
type UserManagementUsersGroupsInput struct {
	// The id of the group(s) to add the user(s) to. Max: 10
	GroupIds []string `json:"groupIds"`
	// The id of the user(s) to be added to the group(s). Max: 50
	UserIDs []string `json:"userIds"`
}

type authenticationDomainsResponse struct {
	Actor Actor `json:"actor"`
}
