// Code generated by tutone: DO NOT EDIT
package synthetics

import (
	"encoding/json"
	"fmt"

	"github.com/newrelic/newrelic-client-go/v2/pkg/nrtime"
)

// Nr1CatalogInstallPlanDestination - Possible destinations for the install plan target
type Nr1CatalogInstallPlanDestination string

var Nr1CatalogInstallPlanDestinationTypes = struct {
	// Application (APM) install
	APPLICATION Nr1CatalogInstallPlanDestination
	// Cloud provider install
	CLOUD Nr1CatalogInstallPlanDestination
	// Host install
	HOST Nr1CatalogInstallPlanDestination
	// Kubernetes install
	KUBERNETES Nr1CatalogInstallPlanDestination
	// Unknown install - special case when the target where the install takes place is unknown (such as guided install)
	UNKNOWN Nr1CatalogInstallPlanDestination
}{
	// Application (APM) install
	APPLICATION: "APPLICATION",
	// Cloud provider install
	CLOUD: "CLOUD",
	// Host install
	HOST: "HOST",
	// Kubernetes install
	KUBERNETES: "KUBERNETES",
	// Unknown install - special case when the target where the install takes place is unknown (such as guided install)
	UNKNOWN: "UNKNOWN",
}

// Nr1CatalogInstallPlanDirectiveMode - Possible modes for an install plan directive
type Nr1CatalogInstallPlanDirectiveMode string

var Nr1CatalogInstallPlanDirectiveModeTypes = struct {
	// Directs the installation toward an external link
	LINK Nr1CatalogInstallPlanDirectiveMode
	// Directs the installation to open a stacked Nerdlet to perform the installation
	NERDLET Nr1CatalogInstallPlanDirectiveMode
	// Directs the installation toward a specific target
	TARGETED Nr1CatalogInstallPlanDirectiveMode
}{
	// Directs the installation toward an external link
	LINK: "LINK",
	// Directs the installation to open a stacked Nerdlet to perform the installation
	NERDLET: "NERDLET",
	// Directs the installation toward a specific target
	TARGETED: "TARGETED",
}

// Nr1CatalogInstallPlanOperatingSystem - Possible types for the install plan operating system
type Nr1CatalogInstallPlanOperatingSystem string

var Nr1CatalogInstallPlanOperatingSystemTypes = struct {
	// Mac operating system
	DARWIN Nr1CatalogInstallPlanOperatingSystem
	// Linux operating system
	LINUX Nr1CatalogInstallPlanOperatingSystem
	// Windows operating system
	WINDOWS Nr1CatalogInstallPlanOperatingSystem
}{
	// Mac operating system
	DARWIN: "DARWIN",
	// Linux operating system
	LINUX: "LINUX",
	// Windows operating system
	WINDOWS: "WINDOWS",
}

// Nr1CatalogInstallPlanTargetType - Possible types for the install plan target
type Nr1CatalogInstallPlanTargetType string

var Nr1CatalogInstallPlanTargetTypeTypes = struct {
	// Agent install
	AGENT Nr1CatalogInstallPlanTargetType
	// Integration install
	INTEGRATION Nr1CatalogInstallPlanTargetType
	// On host integration install
	ON_HOST_INTEGRATION Nr1CatalogInstallPlanTargetType
	// Unknown install - special case when the target where the install takes place is unknown (such as guided install)
	UNKNOWN Nr1CatalogInstallPlanTargetType
}{
	// Agent install
	AGENT: "AGENT",
	// Integration install
	INTEGRATION: "INTEGRATION",
	// On host integration install
	ON_HOST_INTEGRATION: "ON_HOST_INTEGRATION",
	// Unknown install - special case when the target where the install takes place is unknown (such as guided install)
	UNKNOWN: "UNKNOWN",
}

// SyntheticsAutomatedTestStatus - Enum of automated test status
type SyntheticsAutomatedTestStatus string

var SyntheticsAutomatedTestStatusTypes = struct {
	// At least one blocking job in the automated test has failed
	FAILED SyntheticsAutomatedTestStatus
	// Indicates jobs in the automated test are still running
	IN_PROGRESS SyntheticsAutomatedTestStatus
	// All blocking jobs in the automated test has passed
	PASSED SyntheticsAutomatedTestStatus
	// Some jobs in the automated test failed to provide a status within the timeout
	TIMEOUT SyntheticsAutomatedTestStatus
}{
	// At least one blocking job in the automated test has failed
	FAILED: "FAILED",
	// Indicates jobs in the automated test are still running
	IN_PROGRESS: "IN_PROGRESS",
	// All blocking jobs in the automated test has passed
	PASSED: "PASSED",
	// Some jobs in the automated test failed to provide a status within the timeout
	TIMEOUT: "TIMEOUT",
}

// SyntheticsBrowser - Enum of browser types
type SyntheticsBrowser string

var SyntheticsBrowserTypes = struct {
	// Chrome browser
	CHROME SyntheticsBrowser
	// Edge browser
	EDGE SyntheticsBrowser
	// Firefox browser
	FIREFOX SyntheticsBrowser
	// No Browser/Legacy
	NONE SyntheticsBrowser
}{
	// Chrome browser
	CHROME: "CHROME",
	// Edge browser
	EDGE: "EDGE",
	// Firefox browser
	FIREFOX: "FIREFOX",
	// No Browser/Legacy
	NONE: "NONE",
}

// SyntheticsDevice - enum for DeviceEmulation
type SyntheticsDevice string

var SyntheticsDeviceTypes = struct {
	// deviceType: DESKTOP, deviceOrientation: NONE
	DESKTOP SyntheticsDevice
	// deviceType: MOBILE, deviceOrientation: LANDSCAPE
	MOBILE_LANDSCAPE SyntheticsDevice
	// deviceType: MOBILE, deviceOrientation: PORTRAIT
	MOBILE_PORTRAIT SyntheticsDevice
	// No Device Settings
	NONE SyntheticsDevice
	// deviceType: TABLET, deviceOrientation: LANDSCAPE
	TABLET_LANDSCAPE SyntheticsDevice
	// deviceType: TABLET, deviceOrientation: PORTRAIT
	TABLET_PORTRAIT SyntheticsDevice
}{
	// deviceType: DESKTOP, deviceOrientation: NONE
	DESKTOP: "DESKTOP",
	// deviceType: MOBILE, deviceOrientation: LANDSCAPE
	MOBILE_LANDSCAPE: "MOBILE_LANDSCAPE",
	// deviceType: MOBILE, deviceOrientation: PORTRAIT
	MOBILE_PORTRAIT: "MOBILE_PORTRAIT",
	// No Device Settings
	NONE: "NONE",
	// deviceType: TABLET, deviceOrientation: LANDSCAPE
	TABLET_LANDSCAPE: "TABLET_LANDSCAPE",
	// deviceType: TABLET, deviceOrientation: PORTRAIT
	TABLET_PORTRAIT: "TABLET_PORTRAIT",
}

// SyntheticsDeviceOrientation - enum of Orientations that the user can select for their emulated device
type SyntheticsDeviceOrientation string

var SyntheticsDeviceOrientationTypes = struct {
	// This allows the screenshot to be taken in the landscape orientation
	LANDSCAPE SyntheticsDeviceOrientation
	// This will disable device emulation
	NONE SyntheticsDeviceOrientation
	// This allows the screenshot to be taken in the portrait orientation
	PORTRAIT SyntheticsDeviceOrientation
}{
	// This allows the screenshot to be taken in the landscape orientation
	LANDSCAPE: "LANDSCAPE",
	// This will disable device emulation
	NONE: "NONE",
	// This allows the screenshot to be taken in the portrait orientation
	PORTRAIT: "PORTRAIT",
}

// SyntheticsDeviceType - enum of DeviceTypes that the user can use for device emulation
type SyntheticsDeviceType string

var SyntheticsDeviceTypeTypes = struct {
	// This will be dimensions for a typical mobile device
	MOBILE SyntheticsDeviceType
	// This will disable device emulation
	NONE SyntheticsDeviceType
	// This will be dimensions for a typical tablet device
	TABLET SyntheticsDeviceType
}{
	// This will be dimensions for a typical mobile device
	MOBILE: "MOBILE",
	// This will disable device emulation
	NONE: "NONE",
	// This will be dimensions for a typical tablet device
	TABLET: "TABLET",
}

// SyntheticsJobStatus - Enum of job status
type SyntheticsJobStatus string

var SyntheticsJobStatusTypes = struct {
	// Indicates the job has failed
	FAILED SyntheticsJobStatus
	// Indicates an in-progress job
	PENDING SyntheticsJobStatus
	// Indicates the job has succeeded
	SUCCESS SyntheticsJobStatus
	// Indicates the job status was lost or unknown
	UNKNOWN SyntheticsJobStatus
}{
	// Indicates the job has failed
	FAILED: "FAILED",
	// Indicates an in-progress job
	PENDING: "PENDING",
	// Indicates the job has succeeded
	SUCCESS: "SUCCESS",
	// Indicates the job status was lost or unknown
	UNKNOWN: "UNKNOWN",
}

// SyntheticsMonitorCreateErrorType - Types of errors that can be returned from a create monitor request
type SyntheticsMonitorCreateErrorType string

var SyntheticsMonitorCreateErrorTypeTypes = struct {
	// Received a request missing required fields or containing invalid data
	BAD_REQUEST SyntheticsMonitorCreateErrorType
	// An unknown error occurred while processing request to mutate monitor
	INTERNAL_SERVER_ERROR SyntheticsMonitorCreateErrorType
	// Monitor not found for given guid (monitor does not exist on account or has already been deleted)
	NOT_FOUND SyntheticsMonitorCreateErrorType
	// Monitor creation exceeds account subscription limits
	PAYMENT_REQUIRED SyntheticsMonitorCreateErrorType
	// Monitor tags were not updated.
	TAGGING_ERROR SyntheticsMonitorCreateErrorType
	// User does not have authorization to perform monitor mutation.
	UNAUTHORIZED SyntheticsMonitorCreateErrorType
	// An unknown error occurred while processing request to create monitor
	UNKNOWN_ERROR SyntheticsMonitorCreateErrorType
}{
	// Received a request missing required fields or containing invalid data
	BAD_REQUEST: "BAD_REQUEST",
	// An unknown error occurred while processing request to mutate monitor
	INTERNAL_SERVER_ERROR: "INTERNAL_SERVER_ERROR",
	// Monitor not found for given guid (monitor does not exist on account or has already been deleted)
	NOT_FOUND: "NOT_FOUND",
	// Monitor creation exceeds account subscription limits
	PAYMENT_REQUIRED: "PAYMENT_REQUIRED",
	// Monitor tags were not updated.
	TAGGING_ERROR: "TAGGING_ERROR",
	// User does not have authorization to perform monitor mutation.
	UNAUTHORIZED: "UNAUTHORIZED",
	// An unknown error occurred while processing request to create monitor
	UNKNOWN_ERROR: "UNKNOWN_ERROR",
}

// SyntheticsMonitorDowntimeDayOfMonthOrdinal - enum of which day in the month a customer can have a monitor downtime run
type SyntheticsMonitorDowntimeDayOfMonthOrdinal string

var SyntheticsMonitorDowntimeDayOfMonthOrdinalTypes = struct {
	// First selected day of the month
	FIRST SyntheticsMonitorDowntimeDayOfMonthOrdinal
	// Fourth selected day of the month
	FOURTH SyntheticsMonitorDowntimeDayOfMonthOrdinal
	// Last selected day of the month
	LAST SyntheticsMonitorDowntimeDayOfMonthOrdinal
	// Second selected day of the month
	SECOND SyntheticsMonitorDowntimeDayOfMonthOrdinal
	// Third selected day of the month
	THIRD SyntheticsMonitorDowntimeDayOfMonthOrdinal
}{
	// First selected day of the month
	FIRST: "FIRST",
	// Fourth selected day of the month
	FOURTH: "FOURTH",
	// Last selected day of the month
	LAST: "LAST",
	// Second selected day of the month
	SECOND: "SECOND",
	// Third selected day of the month
	THIRD: "THIRD",
}

// SyntheticsMonitorDowntimeWeekDays - enum of weekdays customers can select monitor downtimes to run
type SyntheticsMonitorDowntimeWeekDays string

var SyntheticsMonitorDowntimeWeekDaysTypes = struct {
	// Select monitor downtime to run on Friday
	FRIDAY SyntheticsMonitorDowntimeWeekDays
	// Select monitor downtime to run on Monday
	MONDAY SyntheticsMonitorDowntimeWeekDays
	// Select monitor downtime to run on Saturday
	SATURDAY SyntheticsMonitorDowntimeWeekDays
	// Select monitor downtime to run on Sunday
	SUNDAY SyntheticsMonitorDowntimeWeekDays
	// Select monitor downtime to run on Thursday
	THURSDAY SyntheticsMonitorDowntimeWeekDays
	// Select monitor downtime to run on Tuesday
	TUESDAY SyntheticsMonitorDowntimeWeekDays
	// Select monitor downtime to run on Wednesday
	WEDNESDAY SyntheticsMonitorDowntimeWeekDays
}{
	// Select monitor downtime to run on Friday
	FRIDAY: "FRIDAY",
	// Select monitor downtime to run on Monday
	MONDAY: "MONDAY",
	// Select monitor downtime to run on Saturday
	SATURDAY: "SATURDAY",
	// Select monitor downtime to run on Sunday
	SUNDAY: "SUNDAY",
	// Select monitor downtime to run on Thursday
	THURSDAY: "THURSDAY",
	// Select monitor downtime to run on Tuesday
	TUESDAY: "TUESDAY",
	// Select monitor downtime to run on Wednesday
	WEDNESDAY: "WEDNESDAY",
}

// SyntheticsMonitorPeriod - Enum of monitor period types
type SyntheticsMonitorPeriod string

var SyntheticsMonitorPeriodTypes = struct {
	// 10 minute monitor period
	EVERY_10_MINUTES SyntheticsMonitorPeriod
	// 12 hour monitor period (720 minutes)
	EVERY_12_HOURS SyntheticsMonitorPeriod
	// 15 minute monitor period
	EVERY_15_MINUTES SyntheticsMonitorPeriod
	// 30 minute monitor period
	EVERY_30_MINUTES SyntheticsMonitorPeriod
	// 5 minute monitor period
	EVERY_5_MINUTES SyntheticsMonitorPeriod
	// 6 hour monitor period (360 minutes)
	EVERY_6_HOURS SyntheticsMonitorPeriod
	// 1 day monitor period (1440 minutes)
	EVERY_DAY SyntheticsMonitorPeriod
	// 1 hour monitor period (60 minutes)
	EVERY_HOUR SyntheticsMonitorPeriod
	// 1 minute monitor period
	EVERY_MINUTE SyntheticsMonitorPeriod
}{
	// 10 minute monitor period
	EVERY_10_MINUTES: "EVERY_10_MINUTES",
	// 12 hour monitor period (720 minutes)
	EVERY_12_HOURS: "EVERY_12_HOURS",
	// 15 minute monitor period
	EVERY_15_MINUTES: "EVERY_15_MINUTES",
	// 30 minute monitor period
	EVERY_30_MINUTES: "EVERY_30_MINUTES",
	// 5 minute monitor period
	EVERY_5_MINUTES: "EVERY_5_MINUTES",
	// 6 hour monitor period (360 minutes)
	EVERY_6_HOURS: "EVERY_6_HOURS",
	// 1 day monitor period (1440 minutes)
	EVERY_DAY: "EVERY_DAY",
	// 1 hour monitor period (60 minutes)
	EVERY_HOUR: "EVERY_HOUR",
	// 1 minute monitor period
	EVERY_MINUTE: "EVERY_MINUTE",
}

// SyntheticsMonitorStatus - Run state of the monitor
type SyntheticsMonitorStatus string

var SyntheticsMonitorStatusTypes = struct {
	// Monitor disabled runs status of a monitor
	DISABLED SyntheticsMonitorStatus
	// Enabled status of a monitor
	ENABLED SyntheticsMonitorStatus
}{
	// Monitor disabled runs status of a monitor
	DISABLED: "DISABLED",
	// Enabled status of a monitor
	ENABLED: "ENABLED",
}

// SyntheticsMonitorType - Enum of monitor types
type SyntheticsMonitorType string

var SyntheticsMonitorTypeTypes = struct {
	// Broken links monitor
	BROKEN_LINKS SyntheticsMonitorType
	// Simple browser monitor
	BROWSER SyntheticsMonitorType
	// Certificate Check
	CERT_CHECK SyntheticsMonitorType
	// Script API monitor
	SCRIPT_API SyntheticsMonitorType
	// Script browser monitor
	SCRIPT_BROWSER SyntheticsMonitorType
	// Simple (ping) monitor
	SIMPLE SyntheticsMonitorType
	// Step Monitor
	STEP_MONITOR SyntheticsMonitorType
}{
	// Broken links monitor
	BROKEN_LINKS: "BROKEN_LINKS",
	// Simple browser monitor
	BROWSER: "BROWSER",
	// Certificate Check
	CERT_CHECK: "CERT_CHECK",
	// Script API monitor
	SCRIPT_API: "SCRIPT_API",
	// Script browser monitor
	SCRIPT_BROWSER: "SCRIPT_BROWSER",
	// Simple (ping) monitor
	SIMPLE: "SIMPLE",
	// Step Monitor
	STEP_MONITOR: "STEP_MONITOR",
}

// SyntheticsMonitorUpdateErrorType - Types of errors that can be returned from a Monitor mutation request
type SyntheticsMonitorUpdateErrorType string

var SyntheticsMonitorUpdateErrorTypeTypes = struct {
	// Received a request missing required fields or containing invalid data
	BAD_REQUEST SyntheticsMonitorUpdateErrorType
	// An unknown error occurred while processing request to mutate monitor
	INTERNAL_SERVER_ERROR SyntheticsMonitorUpdateErrorType
	// Monitor not found for given guid (monitor does not exist on account or has already been deleted)
	NOT_FOUND SyntheticsMonitorUpdateErrorType
	// Monitor update exceeds account subscription limits
	PAYMENT_REQUIRED SyntheticsMonitorUpdateErrorType
	// An error occurred while updating monitor script
	SCRIPT_ERROR SyntheticsMonitorUpdateErrorType
	// Monitor tags were not updated.
	TAGGING_ERROR SyntheticsMonitorUpdateErrorType
	// User does not have authorization to perform monitor mutation.
	UNAUTHORIZED SyntheticsMonitorUpdateErrorType
	// An unknown error occurred while processing request to update monitor
	UNKNOWN_ERROR SyntheticsMonitorUpdateErrorType
}{
	// Received a request missing required fields or containing invalid data
	BAD_REQUEST: "BAD_REQUEST",
	// An unknown error occurred while processing request to mutate monitor
	INTERNAL_SERVER_ERROR: "INTERNAL_SERVER_ERROR",
	// Monitor not found for given guid (monitor does not exist on account or has already been deleted)
	NOT_FOUND: "NOT_FOUND",
	// Monitor update exceeds account subscription limits
	PAYMENT_REQUIRED: "PAYMENT_REQUIRED",
	// An error occurred while updating monitor script
	SCRIPT_ERROR: "SCRIPT_ERROR",
	// Monitor tags were not updated.
	TAGGING_ERROR: "TAGGING_ERROR",
	// User does not have authorization to perform monitor mutation.
	UNAUTHORIZED: "UNAUTHORIZED",
	// An unknown error occurred while processing request to update monitor
	UNKNOWN_ERROR: "UNKNOWN_ERROR",
}

// SyntheticsPrivateLocationMutationErrorType - Types of errors that can be returned from a Private Location mutation request
type SyntheticsPrivateLocationMutationErrorType string

var SyntheticsPrivateLocationMutationErrorTypeTypes = struct {
	// Received a request missing required fields or containing invalid data
	BAD_REQUEST SyntheticsPrivateLocationMutationErrorType
	// An unknown error occurred while processing request to purge specified private location job queue
	INTERNAL_SERVER_ERROR SyntheticsPrivateLocationMutationErrorType
	// Private location not found for key (private location does not exist on account or has already been deleted)
	NOT_FOUND SyntheticsPrivateLocationMutationErrorType
	// User does not have authorization to purge job queue for specified private location
	UNAUTHORIZED SyntheticsPrivateLocationMutationErrorType
}{
	// Received a request missing required fields or containing invalid data
	BAD_REQUEST: "BAD_REQUEST",
	// An unknown error occurred while processing request to purge specified private location job queue
	INTERNAL_SERVER_ERROR: "INTERNAL_SERVER_ERROR",
	// Private location not found for key (private location does not exist on account or has already been deleted)
	NOT_FOUND: "NOT_FOUND",
	// User does not have authorization to purge job queue for specified private location
	UNAUTHORIZED: "UNAUTHORIZED",
}

// SyntheticsStepType - enum of of script step types
type SyntheticsStepType string

var SyntheticsStepTypeTypes = struct {
	// Assert on element accessed by ID, CSS, or x-path
	ASSERT_ELEMENT SyntheticsStepType
	// Assert on modal exists
	ASSERT_MODAL SyntheticsStepType
	// Assert on text accessed by ID, CSS, or x-path
	ASSERT_TEXT SyntheticsStepType
	// Assert on title of page
	ASSERT_TITLE SyntheticsStepType
	// Click on an element by ID, CSS, or x-path
	CLICK_ELEMENT SyntheticsStepType
	// Preform actions on a modal to dismiss
	DISMISS_MODAL SyntheticsStepType
	// Double click on an element by ID, CSS, or x-path
	DOUBLE_CLICK_ELEMENT SyntheticsStepType
	// Hover over an element by x-path
	HOVER_ELEMENT SyntheticsStepType
	// Navigate to the specified url
	NAVIGATE SyntheticsStepType
	// Input secure credential into element accessed by ID, CSS, or x-path
	SECURE_TEXT_ENTRY SyntheticsStepType
	// Select a dropdown element by value, text, ID, CSS, or x-path
	SELECT_ELEMENT SyntheticsStepType
	// Input text into element accessed by ID, CSS, or x-path
	TEXT_ENTRY SyntheticsStepType
}{
	// Assert on element accessed by ID, CSS, or x-path
	ASSERT_ELEMENT: "ASSERT_ELEMENT",
	// Assert on modal exists
	ASSERT_MODAL: "ASSERT_MODAL",
	// Assert on text accessed by ID, CSS, or x-path
	ASSERT_TEXT: "ASSERT_TEXT",
	// Assert on title of page
	ASSERT_TITLE: "ASSERT_TITLE",
	// Click on an element by ID, CSS, or x-path
	CLICK_ELEMENT: "CLICK_ELEMENT",
	// Preform actions on a modal to dismiss
	DISMISS_MODAL: "DISMISS_MODAL",
	// Double click on an element by ID, CSS, or x-path
	DOUBLE_CLICK_ELEMENT: "DOUBLE_CLICK_ELEMENT",
	// Hover over an element by x-path
	HOVER_ELEMENT: "HOVER_ELEMENT",
	// Navigate to the specified url
	NAVIGATE: "NAVIGATE",
	// Input secure credential into element accessed by ID, CSS, or x-path
	SECURE_TEXT_ENTRY: "SECURE_TEXT_ENTRY",
	// Select a dropdown element by value, text, ID, CSS, or x-path
	SELECT_ELEMENT: "SELECT_ELEMENT",
	// Input text into element accessed by ID, CSS, or x-path
	TEXT_ENTRY: "TEXT_ENTRY",
}

// Account - The `Account` object provides general data about the account, as well as
// being the entry point into more detailed data about a single account.
//
// Account configuration data is queried through this object, as well as
// telemetry data that is specific to a single account.
type Account struct {
	ID         int    `json:"id,omitempty"`
	LicenseKey string `json:"licenseKey,omitempty"`
	Name       string `json:"name,omitempty"`
	// This field provides access to Synthetics data.
	Synthetics SyntheticsAccountStitchedFields `json:"synthetics,omitempty"`
}

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// The `account` field is the entry point into data that is scoped to a single account.
	Account Account `json:"account,omitempty"`
}

// Nr1CatalogInstallPlanDirective - Information about an install plan directive
type Nr1CatalogInstallPlanDirective struct {
	// The mode of the install plan directive
	Mode Nr1CatalogInstallPlanDirectiveMode `json:"mode"`
}

func (x *Nr1CatalogInstallPlanDirective) ImplementsNr1CatalogInstallPlanDirective() {}

// Nr1CatalogInstallPlanStep - Information pertaining to a specific step in the installation plan
type Nr1CatalogInstallPlanStep struct {
	// A short form description for the install plan step
	Description string `json:"description,omitempty"`
	// The human-readable name for the install plan step
	DisplayName string `json:"displayName"`
	// Provides context about how the fallback install plan step should proceed
	Fallback Nr1CatalogInstallPlanDirectiveInterface `json:"fallback,omitempty"`
	// Used as a heading for the install plan step
	Heading string `json:"heading"`
	// The unique identifier for the install plan step
	ID string `json:"id"`
	// Provides context about how the primary install plan step should proceed
	Primary Nr1CatalogInstallPlanDirectiveInterface `json:"primary"`
	// Provides context about where the install will occur
	Target Nr1CatalogInstallPlanTarget `json:"target"`
}

// special
func (x *Nr1CatalogInstallPlanStep) UnmarshalJSON(b []byte) error {
	var objMap map[string]*json.RawMessage
	err := json.Unmarshal(b, &objMap)
	if err != nil {
		return err
	}

	for k, v := range objMap {
		if v == nil {
			continue
		}

		switch k {
		case "description":
			err = json.Unmarshal(*v, &x.Description)
			if err != nil {
				return err
			}
		case "displayName":
			err = json.Unmarshal(*v, &x.DisplayName)
			if err != nil {
				return err
			}
		case "fallback":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalNr1CatalogInstallPlanDirectiveInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.Fallback = *xxx
			}
		case "heading":
			err = json.Unmarshal(*v, &x.Heading)
			if err != nil {
				return err
			}
		case "id":
			err = json.Unmarshal(*v, &x.ID)
			if err != nil {
				return err
			}
		case "primary":
			if v == nil {
				continue
			}
			xxx, err := UnmarshalNr1CatalogInstallPlanDirectiveInterface(*v)
			if err != nil {
				return err
			}

			if xxx != nil {
				x.Primary = *xxx
			}
		case "target":
			err = json.Unmarshal(*v, &x.Target)
			if err != nil {
				return err
			}
		}
	}

	return nil
}

// Nr1CatalogInstallPlanTarget - Represents the location of an install
type Nr1CatalogInstallPlanTarget struct {
	// Provides context on the location the install will take place
	Destination Nr1CatalogInstallPlanDestination `json:"destination"`
	// Provides context for the operating system that will be targeted
	Os []Nr1CatalogInstallPlanOperatingSystem `json:"os"`
	// Provides context for the type of installation that will take place
	Type Nr1CatalogInstallPlanTargetType `json:"type"`
}

// Nr1CatalogLinkInstallPlanDirective - Information about a link install plan directive
type Nr1CatalogLinkInstallPlanDirective struct {
	// The mode of the install plan directive
	Mode Nr1CatalogInstallPlanDirectiveMode `json:"mode"`
	// The URL of the external link used to guide the user through installation
	URL string `json:"url"`
}

func (x *Nr1CatalogLinkInstallPlanDirective) ImplementsNr1CatalogInstallPlanDirective() {}

// Nr1CatalogNerdletInstallPlanDirective - Information about a targeted install plan directive
type Nr1CatalogNerdletInstallPlanDirective struct {
	// The mode of the install plan directive
	Mode Nr1CatalogInstallPlanDirectiveMode `json:"mode"`
	// The nerdlet ID used to guide the user through installation
	NerdletId string `json:"nerdletId"`
	// The nerdlet state used to intialize the nerdlet
	NerdletState Nr1CatalogRawNerdletState `json:"nerdletState,omitempty"`
}

func (x *Nr1CatalogNerdletInstallPlanDirective) ImplementsNr1CatalogInstallPlanDirective() {}

// Nr1CatalogTargetedInstallPlanDirective - Information about a targeted install plan directive
type Nr1CatalogTargetedInstallPlanDirective struct {
	// The mode of the install plan directive
	Mode Nr1CatalogInstallPlanDirectiveMode `json:"mode"`
	// The name of the recipe used for the installation
	RecipeName string `json:"recipeName"`
}

func (x *Nr1CatalogTargetedInstallPlanDirective) ImplementsNr1CatalogInstallPlanDirective() {}

// SyntheticsAccountStitchedFields - Nerdgraph account field
type SyntheticsAccountStitchedFields struct {
	// Query that fetches results for an automated test
	AutomatedTestResult SyntheticsAutomatedTestResult `json:"automatedTestResult,omitempty"`
	// Query that fetches the script of a specific scripted monitor
	Script SyntheticsMonitorScriptQueryResponse `json:"script,omitempty"`
	// visiblity(flag:Synthetics/setGraphqlCustomerVisible) Query that fetches the steps used by the specified Step Monitor
	Steps []SyntheticsStep `json:"steps"`
}

// SyntheticsAutomatedTestConfig - Global automated test config
type SyntheticsAutomatedTestConfig struct {
	// An identifier for the automated test run
	BatchName string `json:"batchName,omitempty"`
	// Branch metadata to indicate what triggered the automated test
	Branch string `json:"branch,omitempty"`
	// Commit metadata to indicate what commit triggered the automated test
	Commit string `json:"commit,omitempty"`
	// Metadata for the automated test
	DeepLink string `json:"deepLink,omitempty"`
	// Metadata about the platform target the automated test will run against
	Platform string `json:"platform,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	Repository string `json:"repository,omitempty"`
}

// SyntheticsAutomatedTestConfigInput - Global automated test config
type SyntheticsAutomatedTestConfigInput struct {
	// An identifier for the automated test run
	BatchName string `json:"batchName,omitempty" yaml:"batchName,omitempty"`
	// Branch metadata to indicate what triggered the automated test
	Branch string `json:"branch,omitempty" yaml:"branch,omitempty"`
	// Commit metadata to indicate what commit triggered the automated test
	Commit string `json:"commit,omitempty" yaml:"commit,omitempty"`
	// Metadata for the automated test
	DeepLink string `json:"deepLink,omitempty" yaml:"deepLink,omitempty"`
	// Metadata about the platform target the automated test will run against
	Platform string `json:"platform,omitempty" yaml:"platform,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	Repository string `json:"repository,omitempty" yaml:"repository,omitempty"`
}

// SyntheticsAutomatedTestJobResult - Information on a job that was apart of a batch of automated test jobs
type SyntheticsAutomatedTestJobResult struct {
	// Test overrides
	AutomatedTestMonitorConfig SyntheticsAutomatedTestMonitorConfig `json:"automatedTestMonitorConfig,omitempty"`
	// Job batch Id
	BatchId string `json:"batchId,omitempty"`
	// Job duration
	Duration int `json:"duration,omitempty"`
	// Job error if any
	Error string `json:"error,omitempty"`
	// Job Id
	ID string `json:"id,omitempty"`
	// Job location
	Location string `json:"location,omitempty"`
	// Job location label
	LocationLabel string `json:"locationLabel,omitempty"`
	// Monitor nr1 entity guid
	MonitorGUID EntityGUID `json:"monitorGuid,omitempty"`
	// Job monitor Id
	MonitorId string `json:"monitorId,omitempty"`
	// Job monitor name
	MonitorName string `json:"monitorName,omitempty"`
	// Job result
	Result SyntheticsJobStatus `json:"result,omitempty"`
	// Link to job results
	ResultsURL string `json:"resultsUrl,omitempty"`
	// Job type
	Type SyntheticsMonitorType `json:"type,omitempty"`
	// Job type label
	TypeLabel string `json:"typeLabel,omitempty"`
}

// SyntheticsAutomatedTestMonitorConfig - Monitor specific test config
type SyntheticsAutomatedTestMonitorConfig struct {
	// Specifies whether a failure of this monitor should fail the entire automated test
	IsBlocking bool `json:"isBlocking"`
	// Specific overrides for the given monitor
	Overrides *SyntheticsAutomatedTestOverrides `json:"overrides"`
}

// SyntheticsAutomatedTestMonitorConfigInput - Monitor specific test configuration
type SyntheticsAutomatedTestMonitorConfigInput struct {
	// Specifies whether a failure of this monitor should fail the entire automated test
	IsBlocking bool `json:"isBlocking" yaml:"isBlocking"`
	// Specific overrides for the given monitor
	Overrides *SyntheticsAutomatedTestOverridesInput `json:"overrides" yaml:"overrides"`
}

// SyntheticsAutomatedTestMonitorInput - Monitor test definition to be included in the automated test
type SyntheticsAutomatedTestMonitorInput struct {
	// The monitor config for an automated test
	Config SyntheticsAutomatedTestMonitorConfigInput `json:"config,omitempty" yaml:"config,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	MonitorGUID EntityGUID `json:"monitorGuid" yaml:"monitorGuid"`
}

// SyntheticsAutomatedTestOverrides - Automated test monitor overrides
type SyntheticsAutomatedTestOverrides struct {
	// Override a domain throughout a scripted monitor
	Domain []SyntheticsScriptDomainOverride `json:"domain,omitempty"`
	// Override monitor to use a specific location
	Location string `json:"location,omitempty"`
	// Override a script secure credential with another credential value
	SecureCredential []SyntheticsSecureCredentialOverride `json:"secureCredential,omitempty"`
	// Override a browser monitor starting url
	StartingURL string `json:"startingUrl,omitempty"`
}

// SyntheticsAutomatedTestOverridesInput - Automated test monitor overrides
type SyntheticsAutomatedTestOverridesInput struct {
	// Override a domain throughout a scripted monitor
	Domain []SyntheticsScriptDomainOverrideInput `json:"domain,omitempty" yaml:"domain,omitempty"`
	// Override monitor to use a specific location
	Location string `json:"location,omitempty" yaml:"location,omitempty"`
	// Override a script secure credential with another credential value
	SecureCredential []SyntheticsSecureCredentialOverrideInput `json:"secureCredential,omitempty" yaml:"secureCredential,omitempty"`
	// Override a browser monitor starting url
	StartingURL string `json:"startingUrl,omitempty" yaml:"startingUrl,omitempty"`
}

// SyntheticsAutomatedTestResult - Results from fetching automated test job
type SyntheticsAutomatedTestResult struct {
	// Automated test config
	Config SyntheticsAutomatedTestConfig `json:"config,omitempty"`
	// Finished time of the automated test batch
	FinishTimestamp *nrtime.EpochMilliseconds `json:"finishTimestamp,omitempty"`
	// Start time of the automated test batch
	StartTimestamp *nrtime.EpochMilliseconds `json:"startTimestamp,omitempty"`
	// Calculated status of automated test as a whole
	Status SyntheticsAutomatedTestStatus `json:"status,omitempty"`
	// List of completed automated test jobs
	Tests []SyntheticsAutomatedTestJobResult `json:"tests,omitempty"`
}

// SyntheticsAutomatedTestStartResult - Results from starting automated test job
type SyntheticsAutomatedTestStartResult struct {
	// Job batch Id
	BatchId string `json:"batchId,omitempty"`
}

// SyntheticsBrokenLinksMonitor - A Broken Links monitor resulting from a Broken Links monitor mutation
type SyntheticsBrokenLinksMonitor struct {
	// The creation time of the monitor in millis
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	GUID EntityGUID `json:"guid,omitempty"`
	// The unique identifier of the monitor within the Synthetics domain
	ID string `json:"id,omitempty"`
	// The locations the monitor runs from
	Locations SyntheticsLocations `json:"locations,omitempty"`
	// The last modification time of the monitor in millis
	ModifiedAt *nrtime.EpochMilliseconds `json:"modifiedAt,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime SyntheticsExtendedTypeMonitorRuntime `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri,omitempty"`
}

// SyntheticsBrokenLinksMonitorCreateMutationResult - The result of a Broken Links monitor create mutation
type SyntheticsBrokenLinksMonitorCreateMutationResult struct {
	// Errors that occurred during Broken Links monitor create mutation
	Errors []SyntheticsMonitorCreateError `json:"errors"`
	// The resulting Broken Links monitor
	Monitor SyntheticsBrokenLinksMonitor `json:"monitor,omitempty"`
}

// SyntheticsBrokenLinksMonitorUpdateMutationResult - The result of a Broken Links monitor update mutation
type SyntheticsBrokenLinksMonitorUpdateMutationResult struct {
	// Errors that occurred during Broken Links monitor update mutation
	Errors []SyntheticsMonitorUpdateError `json:"errors"`
	// The resulting Broken Links monitor
	Monitor SyntheticsBrokenLinksMonitor `json:"monitor,omitempty"`
}

// SyntheticsCertCheckMonitor - A Cert Check monitor resulting from a Cert Check monitor mutation
type SyntheticsCertCheckMonitor struct {
	// The creation time of the monitor in millis
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The domain of the host that will have its certificate checked
	Domain string `json:"domain,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	GUID EntityGUID `json:"guid,omitempty"`
	// The unique identifier of the monitor within the Synthetics domain
	ID string `json:"id,omitempty"`
	// The locations the monitor runs from
	Locations SyntheticsLocations `json:"locations,omitempty"`
	// The last modification time of the monitor in millis
	ModifiedAt *nrtime.EpochMilliseconds `json:"modifiedAt,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The desired number of remaining days until the certificate expires to trigger a monitor failure
	NumberDaysToFailBeforeCertExpires int `json:"numberDaysToFailBeforeCertExpires,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime SyntheticsExtendedTypeMonitorRuntime `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
}

// SyntheticsCertCheckMonitorCreateMutationResult - The result of a Cert Check monitor create mutation
type SyntheticsCertCheckMonitorCreateMutationResult struct {
	// Errors that occurred during Cert Check monitor create mutation
	Errors []SyntheticsMonitorCreateError `json:"errors"`
	// The resulting Cert Check monitor
	Monitor SyntheticsCertCheckMonitor `json:"monitor,omitempty"`
}

// SyntheticsCertCheckMonitorUpdateMutationResult - The result of a Cert Check monitor update mutation
type SyntheticsCertCheckMonitorUpdateMutationResult struct {
	// Errors that occurred during Cert Check monitor update mutation
	Errors []SyntheticsMonitorUpdateError `json:"errors"`
	// The resulting Cert Check monitor
	Monitor SyntheticsCertCheckMonitor `json:"monitor,omitempty"`
}

// SyntheticsCreateBrokenLinksMonitorInput - The monitor input values needed to create a Broken Links monitor
type SyntheticsCreateBrokenLinksMonitorInput struct {
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period"`
	// The runtime that the monitor will use to run jobs. The only accepted values are runtimeType: NODE_API & runtimeTypeVersion: 16.10
	Runtime *SyntheticsExtendedTypeMonitorRuntimeInput `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri"`
}

// SyntheticsCreateCertCheckMonitorInput - The monitor input values needed to create a Cert Check monitor
type SyntheticsCreateCertCheckMonitorInput struct {
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The domain of the host that will have its certificate checked
	Domain string `json:"domain"`
	// The locations the monitor will run from
	Locations SyntheticsLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name"`
	// The desired number of remaining days until the certificate expires to trigger a monitor failure
	NumberDaysToFailBeforeCertExpires int `json:"numberDaysToFailBeforeCertExpires"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period"`
	// The runtime that the monitor will use to run jobs. The only accepted values are runtimeType: NODE_API & runtimeTypeVersion: 16.10
	Runtime *SyntheticsExtendedTypeMonitorRuntimeInput `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
}

// SyntheticsCreateScriptAPIMonitorInput - The monitor input values needed to create a Script Api monitor
type SyntheticsCreateScriptAPIMonitorInput struct {
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsScriptedMonitorLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period"`
	// The runtime that the monitor will use to run jobs
	Runtime *SyntheticsRuntimeInput `json:"runtime,omitempty"`
	// The script that the monitor runs
	Script string `json:"script"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
}

// SyntheticsCreateScriptBrowserMonitorInput - The monitor input values needed to create a Script Browser monitor
type SyntheticsCreateScriptBrowserMonitorInput struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsScriptBrowserMonitorAdvancedOptionsInput `json:"advancedOptions,omitempty"`
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The devices that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsScriptedMonitorLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period"`
	// The runtime that the monitor will use to run jobs
	Runtime *SyntheticsRuntimeInput `json:"runtime,omitempty"`
	// The script that the monitor runs
	Script string `json:"script"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
}

// SyntheticsCreateSimpleBrowserMonitorInput - The monitor input values needed to create a Simple Browser monitor
type SyntheticsCreateSimpleBrowserMonitorInput struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsSimpleBrowserMonitorAdvancedOptionsInput `json:"advancedOptions,omitempty"`
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The devices that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period"`
	// The runtime that the monitor will use to run jobs
	Runtime *SyntheticsRuntimeInput `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri"`
}

// SyntheticsCreateSimpleMonitorInput - The monitor input values needed to create a Simple (ping) monitor
type SyntheticsCreateSimpleMonitorInput struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsSimpleMonitorAdvancedOptionsInput `json:"advancedOptions,omitempty"`
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri"`
}

// SyntheticsCreateStepMonitorInput - The monitor input values needed to create a Step monitor
type SyntheticsCreateStepMonitorInput struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsStepMonitorAdvancedOptionsInput `json:"advancedOptions,omitempty"`
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The devices that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsScriptedMonitorLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period"`
	// The runtime that the monitor will use to run jobs. The only accepted values are runtimeType: CHROME_BROWSER & runtimeTypeVersion: 100
	Runtime *SyntheticsExtendedTypeMonitorRuntimeInput `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status"`
	// The steps that make up the script the monitor will run
	Steps []SyntheticsStepInput `json:"steps,omitempty"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
}

// SyntheticsCustomHeader - Custom header for monitor jobs
type SyntheticsCustomHeader struct {
	// Header name
	Name string `json:"name"`
	// Header value
	Value string `json:"value"`
}

// SyntheticsCustomHeaderInput - Custom header input for monitor jobs
type SyntheticsCustomHeaderInput struct {
	// Header name
	Name string `json:"name"`
	// Header value
	Value string `json:"value"`
}

// SyntheticsDailyMonitorDowntimeMutationResult - Monitor downtime object returned to the customer for a downtime run daily
type SyntheticsDailyMonitorDowntimeMutationResult struct {
	// The account ID associated with the monitor downtime
	AccountID int `json:"accountId,omitempty"`
	// Configuration options if the customer wants the monitor to end at a specific date
	EndRepeat SyntheticsDateWindowEndOutput `json:"endRepeat,omitempty"`
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// The entity GUID associated with the monitor downtime
	GUID EntityGUID `json:"guid,omitempty"`
	// The monitor GUIDs associated with the monitor downtime
	MonitorGUIDs []EntityGUID `json:"monitorGuids,omitempty"`
	// The name of the monitor downtime
	Name string `json:"name,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

// SyntheticsDateWindowEndConfig - Configuration options for when a monitor downtime should end
type SyntheticsDateWindowEndConfig struct {
	// End the monitor downtime on a particular date
	OnDate Date `json:"onDate,omitempty"`
	// End the monitor downtime after a set number of occurrences
	OnRepeat int `json:"onRepeat,omitempty"`
}

// SyntheticsDateWindowEndOutput - Configuration options for when a monitor downtime should end
type SyntheticsDateWindowEndOutput struct {
	// End the monitor downtime on a particular date
	OnDate Date `json:"onDate,omitempty"`
	// End the monitor downtime after a set number of occurrences
	OnRepeat int `json:"onRepeat,omitempty"`
}

// SyntheticsDaysOfWeek - Configuration options for a monthly monitor downtime that runs on days of the week
type SyntheticsDaysOfWeek struct {
	// Which occurrence of the day selected within the month
	OrdinalDayOfMonth SyntheticsMonitorDowntimeDayOfMonthOrdinal `json:"ordinalDayOfMonth"`
	// Which day of the week the monitor downtime runs
	WeekDay SyntheticsMonitorDowntimeWeekDays `json:"weekDay"`
}

// SyntheticsDaysOfWeekOutput - Configuration options for a monthly monitor downtime that runs on days of the week
type SyntheticsDaysOfWeekOutput struct {
	// Which occurrence of the day selected within the month
	OrdinalDayOfMonth SyntheticsMonitorDowntimeDayOfMonthOrdinal `json:"ordinalDayOfMonth,omitempty"`
	// Which day of the week the monitor downtime runs
	WeekDay SyntheticsMonitorDowntimeWeekDays `json:"weekDay,omitempty"`
}

// SyntheticsDeviceEmulation - Information related to device emulation - will be deprecated soon
type SyntheticsDeviceEmulation struct {
	// The device orientation the user would like to represent
	DeviceOrientation SyntheticsDeviceOrientation `json:"deviceOrientation"`
	// The device type that a user can select
	DeviceType SyntheticsDeviceType `json:"deviceType"`
}

// SyntheticsDeviceEmulationInput - Information related to device browser emulation
type SyntheticsDeviceEmulationInput struct {
	// The device orientation the user would like to represent
	DeviceOrientation SyntheticsDeviceOrientation `json:"deviceOrientation"`
	// The device type that a user can select
	DeviceType SyntheticsDeviceType `json:"deviceType"`
}

// SyntheticsError - Error object for Synthetics mutations
type SyntheticsError struct {
	// Description explaining the cause of the error
	Description string `json:"description,omitempty"`
}

// SyntheticsExtendedTypeMonitorRuntime - The runtime that a step monitor runs
type SyntheticsExtendedTypeMonitorRuntime struct {
	// The runtime type that the monitor will run
	RuntimeType string `json:"runtimeType,omitempty"`
	// The specific version of the runtime type selected
	RuntimeTypeVersion SemVer `json:"runtimeTypeVersion,omitempty"`
}

// SyntheticsExtendedTypeMonitorRuntimeInput - Input to determine which runtime the step monitor will run
type SyntheticsExtendedTypeMonitorRuntimeInput struct {
	// The runtime type that the monitor will run.
	RuntimeType string `json:"runtimeType"`
	// The specific version of the runtime type selected.
	RuntimeTypeVersion SemVer `json:"runtimeTypeVersion"`
}

// SyntheticsLocations - The location(s) from which the monitor runs
type SyntheticsLocations struct {
	// Existing private location(s) in which the monitor will run
	Private []string `json:"private,omitempty"`
	// Publicly available location(s) in which the monitor will run. For formatting tips, see [this link](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-synthetics-tutorial/#location-field)
	Public []string `json:"public,omitempty"`
}

// SyntheticsLocationsInput - The location(s) from which a non-scripted monitor runs
type SyntheticsLocationsInput struct {
	// Existing private location(s) in which the monitor will run
	Private []string `json:"private,omitempty"`
	// Publicly available location(s) in which the monitor will run. For formatting tips, see [this link](https://docs.newrelic.com/docs/apis/nerdgraph/examples/nerdgraph-synthetics-tutorial/#location-field)
	Public []string `json:"public,omitempty"`
}

// SyntheticsMonitorCreateError - Error object for Synthetics monitor creation request
type SyntheticsMonitorCreateError struct {
	// String description of error
	Description string `json:"description"`
	// Enum of error that was returned during monitor creation
	Type SyntheticsMonitorCreateErrorType `json:"type"`
}

// SyntheticsMonitorDeleteMutationResult - The result of a monitor delete mutation
type SyntheticsMonitorDeleteMutationResult struct {
	// The unique identifier of the deleted monitor
	DeletedGUID EntityGUID `json:"deletedGuid,omitempty"`
}

// SyntheticsMonitorDowntimeDailyConfig - Configuration options for a monitor downtime that runs daily
type SyntheticsMonitorDowntimeDailyConfig struct {
	// Configuration options if the customer wants the monitor to end at a specific date
	EndRepeat SyntheticsDateWindowEndConfig `json:"endRepeat,omitempty"`
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

// SyntheticsMonitorDowntimeDeleteResult - Monitor downtime object returned to the customer once a monitor downtime is deleted
type SyntheticsMonitorDowntimeDeleteResult struct {
	// The entity guid of the deleted MonitorDowntime
	GUID EntityGUID `json:"guid,omitempty"`
}

// SyntheticsMonitorDowntimeMonthlyConfig - Configuration options for a monitor downtime that runs monthly
type SyntheticsMonitorDowntimeMonthlyConfig struct {
	// Configuration options if the customer wants the monitor to end at a specific date
	EndRepeat SyntheticsDateWindowEndConfig `json:"endRepeat,omitempty"`
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// Configuration options for which days of the month a monitor downtime will occur
	Frequency SyntheticsMonitorDowntimeMonthlyFrequency `json:"frequency,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

// SyntheticsMonitorDowntimeMonthlyFrequency - Configuration options for when a monthly monitor downtime should run
type SyntheticsMonitorDowntimeMonthlyFrequency struct {
	// Which dates a monitor downtime is run (only 1 of these can be selected)
	DaysOfMonth []int `json:"daysOfMonth,omitempty"`
	// Which weekdays in the month the monitor downtime will run (only 1 of these can be selected)
	DaysOfWeek *SyntheticsDaysOfWeek `json:"daysOfWeek,omitempty"`
}

// SyntheticsMonitorDowntimeMonthlyFrequencyOutput - Configuration options for when a monthly monitor downtime should run
type SyntheticsMonitorDowntimeMonthlyFrequencyOutput struct {
	// Which dates a monitor downtime is run
	//  (only 1 of these can be selected)
	DaysOfMonth []int `json:"daysOfMonth,omitempty"`
	// Which weekdays in the month the monitor downtime will run
	//  (only 1 of these can be selected)
	DaysOfWeek SyntheticsDaysOfWeekOutput `json:"daysOfWeek,omitempty"`
}

// SyntheticsMonitorDowntimeMutationResult - Monitor downtime object returned to the customer for an edit mutation
type SyntheticsMonitorDowntimeMutationResult struct {
	// The account ID associated with the monitor downtime
	AccountID int `json:"accountId,omitempty"`
	// Configuration options if the customer wants the monitor to end at a specific date
	EndRepeat SyntheticsDateWindowEndOutput `json:"endRepeat,omitempty"`
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// Configuration options for which days of the month a monitor downtime will occur
	Frequency SyntheticsMonitorDowntimeMonthlyFrequencyOutput `json:"frequency,omitempty"`
	// The entity GUID associated with the monitor downtime
	GUID EntityGUID `json:"guid,omitempty"`
	// Days of the week the monitor downtime will run
	MaintenanceDays []SyntheticsMonitorDowntimeWeekDays `json:"maintenanceDays,omitempty"`
	// The monitor GUIDs associated with the monitor downtime
	MonitorGUIDs []EntityGUID `json:"monitorGuids,omitempty"`
	// The name of the monitor downtime
	Name string `json:"name,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

// SyntheticsMonitorDowntimeOnceConfig - Configuration options for a monitor downtime that runs once
type SyntheticsMonitorDowntimeOnceConfig struct {
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

// SyntheticsMonitorDowntimeWeeklyConfig - Configuration options for a monitor downtime that runs weekly
type SyntheticsMonitorDowntimeWeeklyConfig struct {
	// Configuration options if the customer wants the monitor to end at a specific date
	EndRepeat SyntheticsDateWindowEndConfig `json:"endRepeat,omitempty"`
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// Configuration options if the customer wants the monitor to end at a specific date
	MaintenanceDays []SyntheticsMonitorDowntimeWeekDays `json:"maintenanceDays,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

// SyntheticsMonitorScriptQueryResponse - The script that a monitor runs
type SyntheticsMonitorScriptQueryResponse struct {
	// The script associated with the specified monitor
	Text string `json:"text,omitempty"`
}

// SyntheticsMonitorUpdateError - Error object for Synthetics monitor update request
type SyntheticsMonitorUpdateError struct {
	// String description of error
	Description string `json:"description"`
	// Enum of error that was returned during monitor update
	Type SyntheticsMonitorUpdateErrorType `json:"type"`
}

// SyntheticsMonthlyMonitorDowntimeMutationResult - Monitor downtime object returned to the customer for a downtime run monthly
type SyntheticsMonthlyMonitorDowntimeMutationResult struct {
	// The account ID associated with the monitor downtime
	AccountID int `json:"accountId,omitempty"`
	// Configuration options if the customer wants the monitor to end at a specific date
	EndRepeat SyntheticsDateWindowEndOutput `json:"endRepeat,omitempty"`
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// Configuration options for which days of the month a monitor downtime will occur
	Frequency SyntheticsMonitorDowntimeMonthlyFrequencyOutput `json:"frequency,omitempty"`
	// The entity GUID associated with the monitor downtime
	GUID EntityGUID `json:"guid,omitempty"`
	// The monitor GUIDs associated with the monitor downtime
	MonitorGUIDs []EntityGUID `json:"monitorGuids,omitempty"`
	// The name of the monitor downtime
	Name string `json:"name,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

// SyntheticsOnceMonitorDowntimeMutationResult - Monitor downtime object returned to the customer for a downtime run once
type SyntheticsOnceMonitorDowntimeMutationResult struct {
	// The account ID associated with the monitor downtime
	AccountID int `json:"accountId,omitempty"`
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// The entity GUID associated with the monitor downtime
	GUID EntityGUID `json:"guid,omitempty"`
	// The monitor GUIDs associated with the monitor downtime
	MonitorGUIDs []EntityGUID `json:"monitorGuids,omitempty"`
	// The name of the monitor downtime
	Name string `json:"name,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

// SyntheticsPrivateLocationDeleteResult - An array containing errors from the deletion of a private location, if any
type SyntheticsPrivateLocationDeleteResult struct {
	// An array container errors resulting from the mutation, if any
	Errors []SyntheticsPrivateLocationMutationError `json:"errors,omitempty"`
}

// SyntheticsPrivateLocationInput - Information realating to a private location
type SyntheticsPrivateLocationInput struct {
	// The unique identifier for the Synthetics private location in New Relic
	GUID string `json:"guid"`
	// The location's Verified Script Execution password (Only necessary if Verified Script Execution is enabled for the location)
	VsePassword SecureValue `json:"vsePassword,omitempty"`
}

// SyntheticsPrivateLocationMutationError - Error object for Synthetic Private Location mutation request
type SyntheticsPrivateLocationMutationError struct {
	// String description of error
	Description string `json:"description"`
	// Enum type of error response
	Type SyntheticsPrivateLocationMutationErrorType `json:"type"`
}

// SyntheticsPrivateLocationMutationResult - Result of a private location mutation
type SyntheticsPrivateLocationMutationResult struct {
	// The account associated to the private location
	AccountID int `json:"accountId,omitempty"`
	// A description of the private location
	Description string `json:"description,omitempty"`
	// The private location globally unique identifier
	DomainId string `json:"domainId,omitempty"`
	// An array container errors resulting from the mutation, if any
	Errors []SyntheticsPrivateLocationMutationError `json:"errors,omitempty"`
	// The unique client identifier for the Synthetics private location in New Relic
	GUID EntityGUID `json:"guid,omitempty"`
	// The private locations key
	Key string `json:"key,omitempty"`
	// An alternate identifier based on name
	LocationId string `json:"locationId,omitempty"`
	// The name of the private location
	Name string `json:"name,omitempty"`
	// Specifies whether the private location requires a password for scripted monitors
	VerifiedScriptExecution bool `json:"verifiedScriptExecution,omitempty"`
}

// SyntheticsPrivateLocationPurgeQueueResult - Result of a Synthetics purge private location queue mutation
type SyntheticsPrivateLocationPurgeQueueResult struct {
	// An array containing errors resulting from the mutation, if any
	Errors []SyntheticsPrivateLocationMutationError `json:"errors,omitempty"`
}

// SyntheticsRuntime - The runtime that a monitor runs
type SyntheticsRuntime struct {
	// The runtime type that the monitor will run
	RuntimeType string `json:"runtimeType,omitempty"`
	// The specific version of the runtime type selected
	RuntimeTypeVersion SemVer `json:"runtimeTypeVersion"`
	// The programing language that should execute the script
	ScriptLanguage string `json:"scriptLanguage,omitempty"`
}

// SyntheticsRuntimeInput - Input to determine which runtime the monitor will run
type SyntheticsRuntimeInput struct {
	// The runtime type that the monitor will run
	RuntimeType string `json:"runtimeType"`
	// The specific version of the runtime type selected
	RuntimeTypeVersion SemVer `json:"runtimeTypeVersion"`
	// The programing language that should execute the script
	ScriptLanguage string `json:"scriptLanguage,omitempty"`
}

// SyntheticsScriptAPIMonitor - A Script Api monitor resulting from a Script Api mutation
type SyntheticsScriptAPIMonitor struct {
	// The creation time of the monitor in millis
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	GUID EntityGUID `json:"guid,omitempty"`
	// The unique identifier of the monitor within the Synthetics domain
	ID string `json:"id,omitempty"`
	// The locations the monitor runs from
	Locations SyntheticsLocations `json:"locations,omitempty"`
	// The last modification time of the monitor in millis
	ModifiedAt *nrtime.EpochMilliseconds `json:"modifiedAt,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime SyntheticsRuntime `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
}

// SyntheticsScriptAPIMonitorCreateMutationResult - The result of a Script Api monitor create mutation
type SyntheticsScriptAPIMonitorCreateMutationResult struct {
	// Errors that occurred during Script Api monitor create mutation
	Errors []SyntheticsMonitorCreateError `json:"errors"`
	// The resulting Script Api monitor
	Monitor SyntheticsScriptAPIMonitor `json:"monitor,omitempty"`
}

// SyntheticsScriptAPIMonitorUpdateMutationResult - The result of a Script Api monitor update mutation
type SyntheticsScriptAPIMonitorUpdateMutationResult struct {
	// Errors that occurred during Script Api monitor update mutation
	Errors []SyntheticsMonitorUpdateError `json:"errors"`
	// The resulting Script Api monitor
	Monitor SyntheticsScriptAPIMonitor `json:"monitor,omitempty"`
}

// SyntheticsScriptBrowserMonitor - A Script Browser monitor resulting from a Script Browser mutation
type SyntheticsScriptBrowserMonitor struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsScriptBrowserMonitorAdvancedOptions `json:"advancedOptions,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The creation time of the monitor in millis
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The devices that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	GUID EntityGUID `json:"guid,omitempty"`
	// The unique identifier of the monitor within the Synthetics domain
	ID string `json:"id,omitempty"`
	// The locations the monitor runs from
	Locations SyntheticsLocations `json:"locations,omitempty"`
	// The last modification time of the monitor in millis
	ModifiedAt *nrtime.EpochMilliseconds `json:"modifiedAt,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime SyntheticsRuntime `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
}

// SyntheticsScriptBrowserMonitorAdvancedOptions - The advanced options available for a Script Browser monitor
type SyntheticsScriptBrowserMonitorAdvancedOptions struct {
	// Emulate a device
	DeviceEmulation SyntheticsDeviceEmulation `json:"deviceEmulation,omitempty"`
	// Capture a screenshot during job execution
	EnableScreenshotOnFailureAndScript *bool `json:"enableScreenshotOnFailureAndScript,omitempty"`
}

// SyntheticsScriptBrowserMonitorAdvancedOptionsInput - The advanced options inputs available for a Script Browser monitor
type SyntheticsScriptBrowserMonitorAdvancedOptionsInput struct {
	// Emulate a device
	DeviceEmulation *SyntheticsDeviceEmulationInput `json:"deviceEmulation,omitempty"`
	// Capture a screenshot during job execution
	EnableScreenshotOnFailureAndScript *bool `json:"enableScreenshotOnFailureAndScript,omitempty"`
}

// SyntheticsScriptBrowserMonitorCreateMutationResult - The result of a Script Browser monitor create mutation
type SyntheticsScriptBrowserMonitorCreateMutationResult struct {
	// Errors that occurred during Script Browser monitor create mutation
	Errors []SyntheticsMonitorCreateError `json:"errors"`
	// The resulting script browser monitor
	Monitor SyntheticsScriptBrowserMonitor `json:"monitor,omitempty"`
}

// SyntheticsScriptBrowserMonitorUpdateMutationResult - The result of a Script Browser monitor update mutation
type SyntheticsScriptBrowserMonitorUpdateMutationResult struct {
	// Errors that occurred during Script Browser monitor update mutation
	Errors []SyntheticsMonitorUpdateError `json:"errors"`
	// The resulting script browser monitor
	Monitor SyntheticsScriptBrowserMonitor `json:"monitor,omitempty"`
}

// SyntheticsScriptDomainOverride - Override a script url domain
type SyntheticsScriptDomainOverride struct {
	// The target domain to override
	Domain string `json:"domain,omitempty"`
	// The override value for the domain
	Override string `json:"override,omitempty"`
}

// SyntheticsScriptDomainOverrideInput - Override a script url domain
type SyntheticsScriptDomainOverrideInput struct {
	// The target domain to override
	Domain string `json:"domain,omitempty" yaml:"domain,omitempty"`
	// The override value for the domain
	Override string `json:"override,omitempty" yaml:"override,omitempty"`
}

// SyntheticsScriptedMonitorLocationsInput - The location(s) from which the scripted monitor runs.
type SyntheticsScriptedMonitorLocationsInput struct {
	// The private location(s) that the monitor will run jobs from
	Private []SyntheticsPrivateLocationInput `json:"private,omitempty"`
	// The public location(s) that the monitor will run jobs from
	Public []string `json:"public"`
}

// SyntheticsSecureCredentialMutationResult - The result of a secure credential mutation
type SyntheticsSecureCredentialMutationResult struct {
	// The moment when the secure credential was created, represented in milliseconds since the Unix epoch.
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// Description of the secure credential, if available
	Description string `json:"description,omitempty"`
	// An array containing errors, if any
	Errors []SyntheticsError `json:"errors,omitempty"`
	// The unique identifier of the secure credential, if available
	Key string `json:"key,omitempty"`
	// The moment when the secure credential was last updated, represented in milliseconds since the Unix epoch.
	LastUpdate *nrtime.EpochMilliseconds `json:"lastUpdate,omitempty"`
}

// SyntheticsSecureCredentialOverride - Override a monitor scripts secure credential key with a different key
type SyntheticsSecureCredentialOverride struct {
	// The target secure credential key to override
	Key string `json:"key,omitempty"`
	// The secure credential key override
	OverrideKey string `json:"overrideKey,omitempty"`
}

// SyntheticsSecureCredentialOverrideInput - Override a monitor scripts secure credential key with a different key
type SyntheticsSecureCredentialOverrideInput struct {
	// The target secure credential key to override
	Key string `json:"key,omitempty" yaml:"key,omitempty"`
	// The secure credential key override
	OverrideKey string `json:"overrideKey,omitempty" yaml:"overrideKey,omitempty"`
}

// SyntheticsSimpleBrowserMonitor - A Simple Browser monitor resulting from a Simple Browser monitor mutation
type SyntheticsSimpleBrowserMonitor struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsSimpleBrowserMonitorAdvancedOptions `json:"advancedOptions,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The creation time of the monitor in millis
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The devices that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	GUID EntityGUID `json:"guid,omitempty"`
	// The unique identifier of the monitor within the Synthetics domain
	ID string `json:"id,omitempty"`
	// The locations the monitor runs from
	Locations SyntheticsLocations `json:"locations,omitempty"`
	// The last modification time of the monitor in millis
	ModifiedAt *nrtime.EpochMilliseconds `json:"modifiedAt,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime SyntheticsRuntime `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri,omitempty"`
}

// SyntheticsSimpleBrowserMonitorAdvancedOptions - The advanced options available for a Simple Browser monitor
type SyntheticsSimpleBrowserMonitorAdvancedOptions struct {
	// Custom headers to use in monitor job
	CustomHeaders []SyntheticsCustomHeader `json:"customHeaders,omitempty"`
	// Emulate a device
	DeviceEmulation SyntheticsDeviceEmulation `json:"deviceEmulation,omitempty"`
	// Capture a screenshot during job execution
	EnableScreenshotOnFailureAndScript *bool `json:"enableScreenshotOnFailureAndScript,omitempty"`
	// Validation text for monitor to search for at given URI
	ResponseValidationText string `json:"responseValidationText,omitempty"`
	// Monitor should validate SSL certificate chain
	UseTlsValidation *bool `json:"useTlsValidation,omitempty"`
}

// SyntheticsSimpleBrowserMonitorAdvancedOptionsInput - The advanced options inputs available for a Simple Browser monitor
type SyntheticsSimpleBrowserMonitorAdvancedOptionsInput struct {
	// Custom headers to use in monitor job
	CustomHeaders *[]SyntheticsCustomHeaderInput `json:"customHeaders,omitempty"`
	// Emulate a device
	DeviceEmulation *SyntheticsDeviceEmulationInput `json:"deviceEmulation,omitempty"`
	// Capture a screenshot during job execution
	EnableScreenshotOnFailureAndScript *bool `json:"enableScreenshotOnFailureAndScript,omitempty"`
	// Validation text for monitor to search for at given URI
	ResponseValidationText string `json:"responseValidationText,omitempty"`
	// Monitor should validate SSL certificate chain
	UseTlsValidation *bool `json:"useTlsValidation,omitempty"`
}

// SyntheticsSimpleBrowserMonitorCreateMutationResult - The result of a Simple Browser monitor create mutation
type SyntheticsSimpleBrowserMonitorCreateMutationResult struct {
	// Errors that occurred during Simple Browser monitor create mutation
	Errors []SyntheticsMonitorCreateError `json:"errors"`
	// The resulting Simple Browser monitor
	Monitor SyntheticsSimpleBrowserMonitor `json:"monitor,omitempty"`
}

// SyntheticsSimpleBrowserMonitorUpdateMutationResult - The result of a Simple Browser monitor update mutation
type SyntheticsSimpleBrowserMonitorUpdateMutationResult struct {
	// Errors that occurred during Simple Browser monitor update mutation
	Errors []SyntheticsMonitorUpdateError `json:"errors"`
	// The resulting Simple Browser monitor
	Monitor SyntheticsSimpleBrowserMonitor `json:"monitor,omitempty"`
}

// SyntheticsSimpleMonitor - A Simple (ping) monitor resulting from a Simple monitor mutation
type SyntheticsSimpleMonitor struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsSimpleMonitorAdvancedOptions `json:"advancedOptions,omitempty"`
	// The creation time of the monitor in millis
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	GUID EntityGUID `json:"guid,omitempty"`
	// The unique identifier of the monitor within the Synthetics domain
	ID string `json:"id,omitempty"`
	// The locations the monitor runs from
	Locations SyntheticsLocations `json:"locations,omitempty"`
	// The last modification time of the monitor in millis
	ModifiedAt *nrtime.EpochMilliseconds `json:"modifiedAt,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri,omitempty"`
}

// SyntheticsSimpleMonitorAdvancedOptions - The advanced options available for a Simple (ping) monitor
type SyntheticsSimpleMonitorAdvancedOptions struct {
	// Custom headers to use in monitor job
	CustomHeaders []SyntheticsCustomHeader `json:"customHeaders,omitempty"`
	// Categorize redirects during a monitor job as a failure
	RedirectIsFailure *bool `json:"redirectIsFailure,omitempty"`
	// Validation text for monitor to search for at given URI
	ResponseValidationText string `json:"responseValidationText,omitempty"`
	// Monitor should skip default HEAD request and instead use GET verb in check
	ShouldBypassHeadRequest *bool `json:"shouldBypassHeadRequest,omitempty"`
	// Monitor should validate SSL certificate chain
	UseTlsValidation *bool `json:"useTlsValidation,omitempty"`
}

// SyntheticsSimpleMonitorAdvancedOptionsInput - The advanced options inputs available for a Simple (ping) monitor
type SyntheticsSimpleMonitorAdvancedOptionsInput struct {
	// Custom headers to use in monitor job
	CustomHeaders *[]SyntheticsCustomHeaderInput `json:"customHeaders,omitempty"`
	// Categorize redirects during a monitor job as a failure
	RedirectIsFailure *bool `json:"redirectIsFailure,omitempty"`
	// Validation text for monitor to search for at given URI
	ResponseValidationText string `json:"responseValidationText,omitempty"`
	// Monitor should skip default HEAD request and instead use GET verb in check
	ShouldBypassHeadRequest *bool `json:"shouldBypassHeadRequest,omitempty"`
	// Monitor should validate SSL certificate chain
	UseTlsValidation *bool `json:"useTlsValidation,omitempty"`
}

// SyntheticsSimpleMonitorUpdateMutationResult - The result of a Simple (ping) monitor update mutation
type SyntheticsSimpleMonitorUpdateMutationResult struct {
	// Errors that occurred during Simple (ping) monitor update mutation
	Errors []SyntheticsMonitorUpdateError `json:"errors"`
	// The resulting Simple (ping) monitor
	Monitor SyntheticsSimpleMonitor `json:"monitor,omitempty"`
}

// SyntheticsStep - A step that will be added to the monitor script
type SyntheticsStep struct {
	// The position of the step within the script ranging from 1-100.
	Ordinal int `json:"ordinal"`
	// The type of step to be added to the script
	Type SyntheticsStepType `json:"type"`
	// The metadata values related to the step
	Values []string `json:"values"`
}

// SyntheticsStepInput - A step that will be added to the monitor script
type SyntheticsStepInput struct {
	// The position of the step within the script ranging from 1-100.
	Ordinal int `json:"ordinal"`
	// The type of step to be added to the script
	Type SyntheticsStepType `json:"type"`
	// The metadata values related to the step
	Values []string `json:"values"`
}

// SyntheticsStepMonitor - A Step monitor resulting from a Step monitor mutation
type SyntheticsStepMonitor struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsStepMonitorAdvancedOptions `json:"advancedOptions,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The creation time of the monitor in millis
	CreatedAt *nrtime.EpochMilliseconds `json:"createdAt,omitempty"`
	// The devices that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The unique client identifier for the Synthetics Monitor in New Relic
	GUID EntityGUID `json:"guid,omitempty"`
	// The unique identifier of the monitor within the Synthetics domain
	ID string `json:"id,omitempty"`
	// The locations the monitor runs from
	Locations SyntheticsLocations `json:"locations,omitempty"`
	// The last modification time of the monitor in millis
	ModifiedAt *nrtime.EpochMilliseconds `json:"modifiedAt,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime SyntheticsExtendedTypeMonitorRuntime `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The steps that make up the script the monitor will run
	Steps []SyntheticsStep `json:"steps,omitempty"`
}

// SyntheticsStepMonitorAdvancedOptions - The advanced options available for a Step monitor
type SyntheticsStepMonitorAdvancedOptions struct {
	// Capture a screenshot during job execution
	EnableScreenshotOnFailureAndScript *bool `json:"enableScreenshotOnFailureAndScript,omitempty"`
}

// SyntheticsStepMonitorAdvancedOptionsInput - The advanced options inputs available for a Step monitor
type SyntheticsStepMonitorAdvancedOptionsInput struct {
	// Capture a screenshot during job execution
	EnableScreenshotOnFailureAndScript *bool `json:"enableScreenshotOnFailureAndScript,omitempty"`
}

// SyntheticsStepMonitorCreateMutationResult - The result of a Step monitor create mutation
type SyntheticsStepMonitorCreateMutationResult struct {
	// Errors that occurred during Step monitor create mutation
	Errors []SyntheticsMonitorCreateError `json:"errors"`
	// The resulting Step monitor
	Monitor SyntheticsStepMonitor `json:"monitor,omitempty"`
}

// SyntheticsStepMonitorUpdateMutationResult - The result of a Step monitor update mutation
type SyntheticsStepMonitorUpdateMutationResult struct {
	// Errors that occurred during Step monitor update mutation
	Errors []SyntheticsMonitorUpdateError `json:"errors"`
	// The resulting Step monitor
	Monitor SyntheticsStepMonitor `json:"monitor,omitempty"`
}

// SyntheticsTag - Tag entries for the monitor
type SyntheticsTag struct {
	// Name of the tag key
	Key string `json:"key"`
	// Values associated with the tag key
	Values []string `json:"values"`
}

// SyntheticsUpdateBrokenLinksMonitorInput - The monitor values that can be updated on a Broken Links monitor
type SyntheticsUpdateBrokenLinksMonitorInput struct {
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs. The only accepted values are runtimeType: NODE_API & runtimeTypeVersion: 16.10
	Runtime *SyntheticsExtendedTypeMonitorRuntimeInput `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri,omitempty"`
}

// SyntheticsUpdateCertCheckMonitorInput - The monitor values that can be updated on a Cert Check monitor
type SyntheticsUpdateCertCheckMonitorInput struct {
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The domain of the host that will have its certificate checked
	Domain string `json:"domain,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The desired number of remaining days until the certificate expires to trigger a monitor failure
	NumberDaysToFailBeforeCertExpires int `json:"numberDaysToFailBeforeCertExpires,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs. The only accepted values are runtimeType: NODE_API & runtimeTypeVersion: 16.10
	Runtime *SyntheticsExtendedTypeMonitorRuntimeInput `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
}

// SyntheticsUpdateScriptAPIMonitorInput - The monitor values that can be updated on a Script Api monitor
type SyntheticsUpdateScriptAPIMonitorInput struct {
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsScriptedMonitorLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime *SyntheticsRuntimeInput `json:"runtime,omitempty"`
	// The script that the monitor runs
	Script string `json:"script,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
}

// SyntheticsUpdateScriptBrowserMonitorInput - The monitor values that can be updated on a Script Browser monitor
type SyntheticsUpdateScriptBrowserMonitorInput struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsScriptBrowserMonitorAdvancedOptionsInput `json:"advancedOptions,omitempty"`
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The device(s) that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsScriptedMonitorLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime *SyntheticsRuntimeInput `json:"runtime,omitempty"`
	// The script that the monitor runs
	Script string `json:"script,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
}

// SyntheticsUpdateSimpleBrowserMonitorInput - The monitor values that can be updated on a Simple Browser monitor
type SyntheticsUpdateSimpleBrowserMonitorInput struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsSimpleBrowserMonitorAdvancedOptionsInput `json:"advancedOptions,omitempty"`
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The devices that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs
	Runtime *SyntheticsRuntimeInput `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri,omitempty"`
}

// SyntheticsUpdateSimpleMonitorInput - The monitor values that can be updated on a simple (ping) monitor
type SyntheticsUpdateSimpleMonitorInput struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsSimpleMonitorAdvancedOptionsInput `json:"advancedOptions,omitempty"`
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
	// The uri the monitor runs against
	Uri string `json:"uri,omitempty"`
}

// SyntheticsUpdateStepMonitorInput - The monitor values that can be updated on a Step monitor
type SyntheticsUpdateStepMonitorInput struct {
	// The monitor advanced options
	AdvancedOptions SyntheticsStepMonitorAdvancedOptionsInput `json:"advancedOptions,omitempty"`
	// The monitor's Apdex target used to populate SLA reports
	ApdexTarget float64 `json:"apdexTarget,omitempty"`
	// The browser(s) that the monitor will use to run jobs
	Browsers []SyntheticsBrowser `json:"browsers,omitempty"`
	// The devices that the monitor will use to run jobs
	Devices []SyntheticsDevice `json:"devices,omitempty"`
	// The locations the monitor will run from
	Locations SyntheticsScriptedMonitorLocationsInput `json:"locations,omitempty"`
	// The human readable identifier for the monitor
	Name string `json:"name,omitempty"`
	// The interval at which the monitor runs in minutes
	Period SyntheticsMonitorPeriod `json:"period,omitempty"`
	// The runtime that the monitor will use to run jobs. The only accepted values are runtimeType: CHROME_BROWSER & runtimeTypeVersion: 100
	Runtime *SyntheticsExtendedTypeMonitorRuntimeInput `json:"runtime,omitempty"`
	// The run state of the monitor
	Status SyntheticsMonitorStatus `json:"status,omitempty"`
	// The steps that make up the script the monitor will run
	Steps []SyntheticsStepInput `json:"steps,omitempty"`
	// The tags that will be associated with the monitor
	Tags []SyntheticsTag `json:"tags,omitempty"`
}

// SyntheticsWeeklyMonitorDowntimeMutationResult - Monitor downtime object returned to the customer for a downtime run weekly
type SyntheticsWeeklyMonitorDowntimeMutationResult struct {
	// The account ID associated with the monitor downtime
	AccountID int `json:"accountId,omitempty"`
	// Configuration options if the customer wants the monitor to end at a specific date
	EndRepeat SyntheticsDateWindowEndOutput `json:"endRepeat,omitempty"`
	// The date and time in which the monitor downtime will end
	EndTime NaiveDateTime `json:"endTime,omitempty"`
	// The entity GUID associated with the monitor downtime
	GUID EntityGUID `json:"guid,omitempty"`
	// Days of the week the monitor downtime will run
	MaintenanceDays []SyntheticsMonitorDowntimeWeekDays `json:"maintenanceDays,omitempty"`
	// The monitor GUIDs associated with the monitor downtime
	MonitorGUIDs []EntityGUID `json:"monitorGuids,omitempty"`
	// The name of the monitor downtime
	Name string `json:"name,omitempty"`
	// The date and time in which the monitor downtime will begin
	StartTime NaiveDateTime `json:"startTime,omitempty"`
	// The timezone the time values will be in
	Timezone string `json:"timezone,omitempty"`
}

type automatedTestResultResponse struct {
	Actor Actor `json:"actor"`
}

type scriptResponse struct {
	Actor Actor `json:"actor"`
}

type stepsResponse struct {
	Actor Actor `json:"actor"`
}

// Date - The `Date` scalar represents a date. The `Date` appears as an ISO8601 formatted string.
type Date string

// EntityGUID - An encoded Entity GUID
type EntityGUID string

// Float - The `Float` scalar type represents signed double-precision fractional
// values as specified by
// [IEEE 754](https://en.wikipedia.org/wiki/IEEE_754).
type Float string

// Milliseconds - The `Milliseconds` scalar represents a duration in milliseconds
type Milliseconds string

// NaiveDateTime - The `NaiveDateTime` scalar represents a date and time without a Time Zone. The `NaiveDateTime` appears as an ISO8601 formatted string.
type NaiveDateTime string

// Nr1CatalogRawNerdletState - Represents JSON nerdlet state data
type Nr1CatalogRawNerdletState string

// SecureValue - The `SecureValue` scalar represents a secure value, ie a password, an API key, etc.
type SecureValue string

// SemVer - The `SemVer` scalar represents a version designation conforming to the SemVer specification.
type SemVer string

// Nr1CatalogInstallPlanDirective - Information about an install plan directive
type Nr1CatalogInstallPlanDirectiveInterface interface {
	ImplementsNr1CatalogInstallPlanDirective()
}

// UnmarshalNr1CatalogInstallPlanDirectiveInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalNr1CatalogInstallPlanDirectiveInterface(b []byte) (*Nr1CatalogInstallPlanDirectiveInterface, error) {
	var err error

	var rawMessageNr1CatalogInstallPlanDirective map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageNr1CatalogInstallPlanDirective)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageNr1CatalogInstallPlanDirective) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageNr1CatalogInstallPlanDirective["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "Nr1CatalogLinkInstallPlanDirective":
			var interfaceType Nr1CatalogLinkInstallPlanDirective
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx Nr1CatalogInstallPlanDirectiveInterface = &interfaceType

			return &xxx, nil
		case "Nr1CatalogNerdletInstallPlanDirective":
			var interfaceType Nr1CatalogNerdletInstallPlanDirective
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx Nr1CatalogInstallPlanDirectiveInterface = &interfaceType

			return &xxx, nil
		case "Nr1CatalogTargetedInstallPlanDirective":
			var interfaceType Nr1CatalogTargetedInstallPlanDirective
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx Nr1CatalogInstallPlanDirectiveInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageNr1CatalogInstallPlanDirective {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface Nr1CatalogInstallPlanDirective did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface Nr1CatalogInstallPlanDirective was not matched against all PossibleTypes: %s", typeName)
}
