package synthetics

import (
	"context"
)

// NOTE: This file has NOT been generated by Tutone, and had to be manually written since the edit mutation of monitor downtime
// is unified, i.e. all types of downtimes are edited via this mutation, and this disallows setting null values of modes
// while using the mutation, as a consequence of which the SyntheticsEditMonitorDowntime function cannot be used to
// edit downtimes. Any changes to the edit mutation would need to manually be made to the four edit mutations below, without Tutone.

func (a *Synthetics) SyntheticsEditOneTimeMonitorDowntime(
	gUID EntityGUID,
	monitorGUIDs []EntityGUID,
	name string,
	once SyntheticsMonitorDowntimeOnceConfig,
) (*SyntheticsMonitorDowntimeMutationResult, error) {
	return a.SyntheticsEditOneTimeMonitorDowntimeWithContext(
		context.Background(),
		gUID,
		monitorGUIDs,
		name,
		once,
	)
}

func (a *Synthetics) SyntheticsEditOneTimeMonitorDowntimeWithContext(
	ctx context.Context,
	gUID EntityGUID,
	monitorGUIDs []EntityGUID,
	name string,
	once SyntheticsMonitorDowntimeOnceConfig,
) (*SyntheticsMonitorDowntimeMutationResult, error) {

	resp := SyntheticsEditMonitorDowntimeQueryResponse{}
	vars := map[string]interface{}{
		"guid":         gUID,
		"monitorGuids": monitorGUIDs,
		"name":         name,
		"once":         once,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, SyntheticsEditOneTimeMonitorDowntimeMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.SyntheticsMonitorDowntimeMutationResult, nil
}

func (a *Synthetics) SyntheticsEditDailyMonitorDowntime(
	gUID EntityGUID,
	monitorGUIDs []EntityGUID,
	name string,
	daily SyntheticsMonitorDowntimeDailyConfig,
) (*SyntheticsMonitorDowntimeMutationResult, error) {
	return a.SyntheticsEditDailyMonitorDowntimeWithContext(
		context.Background(),
		gUID,
		monitorGUIDs,
		name,
		daily,
	)
}

func (a *Synthetics) SyntheticsEditDailyMonitorDowntimeWithContext(
	ctx context.Context,
	gUID EntityGUID,
	monitorGUIDs []EntityGUID,
	name string,
	daily SyntheticsMonitorDowntimeDailyConfig,
) (*SyntheticsMonitorDowntimeMutationResult, error) {

	resp := SyntheticsEditMonitorDowntimeQueryResponse{}
	vars := map[string]interface{}{
		"guid":         gUID,
		"monitorGuids": monitorGUIDs,
		"name":         name,
		"daily":        daily,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, SyntheticsEditDailyMonitorDowntimeMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.SyntheticsMonitorDowntimeMutationResult, nil
}

func (a *Synthetics) SyntheticsEditWeeklyMonitorDowntime(
	gUID EntityGUID,
	monitorGUIDs []EntityGUID,
	name string,
	weekly SyntheticsMonitorDowntimeWeeklyConfig,
) (*SyntheticsMonitorDowntimeMutationResult, error) {
	return a.SyntheticsEditWeeklyMonitorDowntimeWithContext(
		context.Background(),
		gUID,
		monitorGUIDs,
		name,
		weekly,
	)
}

func (a *Synthetics) SyntheticsEditWeeklyMonitorDowntimeWithContext(
	ctx context.Context,
	gUID EntityGUID,
	monitorGUIDs []EntityGUID,
	name string,
	weekly SyntheticsMonitorDowntimeWeeklyConfig,
) (*SyntheticsMonitorDowntimeMutationResult, error) {

	resp := SyntheticsEditMonitorDowntimeQueryResponse{}
	vars := map[string]interface{}{
		"guid":         gUID,
		"monitorGuids": monitorGUIDs,
		"name":         name,
		"weekly":       weekly,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, SyntheticsEditWeeklyMonitorDowntimeMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.SyntheticsMonitorDowntimeMutationResult, nil
}

func (a *Synthetics) SyntheticsEditMonthlyMonitorDowntime(
	gUID EntityGUID,
	monitorGUIDs []EntityGUID,
	name string,
	monthly SyntheticsMonitorDowntimeMonthlyConfig,
) (*SyntheticsMonitorDowntimeMutationResult, error) {
	return a.SyntheticsEditMonthlyMonitorDowntimeWithContext(
		context.Background(),
		gUID,
		monitorGUIDs,
		name,
		monthly,
	)
}

func (a *Synthetics) SyntheticsEditMonthlyMonitorDowntimeWithContext(
	ctx context.Context,
	gUID EntityGUID,
	monitorGUIDs []EntityGUID,
	name string,
	monthly SyntheticsMonitorDowntimeMonthlyConfig,
) (*SyntheticsMonitorDowntimeMutationResult, error) {

	resp := SyntheticsEditMonitorDowntimeQueryResponse{}
	vars := map[string]interface{}{
		"guid":         gUID,
		"monitorGuids": monitorGUIDs,
		"name":         name,
		"monthly":      monthly,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, SyntheticsEditMonthlyMonitorDowntimeMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.SyntheticsMonitorDowntimeMutationResult, nil
}

const SyntheticsEditOneTimeMonitorDowntimeMutation = `mutation(
	$guid: EntityGuid!,
	$monitorGuids: [EntityGuid],
	$name: String,
	$once: SyntheticsMonitorDowntimeOnceConfig,
) { syntheticsEditMonitorDowntime(
	guid: $guid,
	monitorGuids: $monitorGuids,
	name: $name,
	once: $once,
) {
	accountId
	endTime
	guid
	monitorGuids
	name
	startTime
	timezone
} }`

const SyntheticsEditDailyMonitorDowntimeMutation = `mutation(
	$guid: EntityGuid!,
	$monitorGuids: [EntityGuid],
	$name: String,
	$daily: SyntheticsMonitorDowntimeDailyConfig,
) { syntheticsEditMonitorDowntime(
	guid: $guid,
	monitorGuids: $monitorGuids,
	name: $name,
	daily: $daily,
) {
	accountId
	endRepeat {
		onDate
		onRepeat
	}
	endTime
	guid
	monitorGuids
	name
	startTime
	timezone
} }`

const SyntheticsEditWeeklyMonitorDowntimeMutation = `mutation(
	$guid: EntityGuid!,
	$monitorGuids: [EntityGuid],
	$name: String,
	$weekly: SyntheticsMonitorDowntimeWeeklyConfig,
) { syntheticsEditMonitorDowntime(
	guid: $guid,
	monitorGuids: $monitorGuids,
	name: $name,
	weekly: $weekly,
) {
	accountId
	endRepeat {
		onDate
		onRepeat
	}
	endTime
	guid
	maintenanceDays
	monitorGuids
	name
	startTime
	timezone
} }`

const SyntheticsEditMonthlyMonitorDowntimeMutation = `mutation(
	$guid: EntityGuid!,
	$monitorGuids: [EntityGuid],
	$name: String,
	$monthly: SyntheticsMonitorDowntimeMonthlyConfig,
) { syntheticsEditMonitorDowntime(
	guid: $guid,
	monitorGuids: $monitorGuids,
	name: $name,
	monthly: $monthly,
) {
	accountId
	endRepeat {
		onDate
		onRepeat
	}
	endTime
	frequency {
		daysOfMonth
		daysOfWeek {
			ordinalDayOfMonth
			weekDay
		}
	}
	guid
	monitorGuids
	name
	startTime
	timezone
} }`
