// Code generated by tutone: DO NOT EDIT
package organization

// OrganizationRegionCodeEnum - Enums for region codes
type OrganizationRegionCodeEnum string

var OrganizationRegionCodeEnumTypes = struct {
	// Region code for EU
	EU01 OrganizationRegionCodeEnum
	// Region code for US
	US01 OrganizationRegionCodeEnum
}{
	// Region code for EU
	EU01: "EU01",
	// Region code for US
	US01: "US01",
}

// OrganizationUpdateErrorType - An enum specifying the specific types of errors that may be returned.
type OrganizationUpdateErrorType string

var OrganizationUpdateErrorTypeTypes = struct {
	// Returned when the attributes provided for an object are invalid.
	INVALID_RECORD OrganizationUpdateErrorType
	// Returned when the actor has insufficient capabilties to fulfill the request.
	NOT_AUTHORIZED OrganizationUpdateErrorType
}{
	// Returned when the attributes provided for an object are invalid.
	INVALID_RECORD: "INVALID_RECORD",
	// Returned when the actor has insufficient capabilties to fulfill the request.
	NOT_AUTHORIZED: "NOT_AUTHORIZED",
}

// OrganizationCreateOrganizationInput - Attributes belonging to the organization to create.
type OrganizationCreateOrganizationInput struct {
	// The name for the new organization.
	Name string `json:"name"`
}

// OrganizationCreateOrganizationResponse - The object that's returned from successfully creating an organization.
type OrganizationCreateOrganizationResponse struct {
	// The job id of the organization creation task; query this job id to get latest state
	JobId string `json:"jobId"`
}

// OrganizationCreateSharedAccountInput - Attributes for creating a shared account.
type OrganizationCreateSharedAccountInput struct {
	// The id of the account to be shared
	AccountID int `json:"accountId"`
	// The id of the limiting role
	LimitingRoleId int `json:"limitingRoleId"`
	// The name of the shared account
	Name string `json:"name,omitempty"`
	// The id of the target organization
	TargetOrganizationId string `json:"targetOrganizationId"`
}

// OrganizationCreateSharedAccountResponse - The object that's returned from successfully creating a shared account.
type OrganizationCreateSharedAccountResponse struct {
	// The created shared account.
	SharedAccount OrganizationSharedAccount `json:"sharedAccount,omitempty"`
}

// OrganizationError - A user-readable error
type OrganizationError struct {
	// A description of the error.
	Message string `json:"message"`
	// A description of the type of error.
	Type OrganizationUpdateErrorType `json:"type"`
}

// OrganizationInformation - The attributes of an organization.
type OrganizationInformation struct {
	// The ID of the organization.
	ID string `json:"id"`
	// The name of the organization.
	Name string `json:"name"`
}

// OrganizationNewManagedAccountInput - Attributes for creating a new managed account.
type OrganizationNewManagedAccountInput struct {
	// The name of the new account to be created.
	Name string `json:"name,omitempty"`
	// The region-code for the account to be created.
	RegionCode OrganizationRegionCodeEnum `json:"regionCode,omitempty"`
}

// OrganizationRevokeSharedAccountInput - Attributes for revoking an account share.
type OrganizationRevokeSharedAccountInput struct {
	// The id of the account share to be revoked
	ID string `json:"id"`
}

// OrganizationRevokeSharedAccountResponse - The object that's returned from successfully revoking a shared account.
type OrganizationRevokeSharedAccountResponse struct {
	// Information about the revoked shared account.
	SharedAccount OrganizationSharedAccount `json:"sharedAccount,omitempty"`
}

// OrganizationSharedAccount - The attributes of an account share.
type OrganizationSharedAccount struct {
	// The ID of the account being shared.
	AccountID int `json:"accountId"`
	// The ID of the account share.
	ID string `json:"id"`
	// The ID of the limiting role for the account share.
	LimitingRoleId int `json:"limitingRoleId"`
	// The name of the account share.
	Name string `json:"name,omitempty"`
	// The ID of the organization sending the account share.
	SourceOrganizationId string `json:"sourceOrganizationId"`
	// The name of the organization sending the account share.
	SourceOrganizationName string `json:"sourceOrganizationName,omitempty"`
	// The ID of the organization receiving the account share.
	TargetOrganizationId string `json:"targetOrganizationId"`
	// The name of the organization receiving the account share.
	TargetOrganizationName string `json:"targetOrganizationName,omitempty"`
}

// OrganizationSharedAccountInput - Attributes for creating an account share.
type OrganizationSharedAccountInput struct {
	// The id of the account to share with new organization
	AccountID int `json:"accountId"`
	// The limiting role id the new organization will be granted on for the shared account
	LimitingRoleId int `json:"limitingRoleId,omitempty"`
}

// OrganizationUpdateInput - Attributes for updating an organization.
type OrganizationUpdateInput struct {
	// The new name for the organization.
	Name string `json:"name,omitempty"`
}

// OrganizationUpdateResponse - The return object for an update mutation.
type OrganizationUpdateResponse struct {
	// A description of any errors with the mutation.
	Errors []OrganizationError `json:"errors"`
	// Information about the updated organization.
	OrganizationInformation OrganizationInformation `json:"organizationInformation,omitempty"`
}

// OrganizationUpdateSharedAccountInput - Attributes for updating an account share.
type OrganizationUpdateSharedAccountInput struct {
	// The id of the account share to be updated
	ID string `json:"id"`
	// The id of the limiting role to be updated
	LimitingRoleId int `json:"limitingRoleId"`
}

// OrganizationUpdateSharedAccountResponse - The object that's returned from successfully updating a shared account.
type OrganizationUpdateSharedAccountResponse struct {
	// Information about the updated shared account.
	SharedAccount OrganizationSharedAccount `json:"sharedAccount,omitempty"`
}
