// Code generated by tutone: DO NOT EDIT
package organization

import "context"

// The new organization to create.
func (a *Organization) OrganizationCreate(
	customerId string,
	newManagedAccount *OrganizationNewManagedAccountInput,
	organization OrganizationCreateOrganizationInput,
	sharedAccount *OrganizationSharedAccountInput,
) (*OrganizationCreateOrganizationResponse, error) {
	return a.OrganizationCreateWithContext(context.Background(),
		customerId,
		newManagedAccount,
		organization,
		sharedAccount,
	)
}

// The new organization to create.
func (a *Organization) OrganizationCreateWithContext(
	ctx context.Context,
	customerId string,
	newManagedAccount *OrganizationNewManagedAccountInput,
	organization OrganizationCreateOrganizationInput,
	sharedAccount *OrganizationSharedAccountInput,
) (*OrganizationCreateOrganizationResponse, error) {

	resp := OrganizationCreateQueryResponse{}
	vars := map[string]interface{}{
		"newManagedAccount": newManagedAccount,
		"organization":      organization,
		"sharedAccount":     sharedAccount,
	}

	// Manual change made out of Tutone's scope, to accommodate for having no customerId in the request
	// PLEASE DO NOT DELETE the following if-block
	if customerId != "" {
		vars["customerId"] = customerId
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, OrganizationCreateMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.OrganizationCreateOrganizationResponse, nil
}

type OrganizationCreateQueryResponse struct {
	OrganizationCreateOrganizationResponse OrganizationCreateOrganizationResponse `json:"OrganizationCreate"`
}

const OrganizationCreateMutation = `mutation(
	$customerId: ID,
	$newManagedAccount: OrganizationNewManagedAccountInput,
	$organization: OrganizationCreateOrganizationInput!,
	$sharedAccount: OrganizationSharedAccountInput,
) { organizationCreate(
	customerId: $customerId,
	newManagedAccount: $newManagedAccount,
	organization: $organization,
	sharedAccount: $sharedAccount,
) {
	jobId
} }`

// The shared account to revoke
func (a *Organization) OrganizationRevokeSharedAccount(
	sharedAccount OrganizationRevokeSharedAccountInput,
) (*OrganizationRevokeSharedAccountResponse, error) {
	return a.OrganizationRevokeSharedAccountWithContext(context.Background(),
		sharedAccount,
	)
}

// The shared account to revoke
func (a *Organization) OrganizationRevokeSharedAccountWithContext(
	ctx context.Context,
	sharedAccount OrganizationRevokeSharedAccountInput,
) (*OrganizationRevokeSharedAccountResponse, error) {

	resp := OrganizationRevokeSharedAccountQueryResponse{}
	vars := map[string]interface{}{
		"sharedAccount": sharedAccount,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, OrganizationRevokeSharedAccountMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.OrganizationRevokeSharedAccountResponse, nil
}

type OrganizationRevokeSharedAccountQueryResponse struct {
	OrganizationRevokeSharedAccountResponse OrganizationRevokeSharedAccountResponse `json:"OrganizationRevokeSharedAccount"`
}

const OrganizationRevokeSharedAccountMutation = `mutation(
	$sharedAccount: OrganizationRevokeSharedAccountInput!,
) { organizationRevokeSharedAccount(
	sharedAccount: $sharedAccount,
) {
	sharedAccount {
		accountId
		id
		limitingRoleId
		name
		sourceOrganizationId
		sourceOrganizationName
		targetOrganizationId
		targetOrganizationName
	}
} }`

// The organization to update
func (a *Organization) OrganizationUpdate(
	organization OrganizationUpdateInput,
	organizationId string,
) (*OrganizationUpdateResponse, error) {
	return a.OrganizationUpdateWithContext(context.Background(),
		organization,
		organizationId,
	)
}

// The organization to update
func (a *Organization) OrganizationUpdateWithContext(
	ctx context.Context,
	organization OrganizationUpdateInput,
	organizationId string,
) (*OrganizationUpdateResponse, error) {

	resp := OrganizationUpdateQueryResponse{}
	vars := map[string]interface{}{
		"organization": organization,
	}

	// Manual change made out of Tutone's scope, to accommodate for having no organizationId in the request
	// PLEASE DO NOT DELETE the following if-block
	if organizationId != "" {
		vars["organizationId"] = organizationId
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, OrganizationUpdateMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.OrganizationUpdateResponse, nil
}

type OrganizationUpdateQueryResponse struct {
	OrganizationUpdateResponse OrganizationUpdateResponse `json:"OrganizationUpdate"`
}

const OrganizationUpdateMutation = `mutation(
	$organization: OrganizationUpdateInput!,
	$organizationId: ID,
) { organizationUpdate(
	organization: $organization,
	organizationId: $organizationId,
) {
	errors {
		message
		type
	}
	organizationInformation {
		id
		name
	}
} }`

// The shared account to update
func (a *Organization) OrganizationUpdateSharedAccount(
	sharedAccount OrganizationUpdateSharedAccountInput,
) (*OrganizationUpdateSharedAccountResponse, error) {
	return a.OrganizationUpdateSharedAccountWithContext(context.Background(),
		sharedAccount,
	)
}

// The shared account to update
func (a *Organization) OrganizationUpdateSharedAccountWithContext(
	ctx context.Context,
	sharedAccount OrganizationUpdateSharedAccountInput,
) (*OrganizationUpdateSharedAccountResponse, error) {

	resp := OrganizationUpdateSharedAccountQueryResponse{}
	vars := map[string]interface{}{
		"sharedAccount": sharedAccount,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, OrganizationUpdateSharedAccountMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.OrganizationUpdateSharedAccountResponse, nil
}

type OrganizationUpdateSharedAccountQueryResponse struct {
	OrganizationUpdateSharedAccountResponse OrganizationUpdateSharedAccountResponse `json:"OrganizationUpdateSharedAccount"`
}

const OrganizationUpdateSharedAccountMutation = `mutation(
	$sharedAccount: OrganizationUpdateSharedAccountInput!,
) { organizationUpdateSharedAccount(
	sharedAccount: $sharedAccount,
) {
	sharedAccount {
		accountId
		id
		limitingRoleId
		name
		sourceOrganizationId
		sourceOrganizationName
		targetOrganizationId
		targetOrganizationName
	}
} }`
