// Code generated by tutone: DO NOT EDIT
package nrqldroprules

import (
	"github.com/newrelic/newrelic-client-go/v2/pkg/nrtime"
)

// NRQLDropRulesAction - Specifies how data matching the drop rule's NRQL string should be processed.
type NRQLDropRulesAction string

var NRQLDropRulesActionTypes = struct {
	// This action will strip the attributes specified in the SELECT clause of the NRQL string for all events that match the associated NRQL string.
	DROP_ATTRIBUTES NRQLDropRulesAction
	// This action will strip the attributes specified in the SELECT clause of the NRQL string for metric aggregates. The event type must be Metric.
	DROP_ATTRIBUTES_FROM_METRIC_AGGREGATES NRQLDropRulesAction
	// This action will drop all data that match the associated NRQL string. That string MUST be a `SELECT *`.
	DROP_DATA NRQLDropRulesAction
}{
	// This action will strip the attributes specified in the SELECT clause of the NRQL string for all events that match the associated NRQL string.
	DROP_ATTRIBUTES: "DROP_ATTRIBUTES",
	// This action will strip the attributes specified in the SELECT clause of the NRQL string for metric aggregates. The event type must be Metric.
	DROP_ATTRIBUTES_FROM_METRIC_AGGREGATES: "DROP_ATTRIBUTES_FROM_METRIC_AGGREGATES",
	// This action will drop all data that match the associated NRQL string. That string MUST be a `SELECT *`.
	DROP_DATA: "DROP_DATA",
}

// NRQLDropRulesErrorReason - General error categories.
type NRQLDropRulesErrorReason string

var NRQLDropRulesErrorReasonTypes = struct {
	// Targeted account does not have access to this feature.
	FEATURE_FLAG_DISABLED NRQLDropRulesErrorReason
	// Other errors.
	GENERAL NRQLDropRulesErrorReason
	// Something about the request was invalid.
	INVALID_INPUT NRQLDropRulesErrorReason
	// The provided NRQL string was ill formed or used invalid features.
	INVALID_QUERY NRQLDropRulesErrorReason
	// The drop rule being acted upon did not exist.
	RULE_NOT_FOUND NRQLDropRulesErrorReason
	// The current user does not have authority to perform the given action.
	USER_NOT_AUTHORIZED NRQLDropRulesErrorReason
}{
	// Targeted account does not have access to this feature.
	FEATURE_FLAG_DISABLED: "FEATURE_FLAG_DISABLED",
	// Other errors.
	GENERAL: "GENERAL",
	// Something about the request was invalid.
	INVALID_INPUT: "INVALID_INPUT",
	// The provided NRQL string was ill formed or used invalid features.
	INVALID_QUERY: "INVALID_QUERY",
	// The drop rule being acted upon did not exist.
	RULE_NOT_FOUND: "RULE_NOT_FOUND",
	// The current user does not have authority to perform the given action.
	USER_NOT_AUTHORIZED: "USER_NOT_AUTHORIZED",
}

// Account - The `Account` object provides general data about the account, as well as
// being the entry point into more detailed data about a single account.
//
// Account configuration data is queried through this object, as well as
// telemetry data that is specific to a single account.
type Account struct {
	//
	ID int `json:"id,omitempty"`
	//
	LicenseKey string `json:"licenseKey,omitempty"`
	//
	Name string `json:"name,omitempty"`
	// This field provides access to NrqlDropRules data.
	NRQLDropRules NRQLDropRulesAccountStitchedFields `json:"nrqlDropRules,omitempty"`
}

// AccountReference - The `AccountReference` object provides basic identifying information about the account.
type AccountReference struct {
	//
	ID int `json:"id,omitempty"`
	//
	Name string `json:"name,omitempty"`
}

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// The `account` field is the entry point into data that is scoped to a single account.
	Account Account `json:"account,omitempty"`
}

// NRQLDropRulesAccountStitchedFields -
type NRQLDropRulesAccountStitchedFields struct {
	// List the drop rules for the given account
	List NRQLDropRulesListDropRulesResult `json:"list,omitempty"`
}

// NRQLDropRulesCreateDropRuleFailure - Error details about the rule that failed to be created and why.
type NRQLDropRulesCreateDropRuleFailure struct {
	// Information about why the create failed.
	Error NRQLDropRulesError `json:"error"`
	// Input information about a submitted rule that was unable to be created.
	Submitted NRQLDropRulesCreateDropRuleSubmission `json:"submitted"`
}

// NRQLDropRulesCreateDropRuleInput - Details needed to create a NRQL drop rule.
type NRQLDropRulesCreateDropRuleInput struct {
	// The type of drop rule you want. This changes the way your NRQL string is interpreted.
	Action NRQLDropRulesAction `json:"action"`
	// Additional information about the rule.
	Description string `json:"description,omitempty"`
	// The NRQL string used to match data you want to take the specified action on.
	NRQL string `json:"nrql"`
}

// NRQLDropRulesCreateDropRuleResult - The result of which submitted drop rules were successfully and unsuccessfully created.
type NRQLDropRulesCreateDropRuleResult struct {
	// Rules that were not created and why.
	Failures []NRQLDropRulesCreateDropRuleFailure `json:"failures,omitempty"`
	// Rules that were successfully created.
	Successes []NRQLDropRulesDropRule `json:"successes,omitempty"`
}

// NRQLDropRulesCreateDropRuleSubmission - The details that were submitted when creating a drop rule.
type NRQLDropRulesCreateDropRuleSubmission struct {
	// The account the targeted data report to.
	AccountID int `json:"accountId"`
	// The type of drop rule you want. This changes the way your NRQL string is interpreted.
	Action NRQLDropRulesAction `json:"action"`
	// Additional information about the rule.
	Description string `json:"description,omitempty"`
	// The NRQL string used to match data you want to take the specified action on.
	NRQL string `json:"nrql"`
}

// NRQLDropRulesDeleteDropRuleFailure - Error details about the rule that failed to be deleted and why.
type NRQLDropRulesDeleteDropRuleFailure struct {
	// Information about why the delete failed.
	Error NRQLDropRulesError `json:"error"`
	// Input information about on what was unable to be deleted.
	Submitted NRQLDropRulesDeleteDropRuleSubmission `json:"submitted"`
}

// NRQLDropRulesDeleteDropRuleResult - The result of which drop rules were successfully and unsuccessfully deleted.
type NRQLDropRulesDeleteDropRuleResult struct {
	// Rules that were not deleted and why.
	Failures []NRQLDropRulesDeleteDropRuleFailure `json:"failures,omitempty"`
	// Rules that were successfully deleted.
	Successes []NRQLDropRulesDropRule `json:"successes,omitempty"`
}

// NRQLDropRulesDeleteDropRuleSubmission - The rules that were attempted to be deleted.
type NRQLDropRulesDeleteDropRuleSubmission struct {
	// Account the rule was created on.
	AccountID int `json:"accountId"`
	// Id of the rule you want to delete.
	RuleId string `json:"ruleId"`
}

// NRQLDropRulesDropRule - Details of a drop rule.
type NRQLDropRulesDropRule struct {
	// The account this drop rule targets.
	Account AccountReference `json:"account,omitempty"`
	// The account this drop rule targets.
	AccountID int `json:"accountId"`
	// The behavior of the drop rule.
	Action NRQLDropRulesAction `json:"action"`
	// The time this drop rule was created.
	CreatedAt nrtime.DateTime `json:"createdAt"`
	// The id of the user that created the drop rule.
	CreatedBy int `json:"createdBy"`
	// The user reference of the user that created the drop rule
	Creator UserReference `json:"creator,omitempty"`
	// Additional information about the rule.
	Description string `json:"description,omitempty"`
	// The unique id for the drop rule.
	ID string `json:"id"`
	// The NRQL used to match data that will receive the `action`.
	NRQL string `json:"nrql"`
	// Who or what registered this rule.
	Source string `json:"source,omitempty"`
}

// NRQLDropRulesError - Error details when processing drop rule requests.
type NRQLDropRulesError struct {
	// A detailed error message.
	Description string `json:"description"`
	// The category of error that occurred.
	Reason NRQLDropRulesErrorReason `json:"reason"`
}

// NRQLDropRulesListDropRulesResult - The result of the request to list drop rules for an account.
type NRQLDropRulesListDropRulesResult struct {
	// Information about why we could not list rules.
	Error NRQLDropRulesError `json:"error,omitempty"`
	// The list of drop rules queried on the targeted account.
	Rules []NRQLDropRulesDropRule `json:"rules,omitempty"`
}

// UserReference - The `UserReference` object provides basic identifying information about the user.
type UserReference struct {
	//
	Email string `json:"email,omitempty"`
	//
	Gravatar string `json:"gravatar,omitempty"`
	//
	ID int `json:"id,omitempty"`
	//
	Name string `json:"name,omitempty"`
}

type listResponse struct {
	Actor Actor `json:"actor"`
}
