// Code generated by tutone: DO NOT EDIT
package nrqldroprules

import "context"

// Create new drop rule(s).
func (a *Nrqldroprules) NRQLDropRulesCreate(
	accountID int,
	rules []NRQLDropRulesCreateDropRuleInput,
) (*NRQLDropRulesCreateDropRuleResult, error) {
	return a.NRQLDropRulesCreateWithContext(context.Background(),
		accountID,
		rules,
	)
}

// Create new drop rule(s).
func (a *Nrqldroprules) NRQLDropRulesCreateWithContext(
	ctx context.Context,
	accountID int,
	rules []NRQLDropRulesCreateDropRuleInput,
) (*NRQLDropRulesCreateDropRuleResult, error) {

	resp := NRQLDropRulesCreateQueryResponse{}
	vars := map[string]interface{}{
		"accountId": accountID,
		"rules":     rules,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, NRQLDropRulesCreateMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.NRQLDropRulesCreateDropRuleResult, nil
}

type NRQLDropRulesCreateQueryResponse struct {
	NRQLDropRulesCreateDropRuleResult NRQLDropRulesCreateDropRuleResult `json:"NRQLDropRulesCreate"`
}

const NRQLDropRulesCreateMutation = `mutation(
	$accountId: Int!,
	$rules: [NrqlDropRulesCreateDropRuleInput]!,
) { nrqlDropRulesCreate(
	accountId: $accountId,
	rules: $rules,
) {
	failures {
		error {
			description
			reason
		}
		submitted {
			accountId
			action
			description
			nrql
		}
	}
	successes {
		account {
			id
			name
		}
		accountId
		action
		createdAt
		createdBy
		creator {
			email
			gravatar
			id
			name
		}
		description
		id
		nrql
		source
	}
} }`

// Delete drop rule(s) by id.
func (a *Nrqldroprules) NRQLDropRulesDelete(
	accountID int,
	ruleIds []string,
) (*NRQLDropRulesDeleteDropRuleResult, error) {
	return a.NRQLDropRulesDeleteWithContext(context.Background(),
		accountID,
		ruleIds,
	)
}

// Delete drop rule(s) by id.
func (a *Nrqldroprules) NRQLDropRulesDeleteWithContext(
	ctx context.Context,
	accountID int,
	ruleIds []string,
) (*NRQLDropRulesDeleteDropRuleResult, error) {

	resp := NRQLDropRulesDeleteQueryResponse{}
	vars := map[string]interface{}{
		"accountId": accountID,
		"ruleIds":   ruleIds,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, NRQLDropRulesDeleteMutation, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.NRQLDropRulesDeleteDropRuleResult, nil
}

type NRQLDropRulesDeleteQueryResponse struct {
	NRQLDropRulesDeleteDropRuleResult NRQLDropRulesDeleteDropRuleResult `json:"NRQLDropRulesDelete"`
}

const NRQLDropRulesDeleteMutation = `mutation(
	$accountId: Int!,
	$ruleIds: [ID]!,
) { nrqlDropRulesDelete(
	accountId: $accountId,
	ruleIds: $ruleIds,
) {
	failures {
		error {
			description
			reason
		}
		submitted {
			accountId
			ruleId
		}
	}
	successes {
		account {
			id
			name
		}
		accountId
		action
		createdAt
		createdBy
		creator {
			email
			gravatar
			id
			name
		}
		description
		id
		nrql
		source
	}
} }`

// List the drop rules for the given account
func (a *Nrqldroprules) GetList(
	accountID int,
) (*NRQLDropRulesListDropRulesResult, error) {
	return a.GetListWithContext(context.Background(),
		accountID,
	)
}

// List the drop rules for the given account
func (a *Nrqldroprules) GetListWithContext(
	ctx context.Context,
	accountID int,
) (*NRQLDropRulesListDropRulesResult, error) {

	resp := listResponse{}
	vars := map[string]interface{}{
		"accountID": accountID,
	}

	if err := a.client.NerdGraphQueryWithContext(ctx, getListQuery, vars, &resp); err != nil {
		return nil, err
	}

	return &resp.Actor.Account.NRQLDropRules.List, nil
}

const getListQuery = `query(
	$accountID: Int!,
) { actor { account(id: $accountID) { nrqlDropRules { list {
	error {
		description
		reason
	}
	rules {
		account {
			id
			name
		}
		accountId
		action
		createdAt
		createdBy
		creator {
			email
			gravatar
			id
			name
		}
		description
		id
		nrql
		source
	}
} } } } }`
