// Code generated by tutone: DO NOT EDIT
package notifications

import (
	"encoding/json"
	"fmt"

	"github.com/newrelic/newrelic-client-go/v2/pkg/ai"
	"github.com/newrelic/newrelic-client-go/v2/pkg/nrtime"
)

// AiNotificationsAuthType - Authentication types
type AiNotificationsAuthType string

var AiNotificationsAuthTypeTypes = struct {
	// Basic user and password authentication
	BASIC AiNotificationsAuthType
	// Custom header based authentication
	CUSTOM_HEADERS AiNotificationsAuthType
	// OAuth based authentication
	OAUTH2 AiNotificationsAuthType
	// Token based authentication
	TOKEN AiNotificationsAuthType
}{
	// Basic user and password authentication
	BASIC: "BASIC",
	// Custom header based authentication
	CUSTOM_HEADERS: "CUSTOM_HEADERS",
	// OAuth based authentication
	OAUTH2: "OAUTH2",
	// Token based authentication
	TOKEN: "TOKEN",
}

// AiNotificationsChannelFields - Channel fields to filter by
type AiNotificationsChannelFields string

var AiNotificationsChannelFieldsTypes = struct {
	// active field
	ACTIVE AiNotificationsChannelFields
	// created timestamp field
	CREATED_AT AiNotificationsChannelFields
	// default field
	DEFAULT AiNotificationsChannelFields
	// destination id field
	DESTINATION_ID AiNotificationsChannelFields
	// name field
	NAME AiNotificationsChannelFields
	// product field
	PRODUCT AiNotificationsChannelFields
	// status field
	STATUS AiNotificationsChannelFields
	// type field
	TYPE AiNotificationsChannelFields
	// updated timestamp field
	UPDATED_AT AiNotificationsChannelFields
	// updated_by field
	UPDATED_BY AiNotificationsChannelFields
}{
	// active field
	ACTIVE: "ACTIVE",
	// created timestamp field
	CREATED_AT: "CREATED_AT",
	// default field
	DEFAULT: "DEFAULT",
	// destination id field
	DESTINATION_ID: "DESTINATION_ID",
	// name field
	NAME: "NAME",
	// product field
	PRODUCT: "PRODUCT",
	// status field
	STATUS: "STATUS",
	// type field
	TYPE: "TYPE",
	// updated timestamp field
	UPDATED_AT: "UPDATED_AT",
	// updated_by field
	UPDATED_BY: "UPDATED_BY",
}

// AiNotificationsChannelStatus - Channel statuses
type AiNotificationsChannelStatus string

var AiNotificationsChannelStatusTypes = struct {
	// Configuration Error channel status
	CONFIGURATION_ERROR AiNotificationsChannelStatus
	// Configuration Warning channel status
	CONFIGURATION_WARNING AiNotificationsChannelStatus
	// Default channel status
	DEFAULT AiNotificationsChannelStatus
	// Draft channel status
	DRAFT AiNotificationsChannelStatus
	// Error channel status
	ERROR AiNotificationsChannelStatus
	// Tested channel status
	TESTED AiNotificationsChannelStatus
	// Throttled channel status
	THROTTLED AiNotificationsChannelStatus
	// Unknown Error channel status
	UNKNOWN_ERROR AiNotificationsChannelStatus
}{
	// Configuration Error channel status
	CONFIGURATION_ERROR: "CONFIGURATION_ERROR",
	// Configuration Warning channel status
	CONFIGURATION_WARNING: "CONFIGURATION_WARNING",
	// Default channel status
	DEFAULT: "DEFAULT",
	// Draft channel status
	DRAFT: "DRAFT",
	// Error channel status
	ERROR: "ERROR",
	// Tested channel status
	TESTED: "TESTED",
	// Throttled channel status
	THROTTLED: "THROTTLED",
	// Unknown Error channel status
	UNKNOWN_ERROR: "UNKNOWN_ERROR",
}

// AiNotificationsChannelType - Channel type
type AiNotificationsChannelType string

var AiNotificationsChannelTypeTypes = struct {
	// Email channel type
	EMAIL AiNotificationsChannelType
	// Event Bridge channel type
	EVENT_BRIDGE AiNotificationsChannelType
	// Jira Classic channel type
	JIRA_CLASSIC AiNotificationsChannelType
	// Jira Nextgen channel type
	JIRA_NEXTGEN AiNotificationsChannelType
	// Mobile push channel type
	MOBILE_PUSH AiNotificationsChannelType
	// PagerDuty channel type
	PAGERDUTY_ACCOUNT_INTEGRATION AiNotificationsChannelType
	// Pager Duty channel type
	PAGERDUTY_SERVICE_INTEGRATION AiNotificationsChannelType
	// Servicenow events channel type
	SERVICENOW_EVENTS AiNotificationsChannelType
	// Servicenow incidents channel type
	SERVICENOW_INCIDENTS AiNotificationsChannelType
	// ServiceNow app channel type
	SERVICE_NOW_APP AiNotificationsChannelType
	// Slack channel type
	SLACK AiNotificationsChannelType
	// Slack Collaboration channel type
	SLACK_COLLABORATION AiNotificationsChannelType
	// Legacy Slack channel type based on Incoming Webhooks
	SLACK_LEGACY AiNotificationsChannelType
	// Webhook channel type
	WEBHOOK AiNotificationsChannelType
}{
	// Email channel type
	EMAIL: "EMAIL",
	// Event Bridge channel type
	EVENT_BRIDGE: "EVENT_BRIDGE",
	// Jira Classic channel type
	JIRA_CLASSIC: "JIRA_CLASSIC",
	// Jira Nextgen channel type
	JIRA_NEXTGEN: "JIRA_NEXTGEN",
	// Mobile push channel type
	MOBILE_PUSH: "MOBILE_PUSH",
	// PagerDuty channel type
	PAGERDUTY_ACCOUNT_INTEGRATION: "PAGERDUTY_ACCOUNT_INTEGRATION",
	// Pager Duty channel type
	PAGERDUTY_SERVICE_INTEGRATION: "PAGERDUTY_SERVICE_INTEGRATION",
	// Servicenow events channel type
	SERVICENOW_EVENTS: "SERVICENOW_EVENTS",
	// Servicenow incidents channel type
	SERVICENOW_INCIDENTS: "SERVICENOW_INCIDENTS",
	// ServiceNow app channel type
	SERVICE_NOW_APP: "SERVICE_NOW_APP",
	// Slack channel type
	SLACK: "SLACK",
	// Slack Collaboration channel type
	SLACK_COLLABORATION: "SLACK_COLLABORATION",
	// Legacy Slack channel type based on Incoming Webhooks
	SLACK_LEGACY: "SLACK_LEGACY",
	// Webhook channel type
	WEBHOOK: "WEBHOOK",
}

// AiNotificationsDestinationFields - Destination fields
type AiNotificationsDestinationFields string

var AiNotificationsDestinationFieldsTypes = struct {
	// active field
	ACTIVE AiNotificationsDestinationFields
	// created_at field
	CREATED_AT AiNotificationsDestinationFields
	// default field
	DEFAULT AiNotificationsDestinationFields
	// last_sent field
	LAST_SENT AiNotificationsDestinationFields
	// name field
	NAME AiNotificationsDestinationFields
	// status field
	STATUS AiNotificationsDestinationFields
	// type field
	TYPE AiNotificationsDestinationFields
	// updated_at field
	UPDATED_AT AiNotificationsDestinationFields
	// updated_by field
	UPDATED_BY AiNotificationsDestinationFields
}{
	// active field
	ACTIVE: "ACTIVE",
	// created_at field
	CREATED_AT: "CREATED_AT",
	// default field
	DEFAULT: "DEFAULT",
	// last_sent field
	LAST_SENT: "LAST_SENT",
	// name field
	NAME: "NAME",
	// status field
	STATUS: "STATUS",
	// type field
	TYPE: "TYPE",
	// updated_at field
	UPDATED_AT: "UPDATED_AT",
	// updated_by field
	UPDATED_BY: "UPDATED_BY",
}

// AiNotificationsDestinationStatus - Destination statuses
type AiNotificationsDestinationStatus string

var AiNotificationsDestinationStatusTypes = struct {
	// Authentication Error destination status
	AUTHENTICATION_ERROR AiNotificationsDestinationStatus
	// Authorization Error destination status
	AUTHORIZATION_ERROR AiNotificationsDestinationStatus
	// Authorization Warning destination status
	AUTHORIZATION_WARNING AiNotificationsDestinationStatus
	// Auth Error destination status
	AUTH_ERROR AiNotificationsDestinationStatus
	// Configuration Error destination status
	CONFIGURATION_ERROR AiNotificationsDestinationStatus
	// Default destination status
	DEFAULT AiNotificationsDestinationStatus
	// Draft channel status
	DRAFT AiNotificationsDestinationStatus
	// Error channel status
	ERROR AiNotificationsDestinationStatus
	// External Server Error destination status
	EXTERNAL_SERVER_ERROR AiNotificationsDestinationStatus
	// Temporary Warning destination status
	TEMPORARY_WARNING AiNotificationsDestinationStatus
	// Tested channel status
	TESTED AiNotificationsDestinationStatus
	// Throttled channel status
	THROTTLED AiNotificationsDestinationStatus
	// Throttling Warning destination status
	THROTTLING_WARNING AiNotificationsDestinationStatus
	// Timeout Error destination status
	TIMEOUT_ERROR AiNotificationsDestinationStatus
	// Uninstalled destination status
	UNINSTALLED AiNotificationsDestinationStatus
	// Unknown Error destination status
	UNKNOWN_ERROR AiNotificationsDestinationStatus
}{
	// Authentication Error destination status
	AUTHENTICATION_ERROR: "AUTHENTICATION_ERROR",
	// Authorization Error destination status
	AUTHORIZATION_ERROR: "AUTHORIZATION_ERROR",
	// Authorization Warning destination status
	AUTHORIZATION_WARNING: "AUTHORIZATION_WARNING",
	// Auth Error destination status
	AUTH_ERROR: "AUTH_ERROR",
	// Configuration Error destination status
	CONFIGURATION_ERROR: "CONFIGURATION_ERROR",
	// Default destination status
	DEFAULT: "DEFAULT",
	// Draft channel status
	DRAFT: "DRAFT",
	// Error channel status
	ERROR: "ERROR",
	// External Server Error destination status
	EXTERNAL_SERVER_ERROR: "EXTERNAL_SERVER_ERROR",
	// Temporary Warning destination status
	TEMPORARY_WARNING: "TEMPORARY_WARNING",
	// Tested channel status
	TESTED: "TESTED",
	// Throttled channel status
	THROTTLED: "THROTTLED",
	// Throttling Warning destination status
	THROTTLING_WARNING: "THROTTLING_WARNING",
	// Timeout Error destination status
	TIMEOUT_ERROR: "TIMEOUT_ERROR",
	// Uninstalled destination status
	UNINSTALLED: "UNINSTALLED",
	// Unknown Error destination status
	UNKNOWN_ERROR: "UNKNOWN_ERROR",
}

// AiNotificationsDestinationType - Destination types
type AiNotificationsDestinationType string

var AiNotificationsDestinationTypeTypes = struct {
	// Email destination type
	EMAIL AiNotificationsDestinationType
	// EventBridge destination type
	EVENT_BRIDGE AiNotificationsDestinationType
	// Jira destination type
	JIRA AiNotificationsDestinationType
	// Mobile push destination type
	MOBILE_PUSH AiNotificationsDestinationType
	// PagerDuty destination type
	PAGERDUTY_ACCOUNT_INTEGRATION AiNotificationsDestinationType
	// PagerDuty destination type}
	PAGERDUTY_SERVICE_INTEGRATION AiNotificationsDestinationType
	// ServiceNow destination type
	SERVICE_NOW AiNotificationsDestinationType
	// ServiceNow app destination type
	SERVICE_NOW_APP AiNotificationsDestinationType
	// Slack destination type
	SLACK AiNotificationsDestinationType
	// Slack Collaboration destination type
	SLACK_COLLABORATION AiNotificationsDestinationType
	// Legacy Slack destination type based on Incoming Webhooks
	SLACK_LEGACY AiNotificationsDestinationType
	// WebHook destination type
	WEBHOOK AiNotificationsDestinationType
}{
	// Email destination type
	EMAIL: "EMAIL",
	// EventBridge destination type
	EVENT_BRIDGE: "EVENT_BRIDGE",
	// Jira destination type
	JIRA: "JIRA",
	// Mobile push destination type
	MOBILE_PUSH: "MOBILE_PUSH",
	// PagerDuty destination type
	PAGERDUTY_ACCOUNT_INTEGRATION: "PAGERDUTY_ACCOUNT_INTEGRATION",
	// PagerDuty destination type}
	PAGERDUTY_SERVICE_INTEGRATION: "PAGERDUTY_SERVICE_INTEGRATION",
	// ServiceNow destination type
	SERVICE_NOW: "SERVICE_NOW",
	// ServiceNow app destination type
	SERVICE_NOW_APP: "SERVICE_NOW_APP",
	// Slack destination type
	SLACK: "SLACK",
	// Slack Collaboration destination type
	SLACK_COLLABORATION: "SLACK_COLLABORATION",
	// Legacy Slack destination type based on Incoming Webhooks
	SLACK_LEGACY: "SLACK_LEGACY",
	// WebHook destination type
	WEBHOOK: "WEBHOOK",
}

// AiNotificationsErrorType - Error types
type AiNotificationsErrorType string

var AiNotificationsErrorTypeTypes = struct {
	// Unable to connect to external service to perform this action
	CONNECTION_ERROR AiNotificationsErrorType
	// This operation could not be completed because the entity is in use
	ENTITY_IN_USE AiNotificationsErrorType
	// An external server error has occurred
	EXTERNAL_SERVER_ERROR AiNotificationsErrorType
	// Targeted account does not have access to this feature
	FEATURE_FLAG_DISABLED AiNotificationsErrorType
	// The channel name doesn't exist
	INVALID_CHANNEL_NAME AiNotificationsErrorType
	// The credentials provided were invalid, Please check them and try again
	INVALID_CREDENTIALS AiNotificationsErrorType
	// Could not provide suggestions for this key
	INVALID_KEY AiNotificationsErrorType
	// The parameter provided does not correspond to any valid entity
	INVALID_PARAMETER AiNotificationsErrorType
	// Entities limit has been reached
	LIMIT_REACHED AiNotificationsErrorType
	// User is missing capabilities
	MISSING_CAPABILITIES AiNotificationsErrorType
	// This key requires additional constraints
	MISSING_CONSTRAINTS AiNotificationsErrorType
	// At least one parameter is required to complete this action
	MISSING_PARAMETERS AiNotificationsErrorType
	// This destination does not support OAuth authentication
	OAUTH_NOT_SUPPORTED AiNotificationsErrorType
	// This destination does not provide any suggestions
	SUGGESTIONS_UNAVAILABLE AiNotificationsErrorType
	// Request did not finish within time limit
	TIMEOUT_ERROR AiNotificationsErrorType
	// The variable type is different from the example type
	TYPE_EXAMPLE_MISMATCH AiNotificationsErrorType
	// This account is not allowed to perform this action
	UNAUTHORIZED_ACCOUNT AiNotificationsErrorType
	// Received one or more unexpected parameters
	UNEXPECTED_PARAMETER AiNotificationsErrorType
	// The New Relic application was removed
	UNINSTALLED_DESTINATION AiNotificationsErrorType
	// An unknown error has occurred
	UNKNOWN_ERROR AiNotificationsErrorType
}{
	// Unable to connect to external service to perform this action
	CONNECTION_ERROR: "CONNECTION_ERROR",
	// This operation could not be completed because the entity is in use
	ENTITY_IN_USE: "ENTITY_IN_USE",
	// An external server error has occurred
	EXTERNAL_SERVER_ERROR: "EXTERNAL_SERVER_ERROR",
	// Targeted account does not have access to this feature
	FEATURE_FLAG_DISABLED: "FEATURE_FLAG_DISABLED",
	// The channel name doesn't exist
	INVALID_CHANNEL_NAME: "INVALID_CHANNEL_NAME",
	// The credentials provided were invalid, Please check them and try again
	INVALID_CREDENTIALS: "INVALID_CREDENTIALS",
	// Could not provide suggestions for this key
	INVALID_KEY: "INVALID_KEY",
	// The parameter provided does not correspond to any valid entity
	INVALID_PARAMETER: "INVALID_PARAMETER",
	// Entities limit has been reached
	LIMIT_REACHED: "LIMIT_REACHED",
	// User is missing capabilities
	MISSING_CAPABILITIES: "MISSING_CAPABILITIES",
	// This key requires additional constraints
	MISSING_CONSTRAINTS: "MISSING_CONSTRAINTS",
	// At least one parameter is required to complete this action
	MISSING_PARAMETERS: "MISSING_PARAMETERS",
	// This destination does not support OAuth authentication
	OAUTH_NOT_SUPPORTED: "OAUTH_NOT_SUPPORTED",
	// This destination does not provide any suggestions
	SUGGESTIONS_UNAVAILABLE: "SUGGESTIONS_UNAVAILABLE",
	// Request did not finish within time limit
	TIMEOUT_ERROR: "TIMEOUT_ERROR",
	// The variable type is different from the example type
	TYPE_EXAMPLE_MISMATCH: "TYPE_EXAMPLE_MISMATCH",
	// This account is not allowed to perform this action
	UNAUTHORIZED_ACCOUNT: "UNAUTHORIZED_ACCOUNT",
	// Received one or more unexpected parameters
	UNEXPECTED_PARAMETER: "UNEXPECTED_PARAMETER",
	// The New Relic application was removed
	UNINSTALLED_DESTINATION: "UNINSTALLED_DESTINATION",
	// An unknown error has occurred
	UNKNOWN_ERROR: "UNKNOWN_ERROR",
}

// AiNotificationsProduct - Product types
type AiNotificationsProduct string

var AiNotificationsProductTypes = struct {
	// Alerts product type
	ALERTS AiNotificationsProduct
	// APM product type
	APM AiNotificationsProduct
	// Change tracking product type
	CHANGE_TRACKING AiNotificationsProduct
	// CSSP (EOPs) product type
	CSSP AiNotificationsProduct
	// Discussions and comments product type
	DISCUSSIONS AiNotificationsProduct
	// Error Tracking product type
	ERROR_TRACKING AiNotificationsProduct
	// Incident Intelligence product type
	IINT AiNotificationsProduct
	// Notifications internal product type
	NTFC AiNotificationsProduct
	// Proactive Detection product type
	PD AiNotificationsProduct
	// Security product type
	SECURITY AiNotificationsProduct
	// Sharing product type
	SHARING AiNotificationsProduct
}{
	// Alerts product type
	ALERTS: "ALERTS",
	// APM product type
	APM: "APM",
	// Change tracking product type
	CHANGE_TRACKING: "CHANGE_TRACKING",
	// CSSP (EOPs) product type
	CSSP: "CSSP",
	// Discussions and comments product type
	DISCUSSIONS: "DISCUSSIONS",
	// Error Tracking product type
	ERROR_TRACKING: "ERROR_TRACKING",
	// Incident Intelligence product type
	IINT: "IINT",
	// Notifications internal product type
	NTFC: "NTFC",
	// Proactive Detection product type
	PD: "PD",
	// Security product type
	SECURITY: "SECURITY",
	// Sharing product type
	SHARING: "SHARING",
}

// AiNotificationsSortOrder - Sort order
type AiNotificationsSortOrder string

var AiNotificationsSortOrderTypes = struct {
	// Ascending sort order
	ASC AiNotificationsSortOrder
	// Descending sort order
	DESC AiNotificationsSortOrder
}{
	// Ascending sort order
	ASC: "ASC",
	// Descending sort order
	DESC: "DESC",
}

// AlertsNotificationChannelType - The type of the notification channel which determines its configuration field.
type AlertsNotificationChannelType string

var AlertsNotificationChannelTypeTypes = struct {
	// Campfire notification channel.
	CAMPFIRE AlertsNotificationChannelType
	// Email notification channel.
	EMAIL AlertsNotificationChannelType
	// HipChat notification channel.
	HIP_CHAT AlertsNotificationChannelType
	// OpsGenie notification channel.
	OPSGENIE AlertsNotificationChannelType
	// PagerDuty notification channel.
	PAGERDUTY AlertsNotificationChannelType
	// Slack notification channel.
	SLACK AlertsNotificationChannelType
	// User notification channel.
	USER AlertsNotificationChannelType
	// VictorOps notification channel.
	VICTOROPS AlertsNotificationChannelType
	// Webhook notification channel.
	WEBHOOK AlertsNotificationChannelType
	// xMatters notification channel.
	XMATTERS AlertsNotificationChannelType
}{
	// Campfire notification channel.
	CAMPFIRE: "CAMPFIRE",
	// Email notification channel.
	EMAIL: "EMAIL",
	// HipChat notification channel.
	HIP_CHAT: "HIP_CHAT",
	// OpsGenie notification channel.
	OPSGENIE: "OPSGENIE",
	// PagerDuty notification channel.
	PAGERDUTY: "PAGERDUTY",
	// Slack notification channel.
	SLACK: "SLACK",
	// User notification channel.
	USER: "USER",
	// VictorOps notification channel.
	VICTOROPS: "VICTOROPS",
	// Webhook notification channel.
	WEBHOOK: "WEBHOOK",
	// xMatters notification channel.
	XMATTERS: "XMATTERS",
}

// AlertsOpsGenieDataCenterRegion - OpsGenie data center region
type AlertsOpsGenieDataCenterRegion string

var AlertsOpsGenieDataCenterRegionTypes = struct {
	// EU data center region
	EU AlertsOpsGenieDataCenterRegion
	// US data center region
	US AlertsOpsGenieDataCenterRegion
}{
	// EU data center region
	EU: "EU",
	// US data center region
	US: "US",
}

// AlertsWebhookCustomPayloadType - Webhook custom payload type
type AlertsWebhookCustomPayloadType string

var AlertsWebhookCustomPayloadTypeTypes = struct {
	// FORM payload type
	FORM AlertsWebhookCustomPayloadType
	// JSON payload type
	JSON AlertsWebhookCustomPayloadType
}{
	// FORM payload type
	FORM: "FORM",
	// JSON payload type
	JSON: "JSON",
}

// Account - The `Account` object provides general data about the account, as well as
// being the entry point into more detailed data about a single account.
//
// Account configuration data is queried through this object, as well as
// telemetry data that is specific to a single account.
type Account struct {
	// This field provides access to AiNotifications data.
	AiNotifications AiNotificationsAccountStitchedFields `json:"aiNotifications,omitempty"`
	//
	ID int `json:"id,omitempty"`
	//
	LicenseKey string `json:"licenseKey,omitempty"`
	//
	Name string `json:"name,omitempty"`
}

// Actor - The `Actor` object contains fields that are scoped to the API user's access level.
type Actor struct {
	// The `account` field is the entry point into data that is scoped to a single account.
	Account Account `json:"account,omitempty"`
}

// AiNotificationsAccountStitchedFields -
type AiNotificationsAccountStitchedFields struct {
	// Fetch a Channel by product
	Channels AiNotificationsChannelsResponse `json:"channels,omitempty"`
	// Fetch a Destinations by type
	Destinations AiNotificationsDestinationsResponse `json:"destinations,omitempty"`
}

// AiNotificationsBasicAuthInput - Basic auth input object
type AiNotificationsBasicAuthInput struct {
	// password
	Password SecureValue `json:"password"`
	// user
	User string `json:"user"`
}

// AiNotificationsChannel - Channel object
type AiNotificationsChannel struct {
	// The accountId of the creator of the channel
	AccountID int `json:"accountId"`
	// Is channel active
	Active bool `json:"active"`
	// Channel creation time
	CreatedAt nrtime.DateTime `json:"createdAt"`
	// Related destination type
	DestinationId string `json:"destinationId"`
	// Channel id
	ID string `json:"id"`
	// Channel name
	Name string `json:"name"`
	// Related product type
	Product AiNotificationsProduct `json:"product"`
	// List of destination property types
	Properties []AiNotificationsProperty `json:"properties"`
	// Channel Status
	Status AiNotificationsChannelStatus `json:"status"`
	// Channel type
	Type AiNotificationsChannelType `json:"type"`
	// Channel last update time
	UpdatedAt nrtime.DateTime `json:"updatedAt"`
	// Message template creator userId
	UpdatedBy int `json:"updatedBy"`
}

// AiNotificationsChannelFilter - Filter channel object
type AiNotificationsChannelFilter struct {
	// active
	Active bool `json:"active,omitempty"`
	// destinationId
	DestinationId string `json:"destinationId,omitempty"`
	// id
	ID string `json:"id,omitempty"`
	// ids
	IDs []string `json:"ids"`
	// name
	Name string `json:"name,omitempty"`
	// product
	Product AiNotificationsProduct `json:"product,omitempty"`
	// property
	Property AiNotificationsPropertyFilter `json:"property,omitempty"`
	// statuses
	Statuses []AiNotificationsChannelStatus `json:"statuses"`
	// type
	Type AiNotificationsChannelType `json:"type,omitempty"`
}

// AiNotificationsChannelInput - Channel input object
type AiNotificationsChannelInput struct {
	// destinationId
	DestinationId string `json:"destinationId"`
	// name
	Name string `json:"name"`
	// product
	Product AiNotificationsProduct `json:"product"`
	// properties
	Properties []AiNotificationsPropertyInput `json:"properties,omitempty"`
	// type
	Type AiNotificationsChannelType `json:"type"`
}

// AiNotificationsChannelResponse - Response for all channel related mutations. Includes relevant channel and/or errors
type AiNotificationsChannelResponse struct {
	// Successfully mutated channel
	Channel AiNotificationsChannel `json:"channel,omitempty"`
	// Error in channel mutation
	Error ai.AiNotificationsError `json:"error,omitempty"`
	// Deprecated list of errors
	Errors []ai.AiNotificationsError `json:"errors"`
}

// AiNotificationsChannelSorter - Sort object
type AiNotificationsChannelSorter struct {
	// direction
	Direction AiNotificationsSortOrder `json:"direction"`
	// field
	Field AiNotificationsChannelFields `json:"field"`
}

// AiNotificationsChannelUpdate - Channel update object
type AiNotificationsChannelUpdate struct {
	// active
	Active bool `json:"active,omitempty"`
	// name
	Name string `json:"name,omitempty"`
	// properties
	Properties []AiNotificationsPropertyInput `json:"properties,omitempty"`
}

// AiNotificationsChannelsResponse - Channel result object
type AiNotificationsChannelsResponse struct {
	// Channel entities
	Entities []AiNotificationsChannel `json:"entities"`
	// Error in channel entities fetching
	Error AiNotificationsResponseError `json:"error,omitempty"`
	// Deprecated list of errors
	Errors []AiNotificationsResponseError `json:"errors"`
	// Cursor to get the next batch of results
	NextCursor string `json:"nextCursor,omitempty"`
	// Count of all channel entities
	TotalCount int `json:"totalCount"`
}

// AiNotificationsCredentialsInput - Credential input object
type AiNotificationsCredentialsInput struct {
	// basic
	Basic AiNotificationsBasicAuthInput `json:"basic,omitempty"`
	// customHeaders
	CustomHeaders *AiNotificationsCustomHeadersAuthInput `json:"customHeaders,omitempty"`
	// oauth2
	Oauth2 AiNotificationsOAuth2AuthInput `json:"oauth2,omitempty"`
	// token
	Token AiNotificationsTokenAuthInput `json:"token,omitempty"`
	// type
	Type AiNotificationsAuthType `json:"type"`
}

// AiNotificationsCustomHeaderInput - Custom header input object
type AiNotificationsCustomHeaderInput struct {
	// key
	Key string `json:"key"`
	// value
	Value SecureValue `json:"value,omitempty"`
}

// AiNotificationsCustomHeadersAuthInput - Custom headers auth input object
type AiNotificationsCustomHeadersAuthInput struct {
	// customHeaders
	CustomHeaders []AiNotificationsCustomHeaderInput `json:"customHeaders,omitempty"`
}

// AiNotificationsDeleteResponse - Delete response object
type AiNotificationsDeleteResponse struct {
	// Error in object deletion
	Error AiNotificationsResponseError `json:"error,omitempty"`
	// Deprecated list of errors
	Errors []AiNotificationsResponseError `json:"errors"`
	// Deleted object ids
	IDs []string `json:"ids"`
}

// AiNotificationsDestination - Destination Object
type AiNotificationsDestination struct {
	// The accountId of the creator of the destination
	AccountID int `json:"accountId"`
	// Destination active
	Active bool `json:"active"`
	// Authentication for this destination
	Auth ai.AiNotificationsAuth `json:"auth,omitempty"`
	// Destination created at
	CreatedAt nrtime.DateTime `json:"createdAt"`
	// Entity Id of the Destination
	GUID EntityGUID `json:"guid"`
	// Destination id
	ID string `json:"id"`
	// Indicates whether the user is authenticated with the destination
	IsUserAuthenticated bool `json:"isUserAuthenticated"`
	// Last time a notification was sent
	LastSent nrtime.DateTime `json:"lastSent,omitempty"`
	// Destination name
	Name string `json:"name"`
	// List of destination property types
	Properties []AiNotificationsProperty `json:"properties"`
	// URL in secure format
	SecureURL AiNotificationsSecureURL `json:"secureUrl,omitempty"`
	// Destination status
	Status AiNotificationsDestinationStatus `json:"status"`
	// Destination type
	Type AiNotificationsDestinationType `json:"type"`
	// Destination updated at
	UpdatedAt nrtime.DateTime `json:"updatedAt"`
	// Destination updated by
	UpdatedBy int `json:"updatedBy"`
}

// AiNotificationsDestinationFilter - Filter destination object
type AiNotificationsDestinationFilter struct {
	// active
	Active bool `json:"active,omitempty"`
	// authType
	AuthType AiNotificationsAuthType `json:"authType,omitempty"`
	// id
	ID string `json:"id,omitempty"`
	// ids
	IDs []string `json:"ids"`
	// name
	Name string `json:"name,omitempty"`
	// property
	Property AiNotificationsPropertyFilter `json:"property,omitempty"`
	// type
	Type AiNotificationsDestinationType `json:"type,omitempty"`
	// updatedAt
	UpdatedAt nrtime.DateTime `json:"updatedAt,omitempty"`
}

// AiNotificationsDestinationInput - Destination input object
type AiNotificationsDestinationInput struct {
	// auth
	Auth *AiNotificationsCredentialsInput `json:"auth,omitempty"`
	// name
	Name string `json:"name"`
	// properties
	Properties []AiNotificationsPropertyInput `json:"properties"`
	// secureUrl
	SecureURL *AiNotificationsSecureURLInput `json:"secureUrl,omitempty"`
	// type
	Type AiNotificationsDestinationType `json:"type"`
}

// AiNotificationsDestinationResponse - Response for all destinations related mutation. Includes relevant destination and/or errors
type AiNotificationsDestinationResponse struct {
	// Successfully mutated destination
	Destination AiNotificationsDestination `json:"destination,omitempty"`
	// Error in destination mutation
	Error ai.AiNotificationsError `json:"error,omitempty"`
	// Deprecated list of errors
	Errors []ai.AiNotificationsError `json:"errors"`
}

// AiNotificationsDestinationSorter - Sort object
type AiNotificationsDestinationSorter struct {
	// direction
	Direction AiNotificationsSortOrder `json:"direction"`
	// field
	Field AiNotificationsDestinationFields `json:"field"`
}

// AiNotificationsDestinationUpdate - Destination update object
type AiNotificationsDestinationUpdate struct {
	// active
	Active bool `json:"active,omitempty"`
	// auth
	Auth *AiNotificationsCredentialsInput `json:"auth,omitempty"`
	// disableAuth
	DisableAuth bool `json:"disableAuth,omitempty"`
	// name
	Name string `json:"name,omitempty"`
	// properties
	Properties []AiNotificationsPropertyInput `json:"properties,omitempty"`
	// secureUrl
	SecureURL *AiNotificationsSecureURLUpdate `json:"secureUrl,omitempty"`
}

// AiNotificationsDestinationsResponse - Destinations result object
type AiNotificationsDestinationsResponse struct {
	// Destination entities
	Entities []AiNotificationsDestination `json:"entities"`
	// Error in destinations entities fetching
	Error AiNotificationsResponseError `json:"error,omitempty"`
	// Deprecated list of errors
	Errors []AiNotificationsResponseError `json:"errors"`
	// Cursor to get the next batch of results
	NextCursor string `json:"nextCursor,omitempty"`
	// Count of all destination entities
	TotalCount int `json:"totalCount"`
}

// AiNotificationsOAuth2AuthInput - OAuth2 auth input object
type AiNotificationsOAuth2AuthInput struct {
	// accessTokenUrl
	AccessTokenURL string `json:"accessTokenUrl"`
	// authorizationUrl
	AuthorizationURL string `json:"authorizationUrl"`
	// clientId
	ClientId string `json:"clientId"`
	// clientSecret
	ClientSecret SecureValue `json:"clientSecret"`
	// prefix
	Prefix string `json:"prefix,omitempty"`
	// refreshInterval
	RefreshInterval int `json:"refreshInterval,omitempty"`
	// refreshToken
	RefreshToken SecureValue `json:"refreshToken,omitempty"`
	// refreshable
	Refreshable bool `json:"refreshable"`
	// scope
	Scope string `json:"scope,omitempty"`
	// token
	Token SecureValue `json:"token"`
}

// AiNotificationsProperty - Channel property Object
type AiNotificationsProperty struct {
	// Channel property display key
	DisplayValue string `json:"displayValue,omitempty"`
	// Channel property key
	Key string `json:"key"`
	// Channel property display key
	Label string `json:"label,omitempty"`
	// Channel property value
	Value string `json:"value"`
}

// AiNotificationsPropertyFilter - Filter object by property
type AiNotificationsPropertyFilter struct {
	// key
	Key string `json:"key"`
	// value
	Value string `json:"value"`
}

// AiNotificationsPropertyInput - Property object
type AiNotificationsPropertyInput struct {
	// displayValue
	DisplayValue string `json:"displayValue,omitempty"`
	// key
	Key string `json:"key"`
	// label
	Label string `json:"label,omitempty"`
	// value
	Value string `json:"value"`
}

// AiNotificationsResponseError - Response error object
type AiNotificationsResponseError struct {
	// Error description
	Description string `json:"description"`
	// Error details
	Details string `json:"details"`
	// Error type
	Type AiNotificationsErrorType `json:"type"`
}

// AiNotificationsSecureURL - URL in secure format
type AiNotificationsSecureURL struct {
	// URL prefix
	Prefix string `json:"prefix"`
}

// AiNotificationsSecureURLInput - Destination SecureUrlInput object
type AiNotificationsSecureURLInput struct {
	// prefix
	Prefix string `json:"prefix"`
	// secureSuffix
	SecureSuffix SecureValue `json:"secureSuffix"`
}

// AiNotificationsSecureURLUpdate - Destination SecureUrlUpdate object
type AiNotificationsSecureURLUpdate struct {
	// prefix
	Prefix string `json:"prefix,omitempty"`
	// secureSuffix
	SecureSuffix SecureValue `json:"secureSuffix,omitempty"`
}

// AiNotificationsTokenAuthInput - Token auth input object
type AiNotificationsTokenAuthInput struct {
	// prefix
	Prefix string `json:"prefix,omitempty"`
	// token
	Token SecureValue `json:"token"`
}

// AlertsCampfireNotificationChannel - Campfire notification channel.
type AlertsCampfireNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// Campfire channel specific configuration.
	Config AlertsCampfireNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsCampfireNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsCampfireNotificationChannelConfig - Configuration for Campfire notification channel.
type AlertsCampfireNotificationChannelConfig struct {
	// Room.
	Room string `json:"room"`
	// Subdomain.
	Subdomain string `json:"subdomain"`
	// Authentication token.
	Token SecureValue `json:"token"`
}

// AlertsEmailNotificationChannel - Email notification channel.
type AlertsEmailNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// Email channel specific configuration.
	Config AlertsEmailNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsEmailNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsEmailNotificationChannelConfig - Configuration for Email notification channel.
type AlertsEmailNotificationChannelConfig struct {
	// List of email recipients.
	Emails []string `json:"emails"`
	// Include details about the violation as a JSON attachment.
	IncludeJson bool `json:"includeJson"`
}

// AlertsHipChatNotificationChannel - HipChat notification channel.
type AlertsHipChatNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// HipChat channel specific configuration.
	Config AlertsHipChatNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsHipChatNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsHipChatNotificationChannelConfig - Configuration for HipChat notification channel.
type AlertsHipChatNotificationChannelConfig struct {
	// Authentication token.
	AuthToken SecureValue `json:"authToken"`
	// Base URL.
	BaseURL string `json:"baseUrl"`
	// Room ID.
	RoomId string `json:"roomId"`
}

// AlertsNotificationChannel - A notification channel.
type AlertsNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsNotificationChannelPoliciesResultSet - A result set containing associated policies information for a notification channel.
type AlertsNotificationChannelPoliciesResultSet struct {
	// A set of policies associated with the channel.
	Policies []AlertsNotificationChannelPolicy `json:"policies"`
	// Total number of policies associated with the channel.
	TotalCount int `json:"totalCount"`
}

// AlertsNotificationChannelPolicy - Information about a policy associated with a notification channel.
type AlertsNotificationChannelPolicy struct {
	// Policy ID.
	ID string `json:"id"`
	// Policy name.
	Name string `json:"name"`
}

// AlertsOpsGenieNotificationChannel - OpsGenie notification channel.
type AlertsOpsGenieNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// OpsGenie channel specific configuration.
	Config AlertsOpsGenieNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsOpsGenieNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsOpsGenieNotificationChannelConfig - Configuration for OpsGenie notification channel.
type AlertsOpsGenieNotificationChannelConfig struct {
	// API key.
	APIKey SecureValue `json:"apiKey"`
	// OpsGenie data center region.
	DataCenterRegion AlertsOpsGenieDataCenterRegion `json:"dataCenterRegion"`
	// List of email recipients.
	Recipients []string `json:"recipients"`
	// Tags.
	Tags []string `json:"tags"`
	// Teams.
	Teams []string `json:"teams"`
}

// AlertsPagerDutyNotificationChannel - PagerDuty notification channel.
type AlertsPagerDutyNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// PagerDuty channel specific configuration.
	Config AlertsPagerDutyNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsPagerDutyNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsPagerDutyNotificationChannelConfig - Configuration for PagerDuty notification channel.
type AlertsPagerDutyNotificationChannelConfig struct {
	// API key.
	APIKey SecureValue `json:"apiKey"`
}

// AlertsSlackNotificationChannel - Slack notification channel.
type AlertsSlackNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// Slack channel specific configuration.
	Config AlertsSlackNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsSlackNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsSlackNotificationChannelConfig - Configuration for Slack notification channel.
type AlertsSlackNotificationChannelConfig struct {
	// Slack channel name.
	TeamChannel string `json:"teamChannel,omitempty"`
	// Slack channel URL.
	URL SecureValue `json:"url"`
}

// AlertsUserNotificationChannel - User notification channel.
type AlertsUserNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// User channel specific configuration.
	Config AlertsUserNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsUserNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsUserNotificationChannelConfig - Configuration for user notification channel.
type AlertsUserNotificationChannelConfig struct {
	// User ID.
	UserID string `json:"userId"`
}

// AlertsVictorOpsNotificationChannel - VictorOps notification channel.
type AlertsVictorOpsNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// VictorOps channel specific configuration.
	Config AlertsVictorOpsNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsVictorOpsNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsVictorOpsNotificationChannelConfig - Configuration for VictorOps notification channel.
type AlertsVictorOpsNotificationChannelConfig struct {
	// Key.
	Key SecureValue `json:"key"`
	// Route key.
	RouteKey string `json:"routeKey"`
}

// AlertsWebhookBasicAuthInput - Webhook basic auth
type AlertsWebhookBasicAuthInput struct {
	// Password
	Password SecureValue `json:"password"`
	// Username
	Username string `json:"username"`
}

// AlertsWebhookCustomHeaderInput - Webhook header
type AlertsWebhookCustomHeaderInput struct {
	// Header name
	Name string `json:"name"`
	// Header value
	Value SecureValue `json:"value"`
}

// AlertsWebhookNotificationChannel - Webhook notification channel.
type AlertsWebhookNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// Webhook channel specific configuration.
	Config AlertsWebhookNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsWebhookNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsWebhookNotificationChannelConfig - Configuration for Webhook notification channel.
type AlertsWebhookNotificationChannelConfig struct {
	// Base URL.
	BaseURL string `json:"baseUrl"`
	// Basic auth.
	BasicAuth AlertsWebhookBasicAuthInput `json:"basicAuth,omitempty"`
	// Custom HTTP headers.
	CustomHttpHeaders []AlertsWebhookCustomHeaderInput `json:"customHttpHeaders"`
	// Custom payload body.
	CustomPayloadBody string `json:"customPayloadBody,omitempty"`
	// Custom payload type.
	CustomPayloadType AlertsWebhookCustomPayloadType `json:"customPayloadType,omitempty"`
}

// AlertsXMattersNotificationChannel - xMatters notification channel.
type AlertsXMattersNotificationChannel struct {
	// Policies associated with the channel.
	AssociatedPolicies AlertsNotificationChannelPoliciesResultSet `json:"associatedPolicies"`
	// xMatters channel specific configuration.
	Config AlertsXMattersNotificationChannelConfig `json:"config"`
	// Channel ID.
	ID string `json:"id"`
	// Channel name.
	Name string `json:"name"`
	// Channel type.
	Type AlertsNotificationChannelType `json:"type"`
}

func (x *AlertsXMattersNotificationChannel) ImplementsAlertsNotificationChannel() {}

// AlertsXMattersNotificationChannelConfig - Configuration for xMatters notification channel.
type AlertsXMattersNotificationChannelConfig struct {
	// Integration URL.
	IntegrationURL SecureValue `json:"integrationUrl"`
}

type channelsResponse struct {
	Actor Actor `json:"actor"`
}

type destinationsResponse struct {
	Actor Actor `json:"actor"`
}

// EntityGUID - An encoded Entity GUID
type EntityGUID string

// SecureValue - The `SecureValue` scalar represents a secure value, ie a password, an API key, etc.
type SecureValue string

// AlertsNotificationChannel - A notification channel.
type AlertsNotificationChannelInterface interface {
	ImplementsAlertsNotificationChannel()
}

// UnmarshalAlertsNotificationChannelInterface unmarshals the interface into the correct type
// based on __typename provided by GraphQL
func UnmarshalAlertsNotificationChannelInterface(b []byte) (*AlertsNotificationChannelInterface, error) {
	var err error

	var rawMessageAlertsNotificationChannel map[string]*json.RawMessage
	err = json.Unmarshal(b, &rawMessageAlertsNotificationChannel)
	if err != nil {
		return nil, err
	}

	// Nothing to unmarshal
	if len(rawMessageAlertsNotificationChannel) < 1 {
		return nil, nil
	}

	var typeName string

	if rawTypeName, ok := rawMessageAlertsNotificationChannel["__typename"]; ok {
		err = json.Unmarshal(*rawTypeName, &typeName)
		if err != nil {
			return nil, err
		}

		switch typeName {
		case "AlertsCampfireNotificationChannel":
			var interfaceType AlertsCampfireNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsEmailNotificationChannel":
			var interfaceType AlertsEmailNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsHipChatNotificationChannel":
			var interfaceType AlertsHipChatNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsOpsGenieNotificationChannel":
			var interfaceType AlertsOpsGenieNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsPagerDutyNotificationChannel":
			var interfaceType AlertsPagerDutyNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsSlackNotificationChannel":
			var interfaceType AlertsSlackNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsUserNotificationChannel":
			var interfaceType AlertsUserNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsVictorOpsNotificationChannel":
			var interfaceType AlertsVictorOpsNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsWebhookNotificationChannel":
			var interfaceType AlertsWebhookNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		case "AlertsXMattersNotificationChannel":
			var interfaceType AlertsXMattersNotificationChannel
			err = json.Unmarshal(b, &interfaceType)
			if err != nil {
				return nil, err
			}

			var xxx AlertsNotificationChannelInterface = &interfaceType

			return &xxx, nil
		}
	} else {
		keys := []string{}
		for k := range rawMessageAlertsNotificationChannel {
			keys = append(keys, k)
		}
		return nil, fmt.Errorf("interface AlertsNotificationChannel did not include a __typename field for inspection: %s", keys)
	}

	return nil, fmt.Errorf("interface AlertsNotificationChannel was not matched against all PossibleTypes: %s", typeName)
}
